/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.TIFFConstants;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.image.rendered.FormatRed;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class TIFFRenderer
extends Java2DRenderer
implements TIFFConstants {
    private ImageWriterParams writerParams = new ImageWriterParams();
    private int bufferedImageType = 2;
    private OutputStream outputStream;

    public String getMimeType() {
        return "image/tiff";
    }

    public TIFFRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        this.writerParams.setCompressionMethod("PackBits");
        int n = Math.round(fOUserAgent.getTargetResolution());
        this.writerParams.setResolution(n);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        super.startRenderer(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        Object object;
        super.stopRenderer();
        log.debug((Object)"Starting TIFF encoding ...");
        LazyPageImagesIterator lazyPageImagesIterator = new LazyPageImagesIterator(this.getNumberOfPages(), log);
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
        if (imageWriter == null) {
            object = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            object.noImageWriterFound(this, this.getMimeType());
        }
        if (imageWriter.supportsMultiImageWriter()) {
            object = imageWriter.createMultiImageWriter(this.outputStream);
            try {
                while (lazyPageImagesIterator.hasNext()) {
                    RenderedImage renderedImage = (RenderedImage)lazyPageImagesIterator.next();
                    object.writeImage(renderedImage, this.writerParams);
                }
            }
            finally {
                object.close();
            }
        } else {
            object = null;
            if (lazyPageImagesIterator.hasNext()) {
                object = (RenderedImage)lazyPageImagesIterator.next();
            }
            imageWriter.writeImage((RenderedImage)object, this.outputStream, this.writerParams);
            if (lazyPageImagesIterator.hasNext()) {
                BitmapRendererEventProducer bitmapRendererEventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                bitmapRendererEventProducer.stoppingAfterFirstPageNoFilename(this);
            }
        }
        this.outputStream.flush();
        this.clearViewportList();
        log.debug((Object)"TIFF encoding done.");
    }

    protected BufferedImage getBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, this.bufferedImageType);
    }

    public void setBufferedImageType(int n) {
        this.bufferedImageType = n;
    }

    public ImageWriterParams getWriterParams() {
        return this.writerParams;
    }

    private class LazyPageImagesIterator
    implements Iterator {
        private Log log;
        private int count;
        private int current = 0;

        public LazyPageImagesIterator(int n, Log log) {
            this.count = n;
            this.log = log;
        }

        public boolean hasNext() {
            return this.current < this.count;
        }

        public Object next() {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[" + (this.current + 1) + "]"));
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = TIFFRenderer.this.getPageImage(this.current++);
            }
            catch (FOPException fOPException) {
                throw new NoSuchElementException(fOPException.getMessage());
            }
            if ("CCITT T.4".equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod()) || "CCITT T.6".equalsIgnoreCase(TIFFRenderer.this.writerParams.getCompressionMethod())) {
                return bufferedImage;
            }
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n];
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n2, n3, n, n2 * n, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap((RenderedImage)bufferedImage), (SampleModel)pixelInterleavedSampleModel);
            return formatRed;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }
}

