/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.bitmap.AbstractBitmapDocumentHandler;
import org.apache.fop.render.bitmap.BitmapRenderingSettings;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.ConfiguredFontCollection;
import org.apache.fop.render.java2d.InstalledFontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.java2d.Java2DRendererConfigurator;
import org.apache.fop.util.ColorUtil;

public class BitmapRendererConfigurator
extends Java2DRendererConfigurator
implements IFDocumentHandlerConfigurator {
    public BitmapRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
        super.configure(iFDocumentHandler);
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            AbstractBitmapDocumentHandler abstractBitmapDocumentHandler = (AbstractBitmapDocumentHandler)iFDocumentHandler;
            BitmapRenderingSettings bitmapRenderingSettings = abstractBitmapDocumentHandler.getSettings();
            boolean bl = configuration.getChild("transparent-page-background").getValueAsBoolean(bitmapRenderingSettings.hasTransparentPageBackground());
            if (bl) {
                bitmapRenderingSettings.setPageBackgroundColor(null);
            } else {
                String string = configuration.getChild("background-color").getValue(null);
                if (string != null) {
                    bitmapRenderingSettings.setPageBackgroundColor(ColorUtil.parseColorString(this.userAgent, string));
                }
            }
            boolean bl2 = configuration.getChild("anti-aliasing").getValueAsBoolean(bitmapRenderingSettings.isAntiAliasingEnabled());
            bitmapRenderingSettings.setAntiAliasing(bl2);
            String string = configuration.getChild("rendering").getValue(null);
            if ("quality".equalsIgnoreCase(string)) {
                bitmapRenderingSettings.setQualityRendering(true);
            } else if ("speed".equalsIgnoreCase(string)) {
                bitmapRenderingSettings.setQualityRendering(false);
            }
            String string2 = configuration.getChild("color-mode").getValue(null);
            if (string2 != null) {
                if ("rgba".equalsIgnoreCase(string2)) {
                    bitmapRenderingSettings.setBufferedImageType(2);
                } else if ("rgb".equalsIgnoreCase(string2)) {
                    bitmapRenderingSettings.setBufferedImageType(1);
                } else if ("gray".equalsIgnoreCase(string2)) {
                    bitmapRenderingSettings.setBufferedImageType(10);
                } else if ("binary".equalsIgnoreCase(string2)) {
                    bitmapRenderingSettings.setBufferedImageType(12);
                } else if ("bi-level".equalsIgnoreCase(string2)) {
                    bitmapRenderingSettings.setBufferedImageType(12);
                } else {
                    throw new FOPException("Invalid value for color-mode: " + string2);
                }
            }
        }
    }

    public void setupFontInfo(IFDocumentHandler iFDocumentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        Java2DFontMetrics java2DFontMetrics = new Java2DFontMetrics();
        ArrayList<FontCollection> arrayList = new ArrayList<FontCollection>();
        arrayList.add(new Base14FontCollection(java2DFontMetrics));
        arrayList.add(new InstalledFontCollection(java2DFontMetrics));
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            DefaultFontResolver defaultFontResolver = new DefaultFontResolver(this.userAgent);
            FontEventAdapter fontEventAdapter = new FontEventAdapter(this.userAgent.getEventBroadcaster());
            List<EmbedFontInfo> list = this.buildFontList(configuration, defaultFontResolver, fontEventAdapter);
            arrayList.add(new ConfiguredFontCollection(defaultFontResolver, list, this.userAgent.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, arrayList.toArray(new FontCollection[arrayList.size()]));
        iFDocumentHandler.setFontInfo(fontInfo);
    }
}

