/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.image.loader.batik.Graphics2DImagePainterImpl;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.render.afp.AFPSVGHandler;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;

public class AFPImageHandlerSVG
implements ImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{BatikImageFlavors.SVG_DOM};

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPGraphicsObjectInfo();
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        GraphicsNode graphicsNode;
        Object object;
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        FOUserAgent fOUserAgent = aFPRenderingContext.getUserAgent();
        AFPGraphicsObjectInfo aFPGraphicsObjectInfo = (AFPGraphicsObjectInfo)this.createDataObjectInfo();
        AFPResourceInfo aFPResourceInfo = aFPGraphicsObjectInfo.getResourceInfo();
        this.setDefaultToInlineResourceLevel(aFPGraphicsObjectInfo);
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        boolean bl = aFPPaintingState.isStrokeGOCAText();
        AFPGraphics2D aFPGraphics2D = new AFPGraphics2D(bl, aFPRenderingContext.getPaintingState(), aFPRenderingContext.getResourceManager(), aFPResourceInfo, bl ? null : aFPRenderingContext.getFontInfo());
        aFPGraphics2D.setGraphicContext(new GraphicContext());
        aFPPaintingState.setImageUri(image.getInfo().getOriginalURI());
        BridgeContext bridgeContext = AFPSVGHandler.createBridgeContext(fOUserAgent, aFPGraphics2D);
        Document document = BatikUtil.cloneSVGDocument(imageXMLDOM.getDocument());
        try {
            object = new GVTBuilder();
            graphicsNode = object.build(bridgeContext, document);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt(this, exception, image.getInfo().getOriginalURI());
            return;
        }
        object = AFPImageHandler.createObjectAreaInfo(aFPPaintingState, rectangle);
        aFPGraphicsObjectInfo.setObjectAreaInfo((AFPObjectAreaInfo)object);
        aFPPaintingState.save();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle.x, rectangle.y);
        aFPPaintingState.concatenate(affineTransform);
        aFPGraphicsObjectInfo.setGraphics2D(aFPGraphics2D);
        Dimension dimension = image.getSize().getDimensionMpt();
        Graphics2DImagePainterImpl graphics2DImagePainterImpl = new Graphics2DImagePainterImpl(graphicsNode, bridgeContext, dimension);
        aFPGraphicsObjectInfo.setPainter(graphics2DImagePainterImpl);
        AFPResourceManager aFPResourceManager = aFPRenderingContext.getResourceManager();
        aFPResourceManager.createObject(aFPGraphicsObjectInfo);
        aFPPaintingState.restore();
    }

    private void setDefaultToInlineResourceLevel(AFPGraphicsObjectInfo aFPGraphicsObjectInfo) {
        AFPResourceInfo aFPResourceInfo = aFPGraphicsObjectInfo.getResourceInfo();
        if (!aFPResourceInfo.levelChanged()) {
            aFPResourceInfo.setLevel(new AFPResourceLevel(0));
        }
    }

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageXMLDOM.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageXMLDOM && image.getFlavor().isCompatible((ImageFlavor)BatikImageFlavors.SVG_DOM)) && renderingContext instanceof AFPRenderingContext;
        if (bl) {
            AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
            if (!aFPRenderingContext.getPaintingState().isGOCAEnabled()) {
                return false;
            }
            String string = (String)renderingContext.getHint(ImageHandlerUtil.CONVERSION_MODE);
            if (ImageHandlerUtil.isConversionModeBitmap(string)) {
                return false;
            }
        }
        return bl;
    }
}

