/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class AFPImageHandlerGraphics2D
extends AFPImageHandler
implements ImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D};

    private void setDefaultResourceLevel(AFPGraphicsObjectInfo aFPGraphicsObjectInfo, AFPResourceManager aFPResourceManager) {
        AFPResourceInfo aFPResourceInfo = aFPGraphicsObjectInfo.getResourceInfo();
        if (!aFPResourceInfo.levelChanged()) {
            aFPResourceInfo.setLevel(aFPResourceManager.getResourceLevelDefaults().getDefaultResourceLevel((byte)3));
        }
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPGraphicsObjectInfo();
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        AFPGraphicsObjectInfo aFPGraphicsObjectInfo = (AFPGraphicsObjectInfo)this.createDataObjectInfo();
        this.setResourceInformation(aFPGraphicsObjectInfo, image.getInfo().getOriginalURI(), aFPRenderingContext.getForeignAttributes());
        aFPGraphicsObjectInfo.setObjectAreaInfo(AFPImageHandlerGraphics2D.createObjectAreaInfo(aFPRenderingContext.getPaintingState(), rectangle));
        this.setDefaultResourceLevel(aFPGraphicsObjectInfo, aFPRenderingContext.getResourceManager());
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        aFPPaintingState.save();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle.x, rectangle.y);
        aFPPaintingState.concatenate(affineTransform);
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        boolean bl = aFPPaintingState.isStrokeGOCAText();
        AFPGraphics2D aFPGraphics2D = new AFPGraphics2D(bl, aFPRenderingContext.getPaintingState(), aFPRenderingContext.getResourceManager(), aFPGraphicsObjectInfo.getResourceInfo(), bl ? null : aFPRenderingContext.getFontInfo());
        aFPGraphics2D.setGraphicContext(new GraphicContext());
        aFPGraphicsObjectInfo.setGraphics2D(aFPGraphics2D);
        aFPGraphicsObjectInfo.setPainter(imageGraphics2D.getGraphics2DImagePainter());
        aFPRenderingContext.getResourceManager().createObject(aFPGraphicsObjectInfo);
        aFPPaintingState.restore();
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageGraphics2D) && renderingContext instanceof AFPRenderingContext;
        if (bl) {
            AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
            if (!aFPRenderingContext.getPaintingState().isGOCAEnabled()) {
                return false;
            }
            String string = (String)renderingContext.getHint(ImageHandlerUtil.CONVERSION_MODE);
            if (ImageHandlerUtil.isConversionModeBitmap(string)) {
                return false;
            }
        }
        return bl;
    }
}

