/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.AbstractRenderer;

public class RendererContext {
    private final String mime;
    private final AbstractRenderer renderer;
    private FOUserAgent userAgent;
    private final Map props = new HashMap();

    public RendererContext(AbstractRenderer abstractRenderer, String string) {
        this.renderer = abstractRenderer;
        this.mime = string;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public String getMimeType() {
        return this.mime;
    }

    public void setUserAgent(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setProperty(String string, Object object) {
        this.props.put(string, object);
    }

    public Object getProperty(String string) {
        return this.props.get(string);
    }

    public static RendererContextWrapper wrapRendererContext(RendererContext rendererContext) {
        RendererContextWrapper rendererContextWrapper = new RendererContextWrapper(rendererContext);
        return rendererContextWrapper;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RendererContext{\n");
        for (String string : this.props.keySet()) {
            Object v = this.props.get(string);
            stringBuffer.append("\t" + string + "=" + v + "\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static class RendererContextWrapper {
        protected RendererContext context;

        public RendererContextWrapper(RendererContext rendererContext) {
            this.context = rendererContext;
        }

        public FOUserAgent getUserAgent() {
            return this.context.getUserAgent();
        }

        public int getCurrentXPosition() {
            return (Integer)this.context.getProperty("xpos");
        }

        public int getCurrentYPosition() {
            return (Integer)this.context.getProperty("ypos");
        }

        public int getWidth() {
            return (Integer)this.context.getProperty("width");
        }

        public int getHeight() {
            return (Integer)this.context.getProperty("height");
        }

        public Map getForeignAttributes() {
            return (Map)this.context.getProperty("foreign-attributes");
        }

        public String toString() {
            return "RendererContextWrapper{userAgent=" + this.getUserAgent() + "x=" + this.getCurrentXPosition() + "y=" + this.getCurrentYPosition() + "width=" + this.getWidth() + "height=" + this.getHeight() + "foreignAttributes=" + this.getForeignAttributes() + "}";
        }
    }
}

