/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.fop.render.ImageHandler;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.util.UnitConv;

public abstract class AbstractImageHandlerGraphics2D
implements ImageHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage paintToBufferedImage(Graphics2DImagePainter graphics2DImagePainter, Dimension dimension, int n, boolean bl, boolean bl2) {
        int n2 = (int)Math.ceil(UnitConv.mpt2px((double)dimension.getWidth(), (int)n));
        int n3 = (int)Math.ceil(UnitConv.mpt2px((double)dimension.getHeight(), (int)n));
        BufferedImage bufferedImage = bl ? (bl2 ? AbstractImageHandlerGraphics2D.createGrayBufferedImageWithAlpha(n2, n3) : new BufferedImage(n2, n3, 10)) : (bl2 ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.setRenderingHintsForBufferedImage(graphics2D);
            graphics2D.setBackground(Color.white);
            graphics2D.setColor(Color.black);
            if (!bl2) {
                graphics2D.clearRect(0, 0, n2, n3);
            }
            double d = (double)n2 / dimension.getWidth();
            double d2 = (double)n3 / dimension.getHeight();
            graphics2D.scale(d, d2);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
            graphics2DImagePainter.paint(graphics2D, (Rectangle2D)double_);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private static BufferedImage createGrayBufferedImageWithAlpha(int n, int n2) {
        boolean bl = true;
        int n3 = 2;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = 8;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, true, bl, 3, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n3, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, bl, null);
        return bufferedImage;
    }

    protected void setRenderingHintsForBufferedImage(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

