/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf.xref;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.xref.CrossReferenceObject;
import org.apache.fop.pdf.xref.TrailerDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceTable
extends CrossReferenceObject {
    private final List<Long> objectReferences;
    private final StringBuilder pdf = new StringBuilder(256);

    public CrossReferenceTable(TrailerDictionary trailerDictionary, long l, List<Long> list) {
        super(trailerDictionary, l);
        this.objectReferences = list;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputXref();
        this.writeTrailer(outputStream);
    }

    private void outputXref() throws IOException {
        this.pdf.append("xref\n0 ");
        this.pdf.append(this.objectReferences.size() + 1);
        this.pdf.append("\n0000000000 65535 f \n");
        for (Long l : this.objectReferences) {
            String string = String.valueOf(l);
            if (string.length() > 10) {
                throw new IOException("PDF file too large. PDF 1.4 cannot grow beyond approx. 9.3GB.");
            }
            String string2 = "0000000000".substring(string.length()) + string;
            this.pdf.append(string2).append(" 00000 n \n");
        }
    }

    private void writeTrailer(OutputStream outputStream) throws IOException {
        this.pdf.append("trailer\n");
        outputStream.write(PDFDocument.encode(this.pdf.toString()));
        PDFDictionary pDFDictionary = this.trailerDictionary.getDictionary();
        pDFDictionary.put("/Size", this.objectReferences.size() + 1);
        pDFDictionary.output(outputStream);
    }
}

