/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.AffineTransform;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFText;

public abstract class PDFTextUtil {
    private static final int DEC = 8;
    public static final int TR_FILL = 0;
    public static final int TR_STROKE = 1;
    public static final int TR_FILL_STROKE = 2;
    public static final int TR_INVISIBLE = 3;
    public static final int TR_FILL_CLIP = 4;
    public static final int TR_STROKE_CLIP = 5;
    public static final int TR_FILL_STROKE_CLIP = 6;
    public static final int TR_CLIP = 7;
    private boolean inTextObject = false;
    private String startText;
    private String endText;
    private boolean useMultiByte;
    private StringBuffer bufTJ;
    private int textRenderingMode = 0;
    private String currentFontName;
    private double currentFontSize;

    protected abstract void write(String var1);

    private void writeAffineTransform(AffineTransform affineTransform, StringBuffer stringBuffer) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        stringBuffer.append(PDFNumber.doubleOut(dArray[0], 8)).append(" ");
        stringBuffer.append(PDFNumber.doubleOut(dArray[1], 8)).append(" ");
        stringBuffer.append(PDFNumber.doubleOut(dArray[2], 8)).append(" ");
        stringBuffer.append(PDFNumber.doubleOut(dArray[3], 8)).append(" ");
        stringBuffer.append(PDFNumber.doubleOut(dArray[4], 8)).append(" ");
        stringBuffer.append(PDFNumber.doubleOut(dArray[5], 8));
    }

    private static void writeChar(char c, StringBuffer stringBuffer, boolean bl) {
        if (!bl) {
            if (c < ' ' || c > '\u007f') {
                stringBuffer.append("\\").append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        stringBuffer.append("\\");
                        break;
                    }
                }
                stringBuffer.append(c);
            }
        } else {
            stringBuffer.append(PDFText.toUnicodeHex(c));
        }
    }

    private void writeChar(char c, StringBuffer stringBuffer) {
        PDFTextUtil.writeChar(c, stringBuffer, this.useMultiByte);
    }

    private void checkInTextObject() {
        if (!this.inTextObject) {
            throw new IllegalStateException("Not in text object");
        }
    }

    public boolean isInTextObject() {
        return this.inTextObject;
    }

    public void beginTextObject() {
        if (this.inTextObject) {
            throw new IllegalStateException("Already in text object");
        }
        this.write("BT\n");
        this.inTextObject = true;
    }

    public void endTextObject() {
        this.checkInTextObject();
        this.write("ET\n");
        this.inTextObject = false;
        this.initValues();
    }

    protected void initValues() {
        this.currentFontName = null;
        this.currentFontSize = 0.0;
        this.textRenderingMode = 0;
    }

    public void concatMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.writeTJ();
            StringBuffer stringBuffer = new StringBuffer();
            this.writeAffineTransform(affineTransform, stringBuffer);
            stringBuffer.append(" cm\n");
            this.write(stringBuffer.toString());
        }
    }

    public void writeTf(String string, double d) {
        this.checkInTextObject();
        this.write("/" + string + " " + PDFNumber.doubleOut(d) + " Tf\n");
        this.startText = this.useMultiByte ? "<" : "(";
        this.endText = this.useMultiByte ? ">" : ")";
    }

    public void updateTf(String string, double d, boolean bl) {
        this.checkInTextObject();
        if (!string.equals(this.currentFontName) || d != this.currentFontSize) {
            this.writeTJ();
            this.currentFontName = string;
            this.currentFontSize = d;
            this.useMultiByte = bl;
            this.writeTf(string, d);
        }
    }

    public void setTextRenderingMode(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Illegal value for text rendering mode. Expected: 0-7");
        }
        if (n != this.textRenderingMode) {
            this.writeTJ();
            this.textRenderingMode = n;
            this.write(this.textRenderingMode + " Tr\n");
        }
    }

    public void setTextRenderingMode(boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (bl) {
            n = bl2 ? 2 : 0;
        } else {
            int n2 = n = bl2 ? 1 : 3;
        }
        if (bl3) {
            n += 4;
        }
        this.setTextRenderingMode(n);
    }

    public void writeTextMatrix(AffineTransform affineTransform) {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeAffineTransform(affineTransform, stringBuffer);
        stringBuffer.append(" Tm ");
        this.write(stringBuffer.toString());
    }

    public void writeTJMappedChar(char c) {
        if (this.bufTJ == null) {
            this.bufTJ = new StringBuffer();
        }
        if (this.bufTJ.length() == 0) {
            this.bufTJ.append("[");
            this.bufTJ.append(this.startText);
        }
        this.writeChar(c, this.bufTJ);
    }

    public void adjustGlyphTJ(double d) {
        if (this.bufTJ == null) {
            this.bufTJ = new StringBuffer();
        }
        if (this.bufTJ.length() == 0) {
            this.bufTJ.append("[");
        } else {
            this.bufTJ.append(this.endText);
            this.bufTJ.append(" ");
        }
        this.bufTJ.append(PDFNumber.doubleOut(d, 4));
        this.bufTJ.append(" ");
        this.bufTJ.append(this.startText);
    }

    public void writeTJ() {
        if (this.isInString()) {
            this.bufTJ.append(this.endText).append("] TJ\n");
            this.write(this.bufTJ.toString());
            this.bufTJ.setLength(0);
        }
    }

    private boolean isInString() {
        return this.bufTJ != null && this.bufTJ.length() > 0;
    }

    public void writeTd(double d, double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PDFNumber.doubleOut(d, 8));
        stringBuffer.append(' ');
        stringBuffer.append(PDFNumber.doubleOut(d2, 8));
        stringBuffer.append(" Td\n");
        this.write(stringBuffer.toString());
    }

    public void writeTj(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        PDFTextUtil.writeChar(c, stringBuffer, true);
        stringBuffer.append('>');
        stringBuffer.append(" Tj\n");
        this.write(stringBuffer.toString());
    }
}

