/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.AbstractPDFFontStream;

public class PDFTTFStream
extends AbstractPDFFontStream {
    private int origLength;
    private byte[] ttfData;

    public PDFTTFStream(int n) {
        this.origLength = n;
    }

    protected int getSizeHint() throws IOException {
        if (this.ttfData != null) {
            return this.ttfData.length;
        }
        return 0;
    }

    public int output(OutputStream outputStream) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing " + this.origLength + " bytes of TTF font data"));
        }
        int n = super.output(outputStream);
        log.debug((Object)"Embedded TrueType/OpenType font");
        return n;
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        outputStream.write(this.ttfData);
    }

    protected void populateStreamDict(Object object) {
        this.put("Length1", this.origLength);
        super.populateStreamDict(object);
    }

    public void setData(byte[] byArray, int n) throws IOException {
        this.ttfData = new byte[n];
        System.arraycopy(byArray, 0, this.ttfData, 0, n);
    }
}

