/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.util.LanguageTags;

public class PDFStructElem
extends PDFDictionary
implements StructureTreeElement,
CompressedObject {
    private PDFStructElem parentElement;
    protected List<PDFObject> kids;

    PDFStructElem(PDFObject pDFObject, PDFName pDFName) {
        if (pDFObject instanceof PDFStructElem) {
            this.parentElement = (PDFStructElem)pDFObject;
        }
        this.put("S", pDFName);
        this.setParent(pDFObject);
    }

    public PDFStructElem getParentStructElem() {
        return this.parentElement;
    }

    public void setParent(PDFObject pDFObject) {
        if (pDFObject != null && pDFObject.hasObjectNumber()) {
            this.put("P", new PDFReference(pDFObject));
        }
    }

    public void addKid(PDFObject pDFObject) {
        if (this.kids == null) {
            this.kids = new ArrayList<PDFObject>();
        }
        this.kids.add(pDFObject);
    }

    public void setMCIDKid(int n) {
        this.put("K", n);
    }

    public void setPage(PDFPage pDFPage) {
        this.put("Pg", pDFPage);
    }

    public PDFName getStructureType() {
        return (PDFName)this.get("S");
    }

    private void setLanguage(String string) {
        this.put("Lang", string);
    }

    public void setLanguage(Locale locale) {
        this.setLanguage(LanguageTags.toLanguageTag(locale));
    }

    public String getLanguage() {
        return (String)this.get("Lang");
    }

    protected void writeDictionary(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        this.attachKids();
        super.writeDictionary(outputStream, stringBuilder);
    }

    protected boolean attachKids() {
        boolean bl;
        ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
        if (this.kids != null) {
            for (PDFObject pDFObject : this.kids) {
                if (pDFObject instanceof Placeholder) {
                    if (!((Placeholder)pDFObject).attachKids()) continue;
                    arrayList.add(pDFObject);
                    continue;
                }
                arrayList.add(pDFObject);
            }
        }
        boolean bl2 = bl = !arrayList.isEmpty();
        if (bl) {
            PDFObject pDFObject;
            pDFObject = new PDFArray();
            for (PDFObject pDFObject2 : arrayList) {
                ((PDFArray)pDFObject).add(pDFObject2);
            }
            this.put("K", pDFObject);
        }
        return bl;
    }

    public static class Placeholder
    extends PDFStructElem {
        public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
            if (this.kids != null) {
                assert (this.kids.size() > 0);
                for (int i = 0; i < this.kids.size(); ++i) {
                    if (i > 0) {
                        stringBuilder.append(' ');
                    }
                    Object e = this.kids.get(i);
                    this.formatObject(e, outputStream, stringBuilder);
                }
            }
        }

        public Placeholder(PDFObject pDFObject, String string) {
            super(pDFObject, new PDFName(string));
        }
    }
}

