/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;

public class PDFStream
extends AbstractPDFStream {
    protected StreamCache data;
    private transient Writer streamWriter;

    public PDFStream() {
        this.setUp();
    }

    public PDFStream(PDFDictionary pDFDictionary) {
        super(pDFDictionary);
        this.setUp();
    }

    public PDFStream(PDFDictionary pDFDictionary, boolean bl) {
        super(pDFDictionary, bl);
        this.setUp();
    }

    public PDFStream(boolean bl) {
        super(bl);
        this.setUp();
    }

    private void setUp() {
        try {
            this.data = StreamCacheFactory.getInstance().createStreamCache();
            this.streamWriter = new OutputStreamWriter(this.getBufferOutputStream(), "ISO-8859-1");
            this.streamWriter = new BufferedWriter(this.streamWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void add(String string) {
        try {
            this.streamWriter.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void flush() throws IOException {
        this.streamWriter.flush();
    }

    public Writer getBufferWriter() {
        return this.streamWriter;
    }

    public OutputStream getBufferOutputStream() throws IOException {
        if (this.streamWriter != null) {
            this.flush();
        }
        return this.data.getOutputStream();
    }

    public void setData(byte[] byArray) throws IOException {
        this.data.clear();
        this.data.write(byArray);
    }

    public int getDataLength() {
        try {
            this.flush();
            return this.data.getSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    protected int getSizeHint() throws IOException {
        this.flush();
        return this.data.getSize();
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.flush();
        this.data.outputContents(outputStream);
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = super.output(outputStream);
        this.data = null;
        return n;
    }
}

