/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFWritable;

public class PDFReference
implements PDFWritable {
    private int objectNumber;
    private int generation;
    private Reference<PDFObject> objReference;

    public PDFReference(PDFObject pDFObject) {
        this.objectNumber = pDFObject.getObjectNumber();
        this.generation = pDFObject.getGeneration();
        this.objReference = new SoftReference<PDFObject>(pDFObject);
    }

    public PDFReference(String string) {
        if (string == null) {
            throw new NullPointerException("ref must not be null");
        }
        String[] stringArray = string.split(" ");
        assert (stringArray.length == 3);
        this.objectNumber = Integer.parseInt(stringArray[0]);
        this.generation = Integer.parseInt(stringArray[1]);
        assert ("R".equals(stringArray[2]));
    }

    public PDFObject getObject() {
        if (this.objReference != null) {
            PDFObject pDFObject = this.objReference.get();
            if (pDFObject == null) {
                this.objReference = null;
            }
            return pDFObject;
        }
        return null;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.outputInline(null, stringBuilder);
        return stringBuilder.toString();
    }

    public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) {
        stringBuilder.append(this.getObjectNumber()).append(' ').append(this.getGeneration()).append(" R");
    }
}

