/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFObject;

public class PDFOutline
extends PDFObject {
    private List subentries = new ArrayList();
    private PDFOutline parent = null;
    private PDFOutline prev = null;
    private PDFOutline next = null;
    private PDFOutline first = null;
    private PDFOutline last = null;
    private int count = 0;
    private boolean openItem = false;
    private String title;
    private String actionRef;

    public PDFOutline(String string, String string2, boolean bl) {
        this.title = string;
        this.actionRef = string2;
        this.openItem = bl;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addOutline(PDFOutline pDFOutline) {
        if (this.subentries.size() > 0) {
            pDFOutline.prev = (PDFOutline)this.subentries.get(this.subentries.size() - 1);
            pDFOutline.prev.next = pDFOutline;
        } else {
            this.first = pDFOutline;
        }
        this.subentries.add(pDFOutline);
        pDFOutline.parent = this;
        this.incrementCount();
        this.last = pDFOutline;
    }

    private void incrementCount() {
        ++this.count;
        if (this.parent != null) {
            this.parent.incrementCount();
        }
    }

    protected byte[] toPDF() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        try {
            byteArrayOutputStream.write(PDFOutline.encode("<<"));
            if (this.parent == null) {
                if (this.first != null && this.last != null) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /First " + this.first.referencePDF() + "\n"));
                    byteArrayOutputStream.write(PDFOutline.encode(" /Last " + this.last.referencePDF() + "\n"));
                }
            } else {
                byteArrayOutputStream.write(PDFOutline.encode(" /Title "));
                byteArrayOutputStream.write(this.encodeText(this.title));
                byteArrayOutputStream.write(PDFOutline.encode("\n"));
                byteArrayOutputStream.write(PDFOutline.encode(" /Parent " + this.parent.referencePDF() + "\n"));
                if (this.prev != null) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /Prev " + this.prev.referencePDF() + "\n"));
                }
                if (this.next != null) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /Next " + this.next.referencePDF() + "\n"));
                }
                if (this.first != null && this.last != null) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /First " + this.first.referencePDF() + "\n"));
                    byteArrayOutputStream.write(PDFOutline.encode(" /Last " + this.last.referencePDF() + "\n"));
                }
                if (this.count > 0) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /Count " + (this.openItem ? "" : "-") + this.count + "\n"));
                }
                if (this.actionRef != null) {
                    byteArrayOutputStream.write(PDFOutline.encode(" /A " + this.actionRef + "\n"));
                }
            }
            byteArrayOutputStream.write(PDFOutline.encode(">>"));
        }
        catch (IOException iOException) {
            log.error((Object)"Ignored I/O exception", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

