/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFNumsArray
extends PDFObject {
    protected SortedMap<Integer, Object> map = new TreeMap<Integer, Object>();

    public PDFNumsArray(PDFObject pDFObject) {
        super(pDFObject);
    }

    public int length() {
        return this.map.size();
    }

    public void put(Integer n, Object object) {
        this.map.put(n, object);
    }

    public void put(int n, Object object) {
        this.put((Integer)n, object);
    }

    public Object get(Integer n) {
        return this.map.get(n);
    }

    public Object get(int n) {
        return this.get((Integer)n);
    }

    public int output(OutputStream outputStream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('[');
        boolean bl = true;
        for (Map.Entry<Integer, Object> entry : this.map.entrySet()) {
            if (!bl) {
                stringBuilder.append(" ");
            }
            bl = false;
            this.formatObject(entry.getKey(), (OutputStream)countingOutputStream, stringBuilder);
            stringBuilder.append(" ");
            this.formatObject(entry.getValue(), (OutputStream)countingOutputStream, stringBuilder);
        }
        stringBuilder.append(']');
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }
}

