/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFName
extends PDFObject {
    private String name;
    private static final String ESCAPED_NAME_CHARS = "/()<>[]%#";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PDFName(String string) {
        this.name = PDFName.escapeName(string);
    }

    static String escapeName(String string) {
        StringBuilder stringBuilder = new StringBuilder(Math.min(16, string.length() + 4));
        boolean bl = false;
        stringBuilder.append('/');
        if (string.startsWith("/")) {
            bl = true;
        }
        int n = string.length();
        for (int i = bl ? 1 : 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '!' || c > '~' || ESCAPED_NAME_CHARS.indexOf(c) >= 0) {
                stringBuilder.append('#');
                PDFName.toHex(c, stringBuilder);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void toHex(char c, StringBuilder stringBuilder) {
        if (c >= '\u0100') {
            throw new IllegalArgumentException("Only 8-bit characters allowed by this implementation");
        }
        stringBuilder.append(DIGITS[c >>> 4 & 0xF]);
        stringBuilder.append(DIGITS[c & 0xF]);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name.substring(1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PDFName)) {
            return false;
        }
        PDFName pDFName = (PDFName)object;
        return this.name.equals(pDFName.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int output(OutputStream outputStream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.toString());
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        if (this.hasObjectNumber()) {
            stringBuilder.append(this.referencePDF());
        } else {
            stringBuilder.append(this.toString());
        }
    }
}

