/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.pdf.AbstractPDFFontStream;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFJavaScriptLaunchAction;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNameTreeNode;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFSeparationColorSpace;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFToUnicodeCMap;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;
import org.apache.fop.pdf.PDFWritable;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFFactory {
    public static final int DEFAULT_PDF_RESOLUTION = 72;
    private PDFDocument document;
    private Log log = LogFactory.getLog(PDFFactory.class);
    private int subsetFontCounter = -1;
    private static final String EMBEDDED_FILE = "embedded-file:";

    public PDFFactory(PDFDocument pDFDocument) {
        this.document = pDFDocument;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pDFPages) {
        PDFRoot pDFRoot = new PDFRoot(++this.document.objectcount, pDFPages);
        pDFRoot.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pDFRoot);
        return pDFRoot;
    }

    public PDFPages makePages() {
        PDFPages pDFPages = new PDFPages(++this.document.objectcount);
        pDFPages.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pDFPages);
        return pDFPages;
    }

    public PDFResources makeResources() {
        PDFResources pDFResources = new PDFResources(++this.document.objectcount);
        pDFResources.setDocument(this.getDocument());
        this.getDocument().addTrailerObject(pDFResources);
        return pDFResources;
    }

    protected PDFInfo makeInfo(String string) {
        PDFInfo pDFInfo = new PDFInfo();
        pDFInfo.setProducer(string);
        this.getDocument().registerObject(pDFInfo);
        return pDFInfo;
    }

    public PDFMetadata makeMetadata(Metadata metadata, boolean bl) {
        PDFMetadata pDFMetadata = new PDFMetadata(metadata, bl);
        this.getDocument().registerObject(pDFMetadata);
        return pDFMetadata;
    }

    public PDFOutputIntent makeOutputIntent() {
        PDFOutputIntent pDFOutputIntent = new PDFOutputIntent();
        this.getDocument().registerObject(pDFOutputIntent);
        return pDFOutputIntent;
    }

    public PDFPage makePage(PDFResources pDFResources, int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, Rectangle2D rectangle2D4) {
        PDFPage pDFPage = new PDFPage(pDFResources, n, rectangle2D, rectangle2D2, rectangle2D3, rectangle2D4);
        this.getDocument().assignObjectNumber(pDFPage);
        this.getDocument().getPages().addPage(pDFPage);
        return pDFPage;
    }

    public PDFPage makePage(PDFResources pDFResources, int n, int n2, int n3) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        return this.makePage(pDFResources, n3, double_, double_, double_, double_);
    }

    public PDFPage makePage(PDFResources pDFResources, int n, int n2) {
        return this.makePage(pDFResources, n, n2, -1);
    }

    public PDFFunction makeFunction(int n, List list, List list2, List list3, int n2, int n3, List list4, List list5, StringBuffer stringBuffer, List list6) {
        PDFFunction pDFFunction = new PDFFunction(n, list, list2, list3, n2, n3, list4, list5, stringBuffer, list6);
        PDFFunction pDFFunction2 = this.getDocument().findFunction(pDFFunction);
        if (pDFFunction2 == null) {
            this.getDocument().registerObject(pDFFunction);
        } else {
            pDFFunction = pDFFunction2;
        }
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, List list, List list2, List list3, List list4, double d) {
        PDFFunction pDFFunction = new PDFFunction(n, list, list2, list3, list4, d);
        PDFFunction pDFFunction2 = this.getDocument().findFunction(pDFFunction);
        if (pDFFunction2 == null) {
            this.getDocument().registerObject(pDFFunction);
        } else {
            pDFFunction = pDFFunction2;
        }
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, List list, List list2, List list3, List list4, List list5) {
        PDFFunction pDFFunction = new PDFFunction(n, list, list2, list3, list4, list5);
        PDFFunction pDFFunction2 = this.getDocument().findFunction(pDFFunction);
        if (pDFFunction2 == null) {
            this.getDocument().registerObject(pDFFunction);
        } else {
            pDFFunction = pDFFunction2;
        }
        return pDFFunction;
    }

    public PDFFunction makeFunction(int n, int n2, List list, List list2, StringBuffer stringBuffer) {
        PDFFunction pDFFunction = new PDFFunction(n2, list, list2, stringBuffer);
        PDFFunction pDFFunction2 = this.getDocument().findFunction(pDFFunction);
        if (pDFFunction2 == null) {
            this.getDocument().registerObject(pDFFunction);
        } else {
            pDFFunction = pDFFunction2;
        }
        return pDFFunction;
    }

    public PDFShading makeShading(PDFResourceContext pDFResourceContext, int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, List list3, List list4, PDFFunction pDFFunction) {
        PDFShading pDFShading = new PDFShading(n, pDFDeviceColorSpace, list, list2, bl, list3, list4, pDFFunction);
        PDFShading pDFShading2 = this.getDocument().findShading(pDFShading);
        if (pDFShading2 == null) {
            this.getDocument().registerObject(pDFShading);
        } else {
            pDFShading = pDFShading2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addShading(pDFShading);
        } else {
            this.getDocument().getResources().addShading(pDFShading);
        }
        return pDFShading;
    }

    public PDFShading makeShading(PDFResourceContext pDFResourceContext, int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, List list3, List list4, PDFFunction pDFFunction, List list5) {
        PDFShading pDFShading = new PDFShading(n, pDFDeviceColorSpace, list, list2, bl, list3, list4, pDFFunction, list5);
        PDFShading pDFShading2 = this.getDocument().findShading(pDFShading);
        if (pDFShading2 == null) {
            this.getDocument().registerObject(pDFShading);
        } else {
            pDFShading = pDFShading2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addShading(pDFShading);
        } else {
            this.getDocument().getResources().addShading(pDFShading);
        }
        return pDFShading;
    }

    public PDFShading makeShading(PDFResourceContext pDFResourceContext, int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, int n2, int n3, int n4, List list3, PDFFunction pDFFunction) {
        PDFShading pDFShading = new PDFShading(n, pDFDeviceColorSpace, list, list2, bl, n2, n3, n4, list3, pDFFunction);
        PDFShading pDFShading2 = this.getDocument().findShading(pDFShading);
        if (pDFShading2 == null) {
            this.getDocument().registerObject(pDFShading);
        } else {
            pDFShading = pDFShading2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addShading(pDFShading);
        } else {
            this.getDocument().getResources().addShading(pDFShading);
        }
        return pDFShading;
    }

    public PDFShading makeShading(PDFResourceContext pDFResourceContext, int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, int n2, int n3, List list3, int n4, PDFFunction pDFFunction) {
        PDFShading pDFShading = new PDFShading(n, pDFDeviceColorSpace, list, list2, bl, n2, n3, list3, n4, pDFFunction);
        PDFShading pDFShading2 = this.getDocument().findShading(pDFShading);
        if (pDFShading2 == null) {
            this.getDocument().registerObject(pDFShading);
        } else {
            pDFShading = pDFShading2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addShading(pDFShading);
        } else {
            this.getDocument().getResources().addShading(pDFShading);
        }
        return pDFShading;
    }

    public PDFPattern makePattern(PDFResourceContext pDFResourceContext, int n, PDFResources pDFResources, int n2, int n3, List list, double d, double d2, List list2, List list3, StringBuffer stringBuffer) {
        PDFPattern pDFPattern = new PDFPattern(pDFResources, 1, n2, n3, list, d, d2, list2, list3, stringBuffer);
        PDFPattern pDFPattern2 = this.getDocument().findPattern(pDFPattern);
        if (pDFPattern2 == null) {
            this.getDocument().registerObject(pDFPattern);
        } else {
            pDFPattern = pDFPattern2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addPattern(pDFPattern);
        } else {
            this.getDocument().getResources().addPattern(pDFPattern);
        }
        return pDFPattern;
    }

    public PDFPattern makePattern(PDFResourceContext pDFResourceContext, int n, PDFShading pDFShading, List list, StringBuffer stringBuffer, List list2) {
        PDFPattern pDFPattern = new PDFPattern(2, pDFShading, list, stringBuffer, list2);
        PDFPattern pDFPattern2 = this.getDocument().findPattern(pDFPattern);
        if (pDFPattern2 == null) {
            this.getDocument().registerObject(pDFPattern);
        } else {
            pDFPattern = pDFPattern2;
        }
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addPattern(pDFPattern);
        } else {
            this.getDocument().getResources().addPattern(pDFPattern);
        }
        return pDFPattern;
    }

    public PDFPattern makeGradient(PDFResourceContext pDFResourceContext, boolean bl, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, List list3, List list4) {
        PDFShading pDFShading;
        Serializable serializable;
        double d = 1.0;
        ArrayList<PDFFunction> arrayList = new ArrayList<PDFFunction>();
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            serializable = (Color)list.get(i);
            Color color = (Color)list.get(i + 1);
            if (!((Color)serializable).getColorSpace().isCS_sRGB()) {
                serializable = ColorUtil.toSRGBColor((Color)serializable);
                list.set(i, serializable);
            }
            if (!color.getColorSpace().isCS_sRGB()) {
                color = ColorUtil.toSRGBColor((Color)color);
                list.set(i + 1, color);
            }
            List list5 = this.toColorVector((Color)serializable);
            List list6 = this.toColorVector(color);
            PDFFunction pDFFunction = this.makeFunction(2, null, null, list5, list6, d);
            arrayList.add(pDFFunction);
        }
        PDFFunction pDFFunction = this.makeFunction(3, null, null, arrayList, list2, null);
        if (bl) {
            if (list3.size() == 6) {
                pDFShading = this.makeShading(pDFResourceContext, 3, this.getDocument().getPDFColorSpace(), null, null, false, list3, null, pDFFunction, null);
            } else {
                serializable = new ArrayList();
                serializable.add(list3.get(0));
                serializable.add(list3.get(1));
                serializable.add(list3.get(2));
                serializable.add(list3.get(0));
                serializable.add(list3.get(1));
                serializable.add(new Double(0.0));
                pDFShading = this.makeShading(pDFResourceContext, 3, this.getDocument().getPDFColorSpace(), null, null, false, (List)((Object)serializable), null, pDFFunction, null);
            }
        } else {
            pDFShading = this.makeShading(pDFResourceContext, 2, this.getDocument().getPDFColorSpace(), null, null, false, list3, null, pDFFunction, null);
        }
        PDFPattern pDFPattern = this.makePattern(pDFResourceContext, 2, pDFShading, null, null, list4);
        return pDFPattern;
    }

    private List toColorVector(Color color) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        float[] fArray = color.getColorComponents(null);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(fArray[i]));
        }
        return arrayList;
    }

    protected PDFDestination getUniqueDestination(PDFDestination pDFDestination) {
        PDFDestination pDFDestination2 = this.getDocument().findDestination(pDFDestination);
        if (pDFDestination2 != null) {
            return pDFDestination2;
        }
        this.getDocument().addDestination(pDFDestination);
        return pDFDestination;
    }

    public PDFDestination makeDestination(String string, Object object) {
        PDFDestination pDFDestination = new PDFDestination(string, object);
        return this.getUniqueDestination(pDFDestination);
    }

    public PDFNames makeNames() {
        PDFNames pDFNames = new PDFNames();
        this.getDocument().assignObjectNumber(pDFNames);
        this.getDocument().addTrailerObject(pDFNames);
        return pDFNames;
    }

    public PDFPageLabels makePageLabels() {
        PDFPageLabels pDFPageLabels = new PDFPageLabels();
        this.getDocument().assignObjectNumber(pDFPageLabels);
        this.getDocument().addTrailerObject(pDFPageLabels);
        return pDFPageLabels;
    }

    public PDFDests makeDests(List list) {
        PDFDests pDFDests = new PDFDests();
        PDFArray pDFArray = new PDFArray(pDFDests);
        for (PDFDestination pDFDestination : list) {
            PDFNameTreeNode pDFNameTreeNode = new PDFNameTreeNode();
            this.getDocument().registerObject(pDFNameTreeNode);
            pDFNameTreeNode.setLowerLimit(pDFDestination.getIDRef());
            pDFNameTreeNode.setUpperLimit(pDFDestination.getIDRef());
            pDFNameTreeNode.setNames(new PDFArray(pDFNameTreeNode));
            PDFArray pDFArray2 = pDFNameTreeNode.getNames();
            pDFArray2.add(pDFDestination);
            pDFArray.add(pDFNameTreeNode);
        }
        pDFDests.setLowerLimit(((PDFNameTreeNode)pDFArray.get(0)).getLowerLimit());
        pDFDests.setUpperLimit(((PDFNameTreeNode)pDFArray.get(pDFArray.length() - 1)).getUpperLimit());
        pDFDests.setKids(pDFArray);
        this.getDocument().registerObject(pDFDests);
        return pDFDests;
    }

    public PDFNameTreeNode makeNameTreeNode() {
        PDFNameTreeNode pDFNameTreeNode = new PDFNameTreeNode();
        this.getDocument().registerObject(pDFNameTreeNode);
        return pDFNameTreeNode;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, PDFAction pDFAction) {
        if (rectangle2D == null || pDFAction == null) {
            return null;
        }
        PDFLink pDFLink = new PDFLink(rectangle2D);
        pDFLink.setAction(pDFAction);
        this.getDocument().registerObject(pDFLink);
        return pDFLink;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, String string, String string2) {
        PDFLink pDFLink = new PDFLink(rectangle2D);
        this.getDocument().registerObject(pDFLink);
        PDFGoTo pDFGoTo = new PDFGoTo(string);
        pDFGoTo.setDestination(string2);
        this.getDocument().registerObject(pDFGoTo);
        PDFInternalLink pDFInternalLink = new PDFInternalLink(pDFGoTo.referencePDF());
        pDFLink.setAction(pDFInternalLink);
        return pDFLink;
    }

    public PDFLink makeLink(Rectangle2D rectangle2D, String string, int n, float f) {
        Object object;
        Object object2 = new PDFLink(rectangle2D);
        if (n == 0) {
            ((PDFLink)object2).setAction(this.getExternalAction(string, false));
        } else {
            object = this.getGoToReference(string, f);
            PDFInternalLink pDFInternalLink = new PDFInternalLink((String)object);
            ((PDFLink)object2).setAction(pDFInternalLink);
        }
        object = this.getDocument().findLink((PDFLink)object2);
        if (object == null) {
            this.getDocument().registerObject((PDFObject)object2);
        } else {
            object2 = object;
        }
        return object2;
    }

    public PDFAction getExternalAction(String string, boolean bl) {
        String string2 = string.toLowerCase();
        if (string.startsWith(EMBEDDED_FILE)) {
            String string3 = string.substring(EMBEDDED_FILE.length());
            return this.getActionForEmbeddedFile(string3, bl);
        }
        if (string2.startsWith("http://")) {
            return new PDFUri(string);
        }
        if (string2.startsWith("https://")) {
            return new PDFUri(string);
        }
        if (string2.startsWith("file://")) {
            string = string.substring("file://".length());
            return this.getLaunchAction(string);
        }
        if (string2.endsWith(".pdf")) {
            return this.getGoToPDFAction(string, null, -1, bl);
        }
        int n = string2.indexOf(".pdf#page=");
        if (n > 0) {
            String string4 = string.substring(0, n + 4);
            int n2 = Integer.parseInt(string.substring(n + 10));
            return this.getGoToPDFAction(string4, null, n2, bl);
        }
        n = string2.indexOf(".pdf#dest=");
        if (n > 0) {
            String string5 = string.substring(0, n + 4);
            String string6 = string.substring(n + 10);
            return this.getGoToPDFAction(string5, string6, -1, bl);
        }
        return new PDFUri(string);
    }

    private PDFAction getActionForEmbeddedFile(String string, boolean bl) {
        PDFWritable pDFWritable;
        CharSequence charSequence;
        PDFNames pDFNames = this.getDocument().getRoot().getNames();
        if (pDFNames == null) {
            throw new IllegalStateException("No Names dictionary present. Cannot create Launch Action for embedded file: " + string);
        }
        PDFEmbeddedFiles pDFEmbeddedFiles = pDFNames.getEmbeddedFiles();
        if (pDFEmbeddedFiles == null) {
            throw new IllegalStateException("No /EmbeddedFiles name tree present. Cannot create Launch Action for embedded file: " + string);
        }
        string = PDFText.toPDFString(string, '_');
        PDFArray pDFArray = pDFEmbeddedFiles.getNames();
        PDFReference pDFReference = null;
        for (int i = 0; i < pDFArray.length(); ++i) {
            charSequence = (String)pDFArray.get(i);
            pDFWritable = (PDFReference)pDFArray.get(++i);
            if (!((String)charSequence).equals(string)) continue;
            pDFReference = pDFWritable;
            break;
        }
        if (pDFReference == null) {
            throw new IllegalStateException("No embedded file with name " + string + " present.");
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("this.exportDataObject({cName:\"");
        ((StringBuffer)charSequence).append(string);
        ((StringBuffer)charSequence).append("\", nLaunch:2});");
        pDFWritable = new PDFJavaScriptLaunchAction(((StringBuffer)charSequence).toString());
        return pDFWritable;
    }

    public String getGoToReference(String string, float f) {
        return this.getPDFGoTo(string, new Point2D.Float(0.0f, f)).referencePDF();
    }

    public PDFGoTo getPDFGoTo(String string, Point2D point2D) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFGoTo pDFGoTo = new PDFGoTo(string, point2D);
        PDFGoTo pDFGoTo2 = this.getDocument().findGoTo(pDFGoTo);
        if (pDFGoTo2 == null) {
            this.getDocument().assignObjectNumber(pDFGoTo);
            this.getDocument().addTrailerObject(pDFGoTo);
        } else {
            pDFGoTo = pDFGoTo2;
        }
        return pDFGoTo;
    }

    private PDFGoToRemote getGoToPDFAction(String string, String string2, int n, boolean bl) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec pDFFileSpec = new PDFFileSpec(string);
        PDFFileSpec pDFFileSpec2 = this.getDocument().findFileSpec(pDFFileSpec);
        if (pDFFileSpec2 == null) {
            this.getDocument().registerObject(pDFFileSpec);
        } else {
            pDFFileSpec = pDFFileSpec2;
        }
        PDFGoToRemote pDFGoToRemote = string2 == null && n == -1 ? new PDFGoToRemote(pDFFileSpec, bl) : (string2 != null ? new PDFGoToRemote(pDFFileSpec, string2, bl) : new PDFGoToRemote(pDFFileSpec, n, bl));
        PDFGoToRemote pDFGoToRemote2 = this.getDocument().findGoToRemote(pDFGoToRemote);
        if (pDFGoToRemote2 == null) {
            this.getDocument().registerObject(pDFGoToRemote);
        } else {
            pDFGoToRemote = pDFGoToRemote2;
        }
        return pDFGoToRemote;
    }

    private PDFLaunch getLaunchAction(String string) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec pDFFileSpec = new PDFFileSpec(string);
        PDFFileSpec pDFFileSpec2 = this.getDocument().findFileSpec(pDFFileSpec);
        if (pDFFileSpec2 == null) {
            this.getDocument().registerObject(pDFFileSpec);
        } else {
            pDFFileSpec = pDFFileSpec2;
        }
        PDFLaunch pDFLaunch = new PDFLaunch(pDFFileSpec);
        PDFLaunch pDFLaunch2 = this.getDocument().findLaunch(pDFLaunch);
        if (pDFLaunch2 == null) {
            this.getDocument().registerObject(pDFLaunch);
        } else {
            pDFLaunch = pDFLaunch2;
        }
        return pDFLaunch;
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, String string2, boolean bl) {
        PDFOutline pDFOutline2 = new PDFOutline(string, string2, bl);
        if (pDFOutline != null) {
            pDFOutline.addOutline(pDFOutline2);
        }
        this.getDocument().registerObject(pDFOutline2);
        return pDFOutline2;
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, PDFAction pDFAction, boolean bl) {
        return pDFAction == null ? null : this.makeOutline(pDFOutline, string, pDFAction.getAction(), bl);
    }

    public PDFOutline makeOutline(PDFOutline pDFOutline, String string, String string2, float f, boolean bl) {
        String string3 = this.getGoToReference(string2, f);
        return this.makeOutline(pDFOutline, string, string3, bl);
    }

    public PDFEncoding makeEncoding(String string) {
        PDFEncoding pDFEncoding = new PDFEncoding(string);
        this.getDocument().registerObject(pDFEncoding);
        return pDFEncoding;
    }

    public PDFFont makeFont(String string, String string2, String string3, FontMetrics fontMetrics, FontDescriptor fontDescriptor) {
        PDFFont pDFFont = this.getDocument().findFont(string);
        if (pDFFont != null) {
            return pDFFont;
        }
        boolean bl = true;
        if (fontDescriptor == null) {
            PDFFont pDFFont2 = new PDFFont(string, FontType.TYPE1, string2, string3);
            this.getDocument().registerObject(pDFFont2);
            if (bl && !PDFEncoding.isPredefinedEncoding(string3)) {
                CodePointMapping codePointMapping;
                if (string3 != null) {
                    codePointMapping = CodePointMapping.getMapping(string3);
                } else {
                    Typeface typeface = (Typeface)fontMetrics;
                    codePointMapping = CodePointMapping.getMapping(typeface.getEncodingName());
                }
                this.generateToUnicodeCmap(pDFFont2, codePointMapping);
            }
            return pDFFont2;
        }
        FontType fontType = fontMetrics.getFontType();
        String string4 = fontDescriptor.isSubsetEmbedded() ? this.createSubsetFontPrefix() : "";
        String string5 = string4 + string2;
        PDFFontDescriptor pDFFontDescriptor = this.makeFontDescriptor(fontDescriptor, string4);
        PDFFont pDFFont3 = null;
        pDFFont3 = PDFFont.createFont(string, fontType, string5, null);
        this.getDocument().registerObject(pDFFont3);
        if (fontType == FontType.TYPE0) {
            pDFFont3.setEncoding(string3);
            CIDFont cIDFont = fontMetrics instanceof LazyFont ? (CIDFont)((LazyFont)fontMetrics).getRealFont() : (CIDFont)fontMetrics;
            PDFCIDSystemInfo pDFCIDSystemInfo = new PDFCIDSystemInfo(cIDFont.getRegistry(), cIDFont.getOrdering(), cIDFont.getSupplement());
            PDFCIDFont pDFCIDFont = new PDFCIDFont(string5, cIDFont.getCIDType(), cIDFont.getDefaultWidth(), this.getSubsetWidths(cIDFont), pDFCIDSystemInfo, (PDFCIDFontDescriptor)pDFFontDescriptor);
            this.getDocument().registerObject(pDFCIDFont);
            PDFToUnicodeCMap pDFToUnicodeCMap = new PDFToUnicodeCMap(cIDFont.getCIDSubset().getSubsetChars(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), false);
            this.getDocument().registerObject(pDFToUnicodeCMap);
            ((PDFFontType0)pDFFont3).setCMAP(pDFToUnicodeCMap);
            ((PDFFontType0)pDFFont3).setDescendantFonts(pDFCIDFont);
        } else {
            PDFFontNonBase14 pDFFontNonBase14 = (PDFFontNonBase14)pDFFont3;
            pDFFontNonBase14.setDescriptor(pDFFontDescriptor);
            SingleByteFont singleByteFont = fontMetrics instanceof LazyFont ? (SingleByteFont)((LazyFont)fontMetrics).getRealFont() : (SingleByteFont)fontMetrics;
            int n = singleByteFont.getFirstChar();
            int n2 = singleByteFont.getLastChar();
            pDFFontNonBase14.setWidthMetrics(n, n2, new PDFArray(null, fontMetrics.getWidths()));
            SingleByteEncoding singleByteEncoding = singleByteFont.getEncoding();
            if (singleByteFont.isSymbolicFont()) {
                if (bl) {
                    this.generateToUnicodeCmap(pDFFontNonBase14, singleByteEncoding);
                }
            } else if (PDFEncoding.isPredefinedEncoding(singleByteEncoding.getName())) {
                pDFFont3.setEncoding(singleByteEncoding.getName());
            } else {
                Object object = this.createPDFEncoding(singleByteEncoding, singleByteFont.getFontName());
                if (object instanceof PDFEncoding) {
                    pDFFont3.setEncoding((PDFEncoding)object);
                } else {
                    pDFFont3.setEncoding((String)object);
                }
                if (bl) {
                    this.generateToUnicodeCmap(pDFFontNonBase14, singleByteEncoding);
                }
            }
            if (singleByteFont.hasAdditionalEncodings()) {
                int n3 = singleByteFont.getAdditionalEncodingCount();
                for (int i = 0; i < n3; ++i) {
                    SimpleSingleByteEncoding simpleSingleByteEncoding = singleByteFont.getAdditionalEncoding(i);
                    String string6 = string + "_" + (i + 1);
                    Object object = this.createPDFEncoding(simpleSingleByteEncoding, singleByteFont.getFontName());
                    PDFFontNonBase14 pDFFontNonBase142 = (PDFFontNonBase14)PDFFont.createFont(string6, fontType, string2, object);
                    pDFFontNonBase142.setDescriptor(pDFFontDescriptor);
                    pDFFontNonBase142.setWidthMetrics(simpleSingleByteEncoding.getFirstChar(), simpleSingleByteEncoding.getLastChar(), new PDFArray(null, singleByteFont.getAdditionalWidths(i)));
                    this.getDocument().registerObject(pDFFontNonBase142);
                    this.getDocument().getResources().addFont(pDFFontNonBase142);
                    if (!bl) continue;
                    this.generateToUnicodeCmap(pDFFontNonBase142, simpleSingleByteEncoding);
                }
            }
        }
        return pDFFont3;
    }

    private void generateToUnicodeCmap(PDFFont pDFFont, SingleByteEncoding singleByteEncoding) {
        PDFToUnicodeCMap pDFToUnicodeCMap = new PDFToUnicodeCMap(singleByteEncoding.getUnicodeCharMap(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), true);
        this.getDocument().registerObject(pDFToUnicodeCMap);
        pDFFont.setToUnicode(pDFToUnicodeCMap);
    }

    public Object createPDFEncoding(SingleByteEncoding singleByteEncoding, String string) {
        CodePointMapping codePointMapping = string.indexOf("Symbol") >= 0 ? CodePointMapping.getMapping("SymbolEncoding") : CodePointMapping.getMapping("StandardEncoding");
        PDFEncoding pDFEncoding = new PDFEncoding(codePointMapping.getName());
        PDFEncoding.DifferencesBuilder differencesBuilder = pDFEncoding.createDifferencesBuilder();
        int n = -1;
        String[] stringArray = codePointMapping.getCharNameMap();
        String[] stringArray2 = singleByteEncoding.getCharNameMap();
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            String string3 = stringArray2[i];
            if (string2.equals(string3)) continue;
            if (n != i) {
                differencesBuilder.addDifference(i);
                n = i;
            }
            differencesBuilder.addName(string3);
            ++n;
        }
        if (differencesBuilder.hasDifferences()) {
            pDFEncoding.setDifferences(differencesBuilder.toPDFArray());
            return pDFEncoding;
        }
        return codePointMapping.getName();
    }

    public PDFWArray getSubsetWidths(CIDFont cIDFont) {
        PDFWArray pDFWArray = new PDFWArray();
        int[] nArray = cIDFont.getWidths();
        CIDSubset cIDSubset = cIDFont.getCIDSubset();
        int[] nArray2 = new int[cIDSubset.getSubsetSize()];
        int n = cIDSubset.getSubsetSize();
        for (int i = 0; i < n; ++i) {
            int n2 = Math.max(0, cIDSubset.getGlyphIndexForSubsetIndex(i));
            nArray2[i] = nArray[n2];
        }
        pDFWArray.addEntry(0, nArray2);
        return pDFWArray;
    }

    private String createSubsetFontPrefix() {
        ++this.subsetFontCounter;
        DecimalFormat decimalFormat = new DecimalFormat("00000");
        String string = decimalFormat.format(this.subsetFontCounter);
        StringBuffer stringBuffer = new StringBuffer("E");
        for (char c : string.toCharArray()) {
            stringBuffer.append((char)(c + 17));
        }
        stringBuffer.append("+");
        return stringBuffer.toString();
    }

    private PDFFontDescriptor makeFontDescriptor(FontDescriptor fontDescriptor, String string) {
        PDFFontDescriptor pDFFontDescriptor = null;
        pDFFontDescriptor = fontDescriptor.getFontType() == FontType.TYPE0 ? new PDFCIDFontDescriptor(string + fontDescriptor.getEmbedFontName(), fontDescriptor.getFontBBox(), fontDescriptor.getCapHeight(), fontDescriptor.getFlags(), fontDescriptor.getItalicAngle(), fontDescriptor.getStemV(), null) : new PDFFontDescriptor(fontDescriptor.getEmbedFontName(), fontDescriptor.getAscender(), fontDescriptor.getDescender(), fontDescriptor.getCapHeight(), fontDescriptor.getFlags(), new PDFRectangle(fontDescriptor.getFontBBox()), fontDescriptor.getItalicAngle(), fontDescriptor.getStemV());
        this.getDocument().registerObject(pDFFontDescriptor);
        if (fontDescriptor.isEmbeddable()) {
            CustomFont customFont;
            AbstractPDFStream abstractPDFStream = this.makeFontFile(fontDescriptor);
            if (abstractPDFStream != null) {
                pDFFontDescriptor.setFontFile(fontDescriptor.getFontType(), abstractPDFStream);
                this.getDocument().registerObject(abstractPDFStream);
            }
            if ((customFont = this.getCustomFont(fontDescriptor)) instanceof CIDFont) {
                CIDFont cIDFont = (CIDFont)customFont;
                this.buildCIDSet(pDFFontDescriptor, cIDFont);
            }
        }
        return pDFFontDescriptor;
    }

    private void buildCIDSet(PDFFontDescriptor pDFFontDescriptor, CIDFont cIDFont) {
        BitSet bitSet = cIDFont.getCIDSubset().getGlyphIndexBitSet();
        PDFStream pDFStream = this.makeStream(null, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bitSet.length() / 8 + 1);
        int n = 0;
        int n2 = bitSet.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = i % 8;
            boolean bl = bitSet.get(i);
            if (bl) {
                n |= 1 << 7 - n3;
            }
            if (n3 != 7) continue;
            byteArrayOutputStream.write(n);
            n = 0;
        }
        byteArrayOutputStream.write(n);
        try {
            pDFStream.setData(byteArrayOutputStream.toByteArray());
            pDFFontDescriptor.setCIDSet(pDFStream);
        }
        catch (IOException iOException) {
            this.log.error((Object)("Failed to write CIDSet [" + cIDFont + "] " + cIDFont.getEmbedFontName()), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPDFStream makeFontFile(FontDescriptor fontDescriptor) {
        Object object;
        if (fontDescriptor.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + fontDescriptor.getFontType());
        }
        CustomFont customFont = this.getCustomFont(fontDescriptor);
        InputStream inputStream = null;
        Source source = customFont.getEmbedFileSource();
        if (source == null && customFont.getEmbedResourceName() != null) {
            source = new StreamSource(this.getClass().getResourceAsStream(customFont.getEmbedResourceName()));
        }
        if (source == null) {
            return null;
        }
        if (source instanceof StreamSource) {
            inputStream = ((StreamSource)source).getInputStream();
        }
        if (inputStream == null && source.getSystemId() != null) {
            try {
                inputStream = new URL(source.getSystemId()).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                new FileNotFoundException("File not found. URL could not be resolved: " + malformedURLException.getMessage());
            }
        }
        if (inputStream == null) {
            return null;
        }
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            AbstractPDFFontStream abstractPDFFontStream;
            if (fontDescriptor.getFontType() == FontType.TYPE0) {
                object = (MultiByteFont)customFont;
                FontFileReader fontFileReader = new FontFileReader(inputStream);
                TTFSubSetFile tTFSubSetFile = new TTFSubSetFile();
                tTFSubSetFile.readFont(fontFileReader, ((MultiByteFont)object).getTTCName(), ((MultiByteFont)object).getUsedGlyphs());
                byte[] byArray = tTFSubSetFile.getFontSubset();
                abstractPDFFontStream = new PDFTTFStream(byArray.length);
                ((PDFTTFStream)abstractPDFFontStream).setData(byArray, byArray.length);
            } else if (fontDescriptor.getFontType() == FontType.TYPE1) {
                object = new PFBParser();
                PFBData pFBData = ((PFBParser)object).parsePFB(inputStream);
                abstractPDFFontStream = new PDFT1Stream();
                ((PDFT1Stream)abstractPDFFontStream).setData(pFBData);
            } else {
                object = IOUtils.toByteArray((InputStream)inputStream);
                abstractPDFFontStream = new PDFTTFStream(((Object)object).length);
                ((PDFTTFStream)abstractPDFFontStream).setData((byte[])object, ((Object)object).length);
            }
            object = abstractPDFFontStream;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.log.error((Object)("Failed to embed font [" + fontDescriptor + "] " + fontDescriptor.getEmbedFontName()), (Throwable)iOException);
                return null;
            }
        }
        inputStream.close();
        return object;
    }

    private CustomFont getCustomFont(FontDescriptor fontDescriptor) {
        Typeface typeface = fontDescriptor instanceof LazyFont ? ((LazyFont)fontDescriptor).getRealFont() : (Typeface)((Object)fontDescriptor);
        if (!(typeface instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + fontDescriptor.getClass().getName());
        }
        return (CustomFont)typeface;
    }

    public PDFStream makeStream(String string, boolean bl) {
        PDFStream pDFStream = new PDFStream();
        pDFStream.setDocument(this.getDocument());
        pDFStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), string);
        if (bl) {
            this.getDocument().registerObject(pDFStream);
        }
        return pDFStream;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream pDFICCStream = new PDFICCStream();
        this.getDocument().registerObject(pDFICCStream);
        return pDFICCStream;
    }

    public PDFICCBasedColorSpace makeICCBasedColorSpace(PDFResourceContext pDFResourceContext, String string, PDFICCStream pDFICCStream) {
        PDFICCBasedColorSpace pDFICCBasedColorSpace = new PDFICCBasedColorSpace(string, pDFICCStream);
        this.getDocument().registerObject(pDFICCBasedColorSpace);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addColorSpace(pDFICCBasedColorSpace);
        } else {
            this.getDocument().getResources().addColorSpace(pDFICCBasedColorSpace);
        }
        return pDFICCBasedColorSpace;
    }

    public PDFSeparationColorSpace makeSeparationColorSpace(PDFResourceContext pDFResourceContext, NamedColorSpace namedColorSpace) {
        String string = namedColorSpace.getColorName();
        Double d = new Double(0.0);
        Double d2 = new Double(1.0);
        List<Double> list = Arrays.asList(d, d2);
        List<Double> list2 = Arrays.asList(d, d2, d, d2, d, d2);
        List<Double> list3 = Arrays.asList(d2, d2, d2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        float[] fArray = namedColorSpace.getRGBColor().getColorComponents(null);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(fArray[i]));
        }
        PDFFunction pDFFunction = this.makeFunction(2, list, list2, list3, arrayList, 1.0);
        PDFSeparationColorSpace pDFSeparationColorSpace = new PDFSeparationColorSpace(string, pDFFunction);
        this.getDocument().registerObject(pDFSeparationColorSpace);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addColorSpace(pDFSeparationColorSpace);
        } else {
            this.getDocument().getResources().addColorSpace(pDFSeparationColorSpace);
        }
        return pDFSeparationColorSpace;
    }

    public PDFArray makeArray(int[] nArray) {
        PDFArray pDFArray = new PDFArray(null, nArray);
        this.getDocument().registerObject(pDFArray);
        return pDFArray;
    }

    public PDFGState makeGState(Map map, PDFGState pDFGState) {
        PDFGState pDFGState2 = new PDFGState();
        pDFGState2.addValues(PDFGState.DEFAULT);
        pDFGState2.addValues(map);
        PDFGState pDFGState3 = this.getDocument().findGState(pDFGState2, pDFGState);
        if (pDFGState3 != null) {
            return pDFGState3;
        }
        PDFGState pDFGState4 = new PDFGState();
        pDFGState4.addValues(map);
        this.getDocument().registerObject(pDFGState4);
        return pDFGState4;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList pDFAnnotList = new PDFAnnotList();
        this.getDocument().assignObjectNumber(pDFAnnotList);
        return pDFAnnotList;
    }
}

