/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;

public class PDFEncoding
extends PDFDictionary {
    public static final String STANDARD_ENCODING = "StandardEncoding";
    public static final String MAC_ROMAN_ENCODING = "MacRomanEncoding";
    public static final String MAC_EXPERT_ENCODING = "MacExpertEncoding";
    public static final String WIN_ANSI_ENCODING = "WinAnsiEncoding";
    public static final String PDF_DOC_ENCODING = "PDFDocEncoding";
    private static final Set PREDEFINED_ENCODINGS;

    public PDFEncoding(String string) {
        this.put("Type", new PDFName("Encoding"));
        if (string != null) {
            this.put("BaseEncoding", new PDFName(string));
        }
    }

    public static boolean isPredefinedEncoding(String string) {
        return PREDEFINED_ENCODINGS.contains(string);
    }

    public DifferencesBuilder createDifferencesBuilder() {
        return new DifferencesBuilder();
    }

    public void setDifferences(PDFArray pDFArray) {
        this.put("Differences", pDFArray);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(STANDARD_ENCODING);
        hashSet.add(MAC_ROMAN_ENCODING);
        hashSet.add(MAC_EXPERT_ENCODING);
        hashSet.add(WIN_ANSI_ENCODING);
        hashSet.add(PDF_DOC_ENCODING);
        PREDEFINED_ENCODINGS = Collections.unmodifiableSet(hashSet);
    }

    public class DifferencesBuilder {
        private PDFArray differences = new PDFArray();
        private int currentCode = -1;

        public DifferencesBuilder addDifference(int n) {
            this.currentCode = n;
            this.differences.add(new Integer(n));
            return this;
        }

        public DifferencesBuilder addName(String string) {
            if (this.currentCode < 0) {
                throw new IllegalStateException("addDifference(int) must be called first");
            }
            this.differences.add(new PDFName(string));
            return this;
        }

        public boolean hasDifferences() {
            return this.differences.length() > 0;
        }

        public PDFArray toPDFArray() {
            return this.differences;
        }
    }
}

