/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.DestinationComparator;
import org.apache.fop.pdf.FileIDGenerator;
import org.apache.fop.pdf.ObjectStreamManager;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFProfile;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.pdf.Version;
import org.apache.fop.pdf.VersionController;
import org.apache.fop.pdf.xref.CrossReferenceStream;
import org.apache.fop.pdf.xref.CrossReferenceTable;
import org.apache.fop.pdf.xref.TrailerDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFDocument {
    public static final String ENCODING = "ISO-8859-1";
    protected int objectcount;
    private Log log = LogFactory.getLog((String)"org.apache.fop.pdf");
    private long position;
    private List<Long> indirectObjectOffsets = new ArrayList<Long>();
    private Collection<PDFStructElem> structureTreeElements;
    private List<PDFObject> trailerObjects = new ArrayList<PDFObject>();
    private List<PDFObject> objects = new LinkedList<PDFObject>();
    private VersionController versionController;
    private PDFProfile pdfProfile = new PDFProfile(this);
    private PDFRoot root;
    private PDFOutline outlineRoot;
    private PDFPages pages;
    private PDFInfo info;
    private PDFResources resources;
    private PDFEncryption encryption;
    private PDFDeviceColorSpace colorspace = new PDFDeviceColorSpace(2);
    private int patternCount;
    private int shadingCount;
    private int xObjectCount;
    private Map<String, PDFXObject> xObjectsMap = new HashMap<String, PDFXObject>();
    private Map<String, PDFFont> fontMap = new HashMap<String, PDFFont>();
    private Map<String, List<String>> filterMap = new HashMap<String, List<String>>();
    private List<PDFGState> gstates = new ArrayList<PDFGState>();
    private List<PDFFunction> functions = new ArrayList<PDFFunction>();
    private List<PDFShading> shadings = new ArrayList<PDFShading>();
    private List<PDFPattern> patterns = new ArrayList<PDFPattern>();
    private List<PDFLink> links = new ArrayList<PDFLink>();
    private List<PDFDestination> destinations;
    private List<PDFFileSpec> filespecs = new ArrayList<PDFFileSpec>();
    private List<PDFGoToRemote> gotoremotes = new ArrayList<PDFGoToRemote>();
    private List<PDFGoTo> gotos = new ArrayList<PDFGoTo>();
    private List<PDFLaunch> launches = new ArrayList<PDFLaunch>();
    private PDFFactory factory = new PDFFactory(this);
    private FileIDGenerator fileIDGenerator;
    private boolean accessibilityEnabled;

    public PDFDocument(String string) {
        this(string, null);
        this.versionController = VersionController.getDynamicVersionController(Version.V1_4, this);
    }

    public PDFDocument(String string, VersionController versionController) {
        this.pages = this.getFactory().makePages();
        this.root = this.getFactory().makeRoot(this.pages);
        this.resources = this.getFactory().makeResources();
        this.info = this.getFactory().makeInfo(string);
        this.versionController = versionController;
    }

    public Version getPDFVersion() {
        return this.versionController.getPDFVersion();
    }

    public void setPDFVersion(Version version) {
        this.versionController.setPDFVersion(version);
    }

    public String getPDFVersionString() {
        return this.versionController.getPDFVersion().toString();
    }

    public PDFProfile getProfile() {
        return this.pdfProfile;
    }

    public PDFFactory getFactory() {
        return this.factory;
    }

    public static byte[] encode(String string) {
        try {
            return string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static void flushTextBuffer(StringBuilder stringBuilder, OutputStream outputStream) throws IOException {
        outputStream.write(PDFDocument.encode(stringBuilder.toString()));
        stringBuilder.setLength(0);
    }

    public void setProducer(String string) {
        this.info.setProducer(string);
    }

    public void setCreationDate(Date date) {
        this.info.setCreationDate(date);
    }

    public void setCreator(String string) {
        this.info.setCreator(string);
    }

    public void setFilterMap(Map<String, List<String>> map) {
        this.filterMap = map;
    }

    public Map<String, List<String>> getFilterMap() {
        return this.filterMap;
    }

    public PDFPages getPages() {
        return this.pages;
    }

    public PDFRoot getRoot() {
        return this.root;
    }

    public PDFStructTreeRoot makeStructTreeRoot(PDFParentTree pDFParentTree) {
        PDFStructTreeRoot pDFStructTreeRoot = new PDFStructTreeRoot(pDFParentTree);
        this.assignObjectNumber(pDFStructTreeRoot);
        this.addTrailerObject(pDFStructTreeRoot);
        this.root.setStructTreeRoot(pDFStructTreeRoot);
        this.structureTreeElements = new ArrayList<PDFStructElem>();
        return pDFStructTreeRoot;
    }

    public PDFStructElem makeStructureElement(PDFName pDFName, PDFObject pDFObject) {
        PDFStructElem pDFStructElem = new PDFStructElem(pDFObject, pDFName);
        this.assignObjectNumber(pDFStructElem);
        this.structureTreeElements.add(pDFStructElem);
        return pDFStructElem;
    }

    public PDFInfo getInfo() {
        return this.info;
    }

    public PDFObject registerObject(PDFObject pDFObject) {
        this.assignObjectNumber(pDFObject);
        this.addObject(pDFObject);
        return pDFObject;
    }

    public void assignObjectNumber(PDFObject pDFObject) {
        if (pDFObject == null) {
            throw new NullPointerException("obj must not be null");
        }
        if (pDFObject.hasObjectNumber()) {
            throw new IllegalStateException("Error registering a PDFObject: PDFObject already has an object number");
        }
        PDFDocument pDFDocument = pDFObject.getDocument();
        if (pDFDocument != null && pDFDocument != this) {
            throw new IllegalStateException("Error registering a PDFObject: PDFObject already has a parent PDFDocument");
        }
        pDFObject.setObjectNumber(++this.objectcount);
        if (pDFDocument == null) {
            pDFObject.setDocument(this);
        }
    }

    public void addObject(PDFObject pDFObject) {
        Object object;
        if (pDFObject == null) {
            throw new NullPointerException("obj must not be null");
        }
        if (!pDFObject.hasObjectNumber()) {
            throw new IllegalStateException("Error adding a PDFObject: PDFObject doesn't have an object number");
        }
        this.objects.add(pDFObject);
        if (pDFObject instanceof PDFFunction) {
            this.functions.add((PDFFunction)pDFObject);
        }
        if (pDFObject instanceof PDFShading) {
            object = "Sh" + ++this.shadingCount;
            ((PDFShading)pDFObject).setName((String)object);
            this.shadings.add((PDFShading)pDFObject);
        }
        if (pDFObject instanceof PDFPattern) {
            object = "Pa" + ++this.patternCount;
            ((PDFPattern)pDFObject).setName((String)object);
            this.patterns.add((PDFPattern)pDFObject);
        }
        if (pDFObject instanceof PDFFont) {
            object = (PDFFont)pDFObject;
            this.fontMap.put(((PDFFont)object).getName(), (PDFFont)object);
        }
        if (pDFObject instanceof PDFGState) {
            this.gstates.add((PDFGState)pDFObject);
        }
        if (pDFObject instanceof PDFPage) {
            this.pages.notifyKidRegistered((PDFPage)pDFObject);
        }
        if (pDFObject instanceof PDFLaunch) {
            this.launches.add((PDFLaunch)pDFObject);
        }
        if (pDFObject instanceof PDFLink) {
            this.links.add((PDFLink)pDFObject);
        }
        if (pDFObject instanceof PDFFileSpec) {
            this.filespecs.add((PDFFileSpec)pDFObject);
        }
        if (pDFObject instanceof PDFGoToRemote) {
            this.gotoremotes.add((PDFGoToRemote)pDFObject);
        }
    }

    public void addTrailerObject(PDFObject pDFObject) {
        this.trailerObjects.add(pDFObject);
        if (pDFObject instanceof PDFGoTo) {
            this.gotos.add((PDFGoTo)pDFObject);
        }
    }

    public void applyEncryption(AbstractPDFStream abstractPDFStream) {
        if (this.isEncryptionActive()) {
            this.encryption.applyFilter(abstractPDFStream);
        }
    }

    public void setEncryption(PDFEncryptionParams pDFEncryptionParams) {
        this.getProfile().verifyEncryptionAllowed();
        this.fileIDGenerator = FileIDGenerator.getRandomFileIDGenerator();
        this.encryption = PDFEncryptionManager.newInstance(++this.objectcount, pDFEncryptionParams, this);
        if (this.encryption != null) {
            PDFObject pDFObject = (PDFObject)((Object)this.encryption);
            this.addTrailerObject(pDFObject);
        } else {
            this.log.warn((Object)"PDF encryption is unavailable. PDF will be generated without encryption.");
        }
    }

    public boolean isEncryptionActive() {
        return this.encryption != null;
    }

    public PDFEncryption getEncryption() {
        return this.encryption;
    }

    private Object findPDFObject(List<? extends PDFObject> list, PDFObject pDFObject) {
        for (PDFObject pDFObject2 : list) {
            if (!pDFObject.contentEquals(pDFObject2)) continue;
            return pDFObject2;
        }
        return null;
    }

    protected PDFFunction findFunction(PDFFunction pDFFunction) {
        return (PDFFunction)this.findPDFObject(this.functions, pDFFunction);
    }

    protected PDFShading findShading(PDFShading pDFShading) {
        return (PDFShading)this.findPDFObject(this.shadings, pDFShading);
    }

    protected PDFPattern findPattern(PDFPattern pDFPattern) {
        return (PDFPattern)this.findPDFObject(this.patterns, pDFPattern);
    }

    protected PDFFont findFont(String string) {
        return this.fontMap.get(string);
    }

    protected PDFDestination findDestination(PDFDestination pDFDestination) {
        int n = this.getDestinationList().indexOf(pDFDestination);
        if (n >= 0) {
            return this.getDestinationList().get(n);
        }
        return null;
    }

    protected PDFLink findLink(PDFLink pDFLink) {
        return (PDFLink)this.findPDFObject(this.links, pDFLink);
    }

    protected PDFFileSpec findFileSpec(PDFFileSpec pDFFileSpec) {
        return (PDFFileSpec)this.findPDFObject(this.filespecs, pDFFileSpec);
    }

    protected PDFGoToRemote findGoToRemote(PDFGoToRemote pDFGoToRemote) {
        return (PDFGoToRemote)this.findPDFObject(this.gotoremotes, pDFGoToRemote);
    }

    protected PDFGoTo findGoTo(PDFGoTo pDFGoTo) {
        return (PDFGoTo)this.findPDFObject(this.gotos, pDFGoTo);
    }

    protected PDFLaunch findLaunch(PDFLaunch pDFLaunch) {
        return (PDFLaunch)this.findPDFObject(this.launches, pDFLaunch);
    }

    protected PDFGState findGState(PDFGState pDFGState, PDFGState pDFGState2) {
        for (PDFGState pDFGState3 : this.gstates) {
            PDFGState pDFGState4 = new PDFGState();
            pDFGState4.addValues(pDFGState2);
            pDFGState4.addValues(pDFGState3);
            if (!pDFGState4.equals(pDFGState)) continue;
            return pDFGState3;
        }
        return null;
    }

    public PDFDeviceColorSpace getPDFColorSpace() {
        return this.colorspace;
    }

    public int getColorSpace() {
        return this.getPDFColorSpace().getColorSpace();
    }

    public void setColorSpace(int n) {
        this.colorspace.setColorSpace(n);
    }

    public Map<String, PDFFont> getFontMap() {
        return this.fontMap;
    }

    protected InputStream resolveURI(String string) throws FileNotFoundException {
        try {
            return new URL(string).openStream();
        }
        catch (Exception exception) {
            throw new FileNotFoundException("URI could not be resolved (" + exception.getMessage() + "): " + string);
        }
    }

    @Deprecated
    public PDFImageXObject getImage(String string) {
        return (PDFImageXObject)this.xObjectsMap.get(string);
    }

    public PDFXObject getXObject(String string) {
        return this.xObjectsMap.get(string);
    }

    public void addDestination(PDFDestination pDFDestination) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<PDFDestination>();
        }
        this.destinations.add(pDFDestination);
    }

    public List<PDFDestination> getDestinationList() {
        if (this.hasDestinations()) {
            return this.destinations;
        }
        return Collections.emptyList();
    }

    public boolean hasDestinations() {
        return this.destinations != null && !this.destinations.isEmpty();
    }

    public PDFImageXObject addImage(PDFResourceContext pDFResourceContext, PDFImage pDFImage) {
        String string = pDFImage.getKey();
        PDFImageXObject pDFImageXObject = (PDFImageXObject)this.xObjectsMap.get(string);
        if (pDFImageXObject != null) {
            if (pDFResourceContext != null) {
                pDFResourceContext.getPDFResources().addXObject(pDFImageXObject);
            }
            return pDFImageXObject;
        }
        pDFImage.setup(this);
        pDFImageXObject = new PDFImageXObject(++this.xObjectCount, pDFImage);
        this.registerObject(pDFImageXObject);
        this.resources.addXObject(pDFImageXObject);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addXObject(pDFImageXObject);
        }
        this.xObjectsMap.put(string, pDFImageXObject);
        return pDFImageXObject;
    }

    public PDFFormXObject addFormXObject(PDFResourceContext pDFResourceContext, PDFStream pDFStream, PDFReference pDFReference, String string) {
        PDFFormXObject pDFFormXObject = (PDFFormXObject)this.xObjectsMap.get(string);
        if (pDFFormXObject != null) {
            if (pDFResourceContext != null) {
                pDFResourceContext.getPDFResources().addXObject(pDFFormXObject);
            }
            return pDFFormXObject;
        }
        pDFFormXObject = new PDFFormXObject(++this.xObjectCount, pDFStream, pDFReference);
        this.registerObject(pDFFormXObject);
        this.resources.addXObject(pDFFormXObject);
        if (pDFResourceContext != null) {
            pDFResourceContext.getPDFResources().addXObject(pDFFormXObject);
        }
        this.xObjectsMap.put(string, pDFFormXObject);
        return pDFFormXObject;
    }

    public PDFOutline getOutlineRoot() {
        if (this.outlineRoot != null) {
            return this.outlineRoot;
        }
        this.outlineRoot = new PDFOutline(null, null, true);
        this.assignObjectNumber(this.outlineRoot);
        this.addTrailerObject(this.outlineRoot);
        this.root.setRootOutline(this.outlineRoot);
        return this.outlineRoot;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public void enableAccessibility(boolean bl) {
        this.accessibilityEnabled = bl;
    }

    public void output(OutputStream outputStream) throws IOException {
        while (this.objects.size() > 0) {
            PDFObject pDFObject = this.objects.remove(0);
            this.streamIndirectObject(pDFObject, outputStream);
        }
    }

    private void streamIndirectObject(PDFObject pDFObject, OutputStream outputStream) throws IOException {
        this.recordObjectOffset(pDFObject);
        this.position += (long)PDFDocument.outputIndirectObject(pDFObject, outputStream);
    }

    private void streamIndirectObjects(Collection<? extends PDFObject> collection, OutputStream outputStream) throws IOException {
        for (PDFObject pDFObject : collection) {
            this.streamIndirectObject(pDFObject, outputStream);
        }
    }

    private void recordObjectOffset(PDFObject pDFObject) {
        int n = pDFObject.getObjectNumber() - 1;
        while (this.indirectObjectOffsets.size() <= n) {
            this.indirectObjectOffsets.add(null);
        }
        this.indirectObjectOffsets.set(n, this.position);
    }

    public static int outputIndirectObject(PDFObject pDFObject, OutputStream outputStream) throws IOException {
        if (!pDFObject.hasObjectNumber()) {
            throw new IllegalArgumentException("Not an indirect object");
        }
        byte[] byArray = PDFDocument.encode(pDFObject.getObjectID());
        outputStream.write(byArray);
        int n = pDFObject.output(outputStream);
        byte[] byArray2 = PDFDocument.encode("\nendobj\n");
        outputStream.write(byArray2);
        return byArray.length + n + byArray2.length;
    }

    public void outputHeader(OutputStream outputStream) throws IOException {
        this.position = 0L;
        this.getProfile().verifyPDFVersion();
        byte[] byArray = PDFDocument.encode("%PDF-" + this.getPDFVersionString() + "\n");
        outputStream.write(byArray);
        this.position += (long)byArray.length;
        byte[] byArray2 = new byte[]{37, -86, -85, -84, -83, 10};
        outputStream.write(byArray2);
        this.position += (long)byArray2.length;
    }

    public void outputTrailer(OutputStream outputStream) throws IOException {
        this.createDestinations();
        this.output(outputStream);
        this.outputTrailerObjectsAndXref(outputStream);
    }

    private void createDestinations() {
        if (this.hasDestinations()) {
            Collections.sort(this.destinations, new DestinationComparator());
            PDFDests pDFDests = this.getFactory().makeDests(this.destinations);
            if (this.root.getNames() == null) {
                this.root.setNames(this.getFactory().makeNames());
            }
            this.root.getNames().setDests(pDFDests);
        }
    }

    private void outputTrailerObjectsAndXref(OutputStream outputStream) throws IOException {
        TrailerOutputHelper trailerOutputHelper;
        TrailerOutputHelper trailerOutputHelper2 = trailerOutputHelper = this.mayCompressStructureTreeElements() ? new CompressedTrailerOutputHelper() : new UncompressedTrailerOutputHelper();
        if (this.structureTreeElements != null) {
            trailerOutputHelper.outputStructureTreeElements(outputStream);
        }
        this.streamIndirectObjects(this.trailerObjects, outputStream);
        TrailerDictionary trailerDictionary = this.createTrailerDictionary();
        long l = trailerOutputHelper.outputCrossReferenceObject(outputStream, trailerDictionary);
        String string = "startxref\n" + l + "\n%%EOF\n";
        outputStream.write(PDFDocument.encode(string));
    }

    private boolean mayCompressStructureTreeElements() {
        return this.accessibilityEnabled && this.versionController.getPDFVersion().compareTo(Version.V1_5) >= 0;
    }

    private TrailerDictionary createTrailerDictionary() {
        FileIDGenerator fileIDGenerator = this.getFileIDGenerator();
        TrailerDictionary trailerDictionary = new TrailerDictionary(this).setRoot(this.root).setInfo(this.info).setFileID(fileIDGenerator.getOriginalFileID(), fileIDGenerator.getUpdatedFileID());
        if (this.isEncryptionActive()) {
            trailerDictionary.setEncryption(this.encryption);
        }
        return trailerDictionary;
    }

    long getCurrentFileSize() {
        return this.position;
    }

    FileIDGenerator getFileIDGenerator() {
        if (this.fileIDGenerator == null) {
            try {
                this.fileIDGenerator = FileIDGenerator.getDigestFileIDGenerator(this);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.fileIDGenerator = FileIDGenerator.getRandomFileIDGenerator();
            }
        }
        return this.fileIDGenerator;
    }

    private class CompressedTrailerOutputHelper
    implements TrailerOutputHelper {
        private ObjectStreamManager structureTreeObjectStreams;

        private CompressedTrailerOutputHelper() {
        }

        public void outputStructureTreeElements(OutputStream outputStream) throws IOException {
            assert (PDFDocument.this.structureTreeElements.size() > 0);
            this.structureTreeObjectStreams = new ObjectStreamManager(PDFDocument.this);
            for (PDFStructElem pDFStructElem : PDFDocument.this.structureTreeElements) {
                this.structureTreeObjectStreams.add(pDFStructElem);
            }
        }

        public long outputCrossReferenceObject(OutputStream outputStream, TrailerDictionary trailerDictionary) throws IOException {
            assert (PDFDocument.this.objects.isEmpty());
            new CrossReferenceStream(PDFDocument.this, ++PDFDocument.this.objectcount, trailerDictionary, PDFDocument.this.position, PDFDocument.this.indirectObjectOffsets, this.structureTreeObjectStreams.getCompressedObjectReferences()).output(outputStream);
            return PDFDocument.this.position;
        }
    }

    private class UncompressedTrailerOutputHelper
    implements TrailerOutputHelper {
        private UncompressedTrailerOutputHelper() {
        }

        public void outputStructureTreeElements(OutputStream outputStream) throws IOException {
            PDFDocument.this.streamIndirectObjects(PDFDocument.this.structureTreeElements, outputStream);
        }

        public long outputCrossReferenceObject(OutputStream outputStream, TrailerDictionary trailerDictionary) throws IOException {
            new CrossReferenceTable(trailerDictionary, PDFDocument.this.position, PDFDocument.this.indirectObjectOffsets).output(outputStream);
            return PDFDocument.this.position;
        }
    }

    private static interface TrailerOutputHelper {
        public void outputStructureTreeElements(OutputStream var1) throws IOException;

        public long outputCrossReferenceObject(OutputStream var1, TrailerDictionary var2) throws IOException;
    }
}

