/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;

public class PDFColor
extends PDFPathPaint {
    private static double blackFactor = 2.0;
    private double red = -1.0;
    private double green = -1.0;
    private double blue = -1.0;
    private double cyan = -1.0;
    private double magenta = -1.0;
    private double yellow = -1.0;
    private double black = -1.0;

    public PDFColor(double d, double d2, double d3) {
        this.colorSpace = new PDFDeviceColorSpace(2);
        this.red = d;
        this.green = d2;
        this.blue = d3;
    }

    public PDFColor(Color color) {
        ColorSpace colorSpace = color.getColorSpace();
        if (colorSpace != null && colorSpace instanceof DeviceCMYKColorSpace) {
            this.colorSpace = new PDFDeviceColorSpace(3);
            float[] fArray = color.getColorComponents(null);
            this.cyan = fArray[0];
            this.magenta = fArray[1];
            this.yellow = fArray[2];
            this.black = fArray[3];
        } else {
            this.colorSpace = new PDFDeviceColorSpace(2);
            float[] fArray = new float[3];
            fArray = color.getColorComponents(fArray);
            this.red = fArray[0];
            this.green = fArray[1];
            this.blue = fArray[2];
        }
    }

    public PDFColor(int n, int n2, int n3) {
        this((double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0);
    }

    public PDFColor(double d, double d2, double d3, double d4) {
        this.colorSpace = new PDFDeviceColorSpace(3);
        this.cyan = d;
        this.magenta = d2;
        this.yellow = d3;
        this.black = d4;
    }

    public List getVector() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.colorSpace.getColorSpace() == 2) {
            arrayList.add(new Double(this.red));
            arrayList.add(new Double(this.green));
            arrayList.add(new Double(this.blue));
        } else if (this.colorSpace.getColorSpace() == 3) {
            arrayList.add(new Double(this.cyan));
            arrayList.add(new Double(this.magenta));
            arrayList.add(new Double(this.yellow));
            arrayList.add(new Double(this.black));
        } else {
            arrayList.add(new Double(this.black));
        }
        return arrayList;
    }

    public double red() {
        return this.red;
    }

    public double green() {
        return this.green;
    }

    public double blue() {
        return this.blue;
    }

    public int red255() {
        return (int)(this.red * 255.0);
    }

    public int green255() {
        return (int)(this.green * 255.0);
    }

    public int blue255() {
        return (int)(this.blue * 255.0);
    }

    public double cyan() {
        return this.cyan;
    }

    public double magenta() {
        return this.magenta;
    }

    public double yellow() {
        return this.yellow;
    }

    public double black() {
        return this.black;
    }

    public void setColorSpace(int n) {
        int n2 = this.colorSpace.getColorSpace();
        if (n2 != n) {
            if (n2 == 2) {
                if (n == 3) {
                    this.convertRGBtoCMYK();
                } else {
                    this.convertRGBtoGRAY();
                }
            } else if (n2 == 3) {
                if (n == 2) {
                    this.convertCMYKtoRGB();
                } else {
                    this.convertCMYKtoGRAY();
                }
            } else if (n == 2) {
                this.convertGRAYtoRGB();
            } else {
                this.convertGRAYtoCMYK();
            }
            this.colorSpace.setColorSpace(n);
        }
    }

    public String getColorSpaceOut(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.colorSpace.getColorSpace() == 2) {
            boolean bl2 = false;
            if (this.red == this.green && this.red == this.blue) {
                bl2 = true;
            }
            if (bl) {
                if (bl2) {
                    stringBuffer.append(PDFNumber.doubleOut(this.red) + " g\n");
                } else {
                    stringBuffer.append(PDFNumber.doubleOut(this.red) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " rg\n");
                }
            } else if (bl2) {
                stringBuffer.append(PDFNumber.doubleOut(this.red) + " G\n");
            } else {
                stringBuffer.append(PDFNumber.doubleOut(this.red) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " RG\n");
            }
        } else if (this.colorSpace.getColorSpace() == 3) {
            if (bl) {
                stringBuffer.append(PDFNumber.doubleOut(this.cyan) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " k\n");
            } else {
                stringBuffer.append(PDFNumber.doubleOut(this.cyan) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " K\n");
            }
        } else if (bl) {
            stringBuffer.append(PDFNumber.doubleOut(this.black) + " g\n");
        } else {
            stringBuffer.append(PDFNumber.doubleOut(this.black) + " G\n");
        }
        return stringBuffer.toString();
    }

    protected void convertCMYKtoRGB() {
        this.red = 1.0 - this.cyan;
        this.green = 1.0 - this.green;
        this.blue = 1.0 - this.yellow;
        this.red = this.black / blackFactor + this.red;
        this.green = this.black / blackFactor + this.green;
        this.blue = this.black / blackFactor + this.blue;
    }

    protected void convertRGBtoCMYK() {
        this.cyan = 1.0 - this.red;
        this.magenta = 1.0 - this.green;
        this.yellow = 1.0 - this.blue;
        this.black = 0.0;
    }

    protected void convertGRAYtoRGB() {
        this.red = 1.0 - this.black;
        this.green = 1.0 - this.black;
        this.blue = 1.0 - this.black;
    }

    protected void convertGRAYtoCMYK() {
        this.cyan = this.black;
        this.magenta = this.black;
        this.yellow = this.black;
    }

    protected void convertCMYKtoGRAY() {
        double d = 0.0;
        d = this.cyan;
        if (this.magenta < d) {
            d = this.magenta;
        }
        if (this.yellow < d) {
            d = this.yellow;
        }
        this.black = d / blackFactor;
    }

    protected void convertRGBtoGRAY() {
        double d = 0.0;
        d = this.red;
        if (this.green < d) {
            d = this.green;
        }
        if (this.blue < d) {
            d = this.blue;
        }
        this.black = 1.0 - d / blackFactor;
    }

    public byte[] toPDF() {
        return new byte[0];
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (!(pDFObject instanceof PDFColor)) {
            return false;
        }
        PDFColor pDFColor = (PDFColor)pDFObject;
        return pDFColor.red == this.red && pDFColor.green == this.green && pDFColor.blue == this.blue;
    }
}

