/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFArray
extends PDFObject {
    protected List<Object> values = new ArrayList<Object>();

    public PDFArray(PDFObject pDFObject) {
        super(pDFObject);
    }

    public PDFArray() {
        this(null);
    }

    public PDFArray(PDFObject pDFObject, int[] nArray) {
        super(pDFObject);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.values.add(nArray[i]);
        }
    }

    public PDFArray(PDFObject pDFObject, double[] dArray) {
        super(pDFObject);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.values.add(new Double(dArray[i]));
        }
    }

    public PDFArray(PDFObject pDFObject, List<?> list) {
        super(pDFObject);
        this.values.addAll(list);
    }

    public PDFArray(Object ... objectArray) {
        this(null, objectArray);
    }

    public PDFArray(PDFObject pDFObject, Object[] objectArray) {
        super(pDFObject);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.values.add(objectArray[i]);
        }
    }

    public boolean contains(Object object) {
        return this.values.contains(object);
    }

    public int length() {
        return this.values.size();
    }

    public void set(int n, Object object) {
        this.values.set(n, object);
    }

    public void set(int n, double d) {
        this.values.set(n, new Double(d));
    }

    public Object get(int n) {
        return this.values.get(n);
    }

    public void add(Object object) {
        PDFObject pDFObject;
        if (object instanceof PDFObject && !(pDFObject = (PDFObject)object).hasObjectNumber()) {
            pDFObject.setParent(this);
        }
        this.values.add(object);
    }

    public void add(double d) {
        this.values.add(new Double(d));
    }

    public void clear() {
        this.values.clear();
    }

    @Override
    public int output(OutputStream outputStream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('[');
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            Object object = this.values.get(i);
            this.formatObject(object, (OutputStream)countingOutputStream, stringBuilder);
        }
        stringBuilder.append(']');
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }
}

