/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public class TableCellLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog(TableCellLayoutManager.class);
    private PrimaryGridUnit primaryGridUnit;
    private Block curBlockArea;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int totalHeight;
    private int usedBPD;
    private boolean emptyCell = true;

    public TableCellLayoutManager(TableCell tableCell, PrimaryGridUnit primaryGridUnit) {
        super(tableCell);
        this.primaryGridUnit = primaryGridUnit;
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public Table getTable() {
        return this.getTableCell().getTable();
    }

    protected int getIPIndents() {
        int[] nArray = this.primaryGridUnit.getStartEndBorderWidths();
        this.startIndent = nArray[0];
        this.endIndent = nArray[1];
        if (this.isSeparateBorderModel()) {
            int n = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue(this);
            this.startIndent += n / 2;
            this.endIndent += n / 2;
        } else {
            this.startIndent /= 2;
            this.endIndent /= 2;
        }
        this.startIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        this.endIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
        return this.startIndent + this.endIndent;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        List list;
        Object object;
        LayoutManager layoutManager;
        MinOptMax minOptMax = layoutContext.getStackLimitBP();
        this.cellIPD = this.referenceIPD = layoutContext.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<KnuthBox> linkedList2 = new LinkedList<KnuthBox>();
        LayoutManager layoutManager2 = null;
        while ((layoutManager = this.getChildLM()) != null) {
            object = new LayoutContext(0);
            ((LayoutContext)object).setStackLimitBP(layoutContext.getStackLimitBP().minus(minOptMax));
            ((LayoutContext)object).setRefIPD(this.cellIPD);
            list = layoutManager.getNextKnuthElements((LayoutContext)object, n);
            if (((LayoutContext)object).isKeepWithNextPending()) {
                log.debug((Object)"child LM signals pending keep with next");
            }
            if (linkedList.isEmpty() && ((LayoutContext)object).isKeepWithPreviousPending()) {
                this.primaryGridUnit.setKeepWithPrevious(((LayoutContext)object).getKeepWithPreviousPending());
                ((LayoutContext)object).clearKeepWithPreviousPending();
            }
            if (layoutManager2 != null && !ElementListUtils.endsWithForcedBreak(linkedList)) {
                this.addInBetweenBreak(linkedList, layoutContext, (LayoutContext)object);
            }
            linkedList.addAll(list);
            if (list.isEmpty()) continue;
            if (((LayoutContext)object).isKeepWithNextPending()) {
                layoutContext.updateKeepWithNextPending(((LayoutContext)object).getKeepWithNextPending());
                ((LayoutContext)object).clearKeepWithNextPending();
            }
            layoutManager2 = layoutManager;
        }
        this.primaryGridUnit.setKeepWithNext(layoutContext.getKeepWithNextPending());
        list = new LinkedList();
        if (!linkedList.isEmpty()) {
            this.wrapPositionElements(linkedList, linkedList2);
        } else {
            linkedList2.add(new KnuthBox(0, this.notifyPos(new Position(this)), true));
        }
        SpaceResolver.resolveElementList(linkedList2);
        if (((KnuthElement)linkedList2.get(0)).isForcedBreak()) {
            this.primaryGridUnit.setBreakBefore(((KnuthPenalty)linkedList2.get(0)).getBreakClass());
            linkedList2.remove(0);
            assert (!linkedList2.isEmpty());
        }
        if (((ListElement)(object = (KnuthElement)ListUtil.getLast(linkedList2))).isForcedBreak()) {
            KnuthPenalty knuthPenalty = (KnuthPenalty)object;
            this.primaryGridUnit.setBreakAfter(knuthPenalty.getBreakClass());
            knuthPenalty.setPenalty(0);
        }
        this.setFinished(true);
        return linkedList2;
    }

    public void setYOffset(int n) {
        this.yoffset = n;
    }

    public void setXOffset(int n) {
        this.xoffset = n;
    }

    public void setContentHeight(int n) {
        this.usedBPD = n;
    }

    public void setTotalHeight(int n) {
        this.totalHeight = n;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext, int[] nArray, int n, int n2, int n3, int n4, boolean bl, boolean bl2, RowPainter rowPainter, int n5) {
        int n6;
        this.getParentArea(null);
        this.addId();
        int n7 = this.primaryGridUnit.getBeforeBorderWidth(n, n3);
        int n8 = this.primaryGridUnit.getAfterBorderWidth(n2, n4);
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.primaryGridUnit.getCell().getCommonBorderPaddingBackground();
        int n9 = n6 = this.totalHeight - n7 - n8;
        n9 -= commonBorderPaddingBackground.getPaddingBefore(n3 == 2, this);
        n9 -= commonBorderPaddingBackground.getPaddingAfter(n4 == 2, this);
        this.addBackgroundAreas(rowPainter, n5, n7, n6);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                if (n7 > 0) {
                    int bl3 = this.getTableCell().getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
                    TableCellLayoutManager.adjustYOffset(this.curBlockArea, bl3);
                }
                TraitSetter.addBorders(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), n7 == 0, n8 == 0, false, false, this);
            }
        } else {
            boolean bl3;
            boolean block = this.primaryGridUnit.getColIndex() == 0;
            boolean bl4 = bl3 = this.primaryGridUnit.getColIndex() + this.getTableCell().getNumberColumnsSpanned() == this.getTable().getNumberOfColumns();
            if (!this.primaryGridUnit.hasSpanning()) {
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, -n7);
                boolean[] blArray = new boolean[]{bl, bl2, block, bl3};
                TraitSetter.addCollapsingBorders(this.curBlockArea, this.primaryGridUnit.getBorderBefore(n3), this.primaryGridUnit.getBorderAfter(n4), this.primaryGridUnit.getBorderStart(), this.primaryGridUnit.getBorderEnd(), blArray);
            } else {
                int n10;
                CommonBorderPaddingBackground.BorderInfo n13;
                Object object;
                int n11;
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, n7);
                Block[][] blockArray = new Block[this.getTableCell().getNumberRowsSpanned()][this.getTableCell().getNumberColumnsSpanned()];
                GridUnit[] gridUnitArray = (GridUnit[])this.primaryGridUnit.getRows().get(n);
                for (n11 = 0; n11 < this.getTableCell().getNumberColumnsSpanned(); ++n11) {
                    object = gridUnitArray[n11];
                    n13 = ((GridUnit)object).getBorderBefore(n3);
                    n10 = n13.getRetainedWidth() / 2;
                    if (n10 <= 0) continue;
                    this.addBorder(blockArray, n, n11, Trait.BORDER_BEFORE, n13, bl);
                    TableCellLayoutManager.adjustYOffset(blockArray[n][n11], -n10);
                    TableCellLayoutManager.adjustBPD(blockArray[n][n11], -n10);
                }
                gridUnitArray = (GridUnit[])this.primaryGridUnit.getRows().get(n2);
                for (n11 = 0; n11 < this.getTableCell().getNumberColumnsSpanned(); ++n11) {
                    object = gridUnitArray[n11];
                    n13 = ((GridUnit)object).getBorderAfter(n4);
                    n10 = n13.getRetainedWidth() / 2;
                    if (n10 <= 0) continue;
                    this.addBorder(blockArray, n2, n11, Trait.BORDER_AFTER, n13, bl2);
                    TableCellLayoutManager.adjustBPD(blockArray[n2][n11], -n10);
                }
                for (n11 = n; n11 <= n2; ++n11) {
                    gridUnitArray = (GridUnit[])this.primaryGridUnit.getRows().get(n11);
                    object = gridUnitArray[0].getBorderStart();
                    int n12 = ((CommonBorderPaddingBackground.BorderInfo)object).getRetainedWidth() / 2;
                    if (n12 > 0) {
                        this.addBorder(blockArray, n11, 0, Trait.BORDER_START, (CommonBorderPaddingBackground.BorderInfo)object, block);
                        TableCellLayoutManager.adjustXOffset(blockArray[n11][0], n12);
                        TableCellLayoutManager.adjustIPD(blockArray[n11][0], -n12);
                    }
                    if ((n12 = ((CommonBorderPaddingBackground.BorderInfo)(object = gridUnitArray[gridUnitArray.length - 1].getBorderEnd())).getRetainedWidth() / 2) <= 0) continue;
                    this.addBorder(blockArray, n11, gridUnitArray.length - 1, Trait.BORDER_END, (CommonBorderPaddingBackground.BorderInfo)object, bl3);
                    TableCellLayoutManager.adjustIPD(blockArray[n11][gridUnitArray.length - 1], -n12);
                }
                n11 = this.yoffset;
                for (int i = n; i <= n2; ++i) {
                    int n14 = nArray[i - n];
                    n10 = this.xoffset;
                    for (int j = 0; j < gridUnitArray.length; ++j) {
                        int n15 = this.getTable().getColumn(this.primaryGridUnit.getColIndex() + j).getColumnWidth().getValue(this.getParent());
                        if (blockArray[i][j] != null) {
                            Block block2 = blockArray[i][j];
                            TableCellLayoutManager.adjustYOffset(block2, n11);
                            TableCellLayoutManager.adjustXOffset(block2, n10);
                            TableCellLayoutManager.adjustIPD(block2, n15);
                            TableCellLayoutManager.adjustBPD(block2, n14);
                            this.parentLayoutManager.addChildArea(block2);
                        }
                        n10 += n15;
                    }
                    n11 += n14;
                }
            }
        }
        TraitSetter.addPadding(this.curBlockArea, commonBorderPaddingBackground, n3 == 2, n4 == 2, false, false, this);
        if (this.usedBPD < n9) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block block = new Block();
                block.setBPD((n9 - this.usedBPD) / 2);
                this.curBlockArea.addBlock(block);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block block = new Block();
                block.setBPD(n9 - this.usedBPD);
                this.curBlockArea.addBlock(block);
            }
        }
        AreaAdditionUtil.addAreas(this, positionIterator, layoutContext);
        this.curBlockArea.setBPD(n9);
        if (!this.isSeparateBorderModel() || !this.emptyCell || this.getTableCell().showEmptyCells()) {
            TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        this.flush();
        this.curBlockArea = null;
        this.notifyEndOfLayout();
    }

    private void addBackgroundAreas(RowPainter rowPainter, int n, int n2, int n3) {
        TableRow tableRow;
        Cloneable cloneable;
        TableColumn tableColumn = this.getTable().getColumn(this.primaryGridUnit.getColIndex());
        if (tableColumn.getCommonBorderPaddingBackground().hasBackground()) {
            cloneable = this.getBackgroundArea(n3, n2);
            ((TableLayoutManager)this.parentLayoutManager).registerColumnBackgroundArea(tableColumn, (Block)cloneable, -this.startIndent);
        }
        if (((TablePart)(cloneable = this.primaryGridUnit.getTablePart())).getCommonBorderPaddingBackground().hasBackground()) {
            rowPainter.registerPartBackgroundArea(this.getBackgroundArea(n3, n2));
        }
        if ((tableRow = this.primaryGridUnit.getRow()) != null && tableRow.getCommonBorderPaddingBackground().hasBackground()) {
            Block block = this.getBackgroundArea(n3, n2);
            ((TableLayoutManager)this.parentLayoutManager).addBackgroundArea(block);
            TraitSetter.addBackground(block, tableRow.getCommonBorderPaddingBackground(), this.parentLayoutManager, -this.xoffset - this.startIndent, -n2, this.parentLayoutManager.getContentAreaIPD(), n);
        }
    }

    private void addBorder(Block[][] blockArray, int n, int n2, Integer n3, CommonBorderPaddingBackground.BorderInfo borderInfo, boolean bl) {
        if (blockArray[n][n2] == null) {
            blockArray[n][n2] = new Block();
            blockArray[n][n2].addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            blockArray[n][n2].setPositioning(2);
        }
        blockArray[n][n2].addTrait(n3, new BorderProps(borderInfo.getStyle(), borderInfo.getRetainedWidth(), borderInfo.getColor(), bl ? 2 : 1));
    }

    private static void adjustXOffset(Block block, int n) {
        block.setXOffset(block.getXOffset() + n);
    }

    private static void adjustYOffset(Block block, int n) {
        block.setYOffset(block.getYOffset() + n);
    }

    private static void adjustIPD(Block block, int n) {
        block.setIPD(block.getIPD() + n);
    }

    private static void adjustBPD(Block block, int n) {
        block.setBPD(block.getBPD() + n);
    }

    private Block getBackgroundArea(int n, int n2) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getTableCell().getCommonBorderPaddingBackground();
        int n3 = commonBorderPaddingBackground.getPaddingStart(false, this);
        int n4 = commonBorderPaddingBackground.getPaddingEnd(false, this);
        Block block = new Block();
        TraitSetter.setProducerID(block, this.getTable().getId());
        block.setPositioning(2);
        block.setIPD(this.cellIPD + n3 + n4);
        block.setBPD(n);
        block.setXOffset(this.xoffset + this.startIndent - n3);
        block.setYOffset(this.yoffset + n2);
        return block;
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            this.curBlockArea.setXOffset(this.xoffset + this.startIndent);
            this.curBlockArea.setYOffset(this.yoffset);
            this.curBlockArea.setIPD(this.cellIPD);
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
    }

    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }
}

