/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.fo.FOText;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ListUtil;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private static final int SOFT_HYPHEN_PENALTY = 1;
    private static final Log LOG = LogFactory.getLog(TextLayoutManager.class);
    private final List areaInfos;
    private static final String BREAK_CHARS = "-/";
    private final FOText foText;
    private final MinOptMax[] letterSpaceAdjustArray;
    private Font spaceFont = null;
    private int nextStart = 0;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private boolean hasChanged = false;
    private int[] returnedIndices = new int[]{0, 0};
    private int changeOffset = 0;
    private int thisStart = 0;
    private int tempStart = 0;
    private List changeList = new LinkedList();
    private AlignmentContext alignmentContext = null;
    private int lineStartBAP = 0;
    private int lineEndBAP = 0;
    private boolean keepTogether;
    private final Position auxiliaryPosition = new LeafPosition(this, -1);

    public TextLayoutManager(FOText fOText) {
        this.foText = fOText;
        this.letterSpaceAdjustArray = new MinOptMax[fOText.length() + 1];
        this.areaInfos = new ArrayList();
    }

    private KnuthPenalty makeZeroWidthPenalty(int n) {
        return new KnuthPenalty(0, n, false, this.auxiliaryPosition, true);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true);
    }

    public void initialize() {
        this.foText.resetBuffer();
        this.spaceFont = FontSelector.selectFontForCharacterInText(' ', this.foText, this);
        this.spaceCharIPD = this.spaceFont.getCharWidth(' ');
        this.hyphIPD = this.foText.getCommonHyphenation().getHyphIPD(this.spaceFont);
        SpaceVal spaceVal = SpaceVal.makeLetterSpacing(this.foText.getLetterSpacing());
        SpaceVal spaceVal2 = SpaceVal.makeWordSpacing(this.foText.getWordSpacing(), spaceVal, this.spaceFont);
        this.letterSpaceIPD = spaceVal.getSpace();
        this.wordSpaceIPD = MinOptMax.getInstance(this.spaceCharIPD).plus(spaceVal2.getSpace());
        this.keepTogether = this.foText.getKeepTogether().getWithinLine().getEnum() == 7;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        MinOptMax minOptMax = MinOptMax.ZERO;
        AreaInfo areaInfo = null;
        while (positionIterator.hasNext()) {
            LeafPosition leafPosition = (LeafPosition)positionIterator.next();
            if (leafPosition == null || leafPosition.getLeafPos() == -1) continue;
            AreaInfo areaInfo2 = (AreaInfo)this.areaInfos.get(leafPosition.getLeafPos());
            if (areaInfo == null || areaInfo2.font != areaInfo.font || areaInfo2.level != areaInfo.level) {
                if (areaInfo != null) {
                    this.addAreaInfoAreas(areaInfo, n, n2, n3, n4, minOptMax, layoutContext);
                }
                n3 = leafPosition.getLeafPos();
                n = 0;
                n2 = 0;
                minOptMax = MinOptMax.ZERO;
            }
            n += areaInfo2.wordSpaceCount;
            n2 += areaInfo2.letterSpaceCount;
            minOptMax = minOptMax.plus(areaInfo2.areaIPD);
            n4 = leafPosition.getLeafPos();
            areaInfo = areaInfo2;
        }
        if (areaInfo != null) {
            this.addAreaInfoAreas(areaInfo, n, n2, n3, n4, minOptMax, layoutContext);
        }
    }

    private void addAreaInfoAreas(AreaInfo areaInfo, int n, int n2, int n3, int n4, MinOptMax minOptMax, LayoutContext layoutContext) {
        double d;
        int n5 = areaInfo.getWordLength();
        if (areaInfo.letterSpaceCount == n5 && !areaInfo.isHyphenated && layoutContext.isLastArea()) {
            minOptMax = minOptMax.minus(this.letterSpaceIPD);
            --n2;
        }
        for (int i = areaInfo.startIndex; i < areaInfo.breakIndex; ++i) {
            MinOptMax minOptMax2 = this.letterSpaceAdjustArray[i + 1];
            if (minOptMax2 == null || !minOptMax2.isElastic()) continue;
            ++n2;
        }
        if (layoutContext.isLastArea() && areaInfo.isHyphenated) {
            minOptMax = minOptMax.plus(this.hyphIPD);
        }
        int n6 = (d = layoutContext.getIPDAdjust()) > 0.0 ? (int)((double)minOptMax.getStretch() * d) : (int)((double)minOptMax.getShrink() * d);
        int n7 = this.letterSpaceIPD.getOpt();
        n7 = d > 0.0 ? (n7 += (int)((double)this.letterSpaceIPD.getStretch() * d)) : (n7 += (int)((double)this.letterSpaceIPD.getShrink() * d));
        int n8 = (n7 - this.letterSpaceIPD.getOpt()) * n2;
        int n9 = this.wordSpaceIPD.getOpt();
        if (n > 0) {
            n9 += (n6 - n8) / n;
        }
        if ((n8 += (n9 - this.wordSpaceIPD.getOpt()) * n) != n6) {
            LOG.trace((Object)("TextLM.addAreas: error in word / letter space adjustment = " + (n8 - n6)));
            n8 = n6;
        }
        TextArea textArea = new TextAreaBuilder(minOptMax, n8, layoutContext, n3, n4, layoutContext.isLastArea(), areaInfo.font).build();
        textArea.setTextLetterSpaceAdjust(n7);
        textArea.setTextWordSpaceAdjust(n9 - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        if (layoutContext.getIPDAdjust() != 0.0) {
            textArea.setSpaceDifference(this.wordSpaceIPD.getOpt() - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        }
        this.parentLayoutManager.addChildArea(textArea);
    }

    private void addAreaInfo(AreaInfo areaInfo) {
        this.addAreaInfo(this.areaInfos.size(), areaInfo);
    }

    private void addAreaInfo(int n, AreaInfo areaInfo) {
        this.areaInfos.add(n, areaInfo);
    }

    private void removeAreaInfo(int n) {
        this.areaInfos.remove(n);
    }

    private AreaInfo getAreaInfo(int n) {
        return (AreaInfo)this.areaInfos.get(n);
    }

    private void addToLetterAdjust(int n, int n2) {
        this.letterSpaceAdjustArray[n] = this.letterSpaceAdjustArray[n] == null ? MinOptMax.getInstance(n2) : this.letterSpaceAdjustArray[n].plus(n2);
    }

    private static boolean isSpace(char c) {
        return c == ' ' || CharUtilities.isNonBreakableSpace(c) || CharUtilities.isFixedWidthSpace(c);
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        this.lineStartBAP = layoutContext.getLineStartBorderAndPaddingWidth();
        this.lineEndBAP = layoutContext.getLineEndBorderAndPaddingWidth();
        this.alignmentContext = layoutContext.getAlignmentContext();
        LinkedList<InlineKnuthSequence> linkedList = new LinkedList<InlineKnuthSequence>();
        KnuthSequence knuthSequence = new InlineKnuthSequence();
        AreaInfo areaInfo = null;
        AreaInfo areaInfo2 = null;
        linkedList.add((InlineKnuthSequence)knuthSequence);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GK: [" + this.nextStart + "," + this.foText.length() + "]"));
        }
        LineBreakStatus lineBreakStatus = new LineBreakStatus();
        this.thisStart = this.nextStart;
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        int n2 = -1;
        int n3 = -1;
        while (this.nextStart < this.foText.length()) {
            c = this.foText.charAt(this.nextStart);
            n2 = this.foText.bidiLevelAt(this.nextStart);
            boolean bl3 = false;
            int n4 = this.keepTogether ? 4 : (int)lineBreakStatus.nextChar(c);
            switch (n4) {
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    bl3 = true;
                    break;
                }
                default: {
                    LOG.error((Object)("Unexpected breakAction: " + n4));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GK: { index = " + this.nextStart + ", char = " + CharUtilities.charToNCRef(c) + ", level = " + n2 + ", levelPrev = " + n3 + ", inWord = " + bl + ", inSpace = " + bl2 + "}"));
            }
            if (bl) {
                if (bl3 || TextLayoutManager.isSpace(c) || CharUtilities.isExplicitBreak(c) || n3 != -1 && n2 != n3) {
                    areaInfo2 = this.processWord(n, knuthSequence, areaInfo2, c, bl3, true, n3);
                }
            } else if (bl2) {
                if (c != ' ' || bl3) {
                    areaInfo2 = this.processWhitespace(n, knuthSequence, bl3, n3);
                }
            } else {
                if (areaInfo != null) {
                    areaInfo2 = areaInfo;
                    this.processLeftoverAreaInfo(n, knuthSequence, areaInfo, c == ' ' || bl3);
                    areaInfo = null;
                }
                if (n4 == 5) {
                    knuthSequence = this.processLinebreak(linkedList, knuthSequence);
                }
            }
            if (c == ' ' && this.foText.getWhitespaceTreatment() == 108 || c == '\u00a0') {
                areaInfo = new AreaInfo(this.nextStart, this.nextStart + 1, 1, 0, this.wordSpaceIPD, false, true, bl3, this.spaceFont, n2, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isFixedWidthSpace(c) || CharUtilities.isZeroWidthSpace(c)) {
                Font font = FontSelector.selectFontForCharacterInText(c, this.foText, this);
                MinOptMax minOptMax = MinOptMax.getInstance(font.getCharWidth(c));
                areaInfo = new AreaInfo(this.nextStart, this.nextStart + 1, 0, 0, minOptMax, false, true, bl3, font, n2, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isExplicitBreak(c)) {
                this.thisStart = this.nextStart + 1;
            }
            bl = !TextLayoutManager.isSpace(c) && !CharUtilities.isExplicitBreak(c);
            bl2 = c == ' ' && this.foText.getWhitespaceTreatment() != 108;
            n3 = n2;
            ++this.nextStart;
        }
        if (bl) {
            this.processWord(n, knuthSequence, areaInfo2, c, false, false, n3);
        } else if (bl2) {
            this.processWhitespace(n, knuthSequence, !this.keepTogether, n3);
        } else if (areaInfo != null) {
            this.processLeftoverAreaInfo(n, knuthSequence, areaInfo, c == '\u200b');
        } else if (CharUtilities.isExplicitBreak(c)) {
            this.processLinebreak(linkedList, knuthSequence);
        }
        if (((List)ListUtil.getLast(linkedList)).isEmpty()) {
            ListUtil.removeLast(linkedList);
        }
        this.setFinished(true);
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList;
    }

    private KnuthSequence processLinebreak(List list, KnuthSequence knuthSequence) {
        if (this.lineEndBAP != 0) {
            knuthSequence.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, true));
        }
        knuthSequence.endSequence();
        knuthSequence = new InlineKnuthSequence();
        list.add(knuthSequence);
        return knuthSequence;
    }

    private void processLeftoverAreaInfo(int n, KnuthSequence knuthSequence, AreaInfo areaInfo, boolean bl) {
        this.addAreaInfo(areaInfo);
        areaInfo.breakOppAfter = bl;
        this.addElementsForASpace(knuthSequence, n, areaInfo, this.areaInfos.size() - 1);
    }

    private AreaInfo processWhitespace(int n, KnuthSequence knuthSequence, boolean bl, int n2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PS: [" + this.thisStart + "," + this.nextStart + "]"));
        }
        assert (this.nextStart >= this.thisStart);
        AreaInfo areaInfo = new AreaInfo(this.thisStart, this.nextStart, this.nextStart - this.thisStart, 0, this.wordSpaceIPD.mult(this.nextStart - this.thisStart), false, true, bl, this.spaceFont, n2, null);
        this.addAreaInfo(areaInfo);
        this.addElementsForASpace(knuthSequence, n, areaInfo, this.areaInfos.size() - 1);
        this.thisStart = this.nextStart;
        return areaInfo;
    }

    private AreaInfo processWordMapping(int n, Font font, AreaInfo areaInfo, char c, boolean bl, int n2) {
        int n3 = this.thisStart;
        int n4 = n;
        int n5 = 0;
        String string = this.foText.getScript();
        String string2 = this.foText.getLanguage();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PW: [" + this.thisStart + "," + n + "]: {" + " +M" + ", level = " + n2 + " }"));
        }
        CharSequence charSequence = this.foText.subSequence(n3, n4);
        if (string == null || "auto".equals(string)) {
            string = CharScript.scriptTagFromCode(CharScript.dominantScript(charSequence));
        }
        if (string2 == null || "none".equals(string2)) {
            string2 = "dflt";
        }
        CharSequence charSequence2 = font.performSubstitution(charSequence, string, string2);
        int[][] nArray = font.performsPositioning() ? font.performPositioning(charSequence2, string, string2) : (font.hasKerning() ? this.getKerningAdjustments(charSequence2, font) : (int[][])null);
        if (!CharUtilities.isSameSequence(charSequence2 = font.reorderCombiningMarks(charSequence2, nArray, string, string2), charSequence)) {
            this.foText.addMapping(n3, n4, charSequence2);
        }
        MinOptMax minOptMax = MinOptMax.ZERO;
        int n6 = charSequence2.length();
        for (int i = 0; i < n6; ++i) {
            char c2 = charSequence2.charAt(i);
            int n7 = font.getCharWidth((int)c2);
            if (n7 < 0) {
                n7 = 0;
            }
            if (nArray != null) {
                n7 += nArray[i][2];
            }
            minOptMax = minOptMax.plus(n7);
        }
        return new AreaInfo(n3, n4, 0, n5, minOptMax, bl, false, c != '\u0000', font, n2, nArray);
    }

    private int[][] getKerningAdjustments(CharSequence charSequence, Font font) {
        int n;
        int n2;
        int n3 = charSequence.length();
        int[] nArray = new int[n3];
        int n4 = n3;
        int n5 = -1;
        for (n2 = 0; n2 < n4; ++n2) {
            n = charSequence.charAt(n2);
            if (n5 >= 0) {
                nArray[n2] = font.getKernValue(n5, n);
            }
            n5 = n;
        }
        n2 = 0;
        n5 = n3;
        for (n4 = 0; n4 < n5; ++n4) {
            if (nArray[n4] == 0) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            int[][] nArray2 = new int[n3][4];
            n = n3;
            for (n5 = 0; n5 < n; ++n5) {
                if (n5 <= 0) continue;
                nArray2[n5 - 1][2] = nArray[n5];
            }
            return nArray2;
        }
        return null;
    }

    private AreaInfo processWordNoMapping(int n, Font font, AreaInfo areaInfo, char c, boolean bl, int n2) {
        char c2;
        int n3;
        boolean bl2 = font.hasKerning();
        MinOptMax minOptMax = MinOptMax.ZERO;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PW: [" + this.thisStart + "," + n + "]: {" + " -M" + ", level = " + n2 + " }"));
        }
        for (n3 = this.thisStart; n3 < n; ++n3) {
            char c3;
            c2 = this.foText.charAt(n3);
            int n4 = font.getCharWidth(c2);
            minOptMax = minOptMax.plus(n4);
            if (!bl2) continue;
            int n5 = 0;
            if (n3 > this.thisStart) {
                c3 = this.foText.charAt(n3 - 1);
                n5 = font.getKernValue(c3, c2);
            } else if (areaInfo != null && !areaInfo.isSpace && areaInfo.breakIndex > 0) {
                c3 = this.foText.charAt(areaInfo.breakIndex - 1);
                n5 = font.getKernValue(c3, c2);
            }
            if (n5 == 0) continue;
            this.addToLetterAdjust(n3, n5);
            minOptMax = minOptMax.plus(n5);
        }
        if (bl2 && c != '\u0000' && !TextLayoutManager.isSpace(c) && n > 0 && bl && (n3 = font.getKernValue(this.foText.charAt(n - 1), c)) != 0) {
            this.addToLetterAdjust(n, n3);
        }
        n3 = n - this.thisStart;
        c2 = '\u0000';
        if (n3 != 0) {
            c2 = n3 - 1;
            if (c != '\u0000' && !TextLayoutManager.isSpace(c)) {
                ++c2;
            }
        }
        assert (c2 >= '\u0000');
        minOptMax = minOptMax.plus(this.letterSpaceIPD.mult(c2));
        return new AreaInfo(this.thisStart, n, 0, c2, minOptMax, bl, false, c != '\u0000', font, n2, null);
    }

    private AreaInfo processWord(int n, KnuthSequence knuthSequence, AreaInfo areaInfo, char c, boolean bl, boolean bl2, int n2) {
        int n3;
        for (n3 = this.nextStart; n3 > 0 && this.foText.charAt(n3 - 1) == '\u00ad'; --n3) {
        }
        boolean bl3 = bl2 && this.foText.charAt(n3) == '\u00ad';
        Font font = FontSelector.selectFontForCharactersInText(this.foText, this.thisStart, n3, this.foText, this);
        AreaInfo areaInfo2 = font.performsSubstitution() || font.performsPositioning() ? this.processWordMapping(n3, font, areaInfo, bl ? c : (char)'\u0000', bl3, n2) : this.processWordNoMapping(n3, font, areaInfo, bl ? c : (char)'\u0000', bl3, n2);
        areaInfo = areaInfo2;
        this.addAreaInfo(areaInfo2);
        this.tempStart = this.nextStart;
        this.addElementsForAWordFragment(knuthSequence, n, areaInfo2, this.areaInfos.size() - 1);
        this.thisStart = this.nextStart;
        return areaInfo;
    }

    public List addALetterSpaceTo(List list) {
        return this.addALetterSpaceTo(list, 0);
    }

    public List addALetterSpaceTo(List list, int n) {
        ListIterator<KnuthElement> listIterator = list.listIterator();
        KnuthElement knuthElement = (KnuthElement)listIterator.next();
        Position position = knuthElement.getPosition();
        LeafPosition leafPosition = (LeafPosition)position.getPosition(n);
        int n2 = leafPosition.getLeafPos();
        if (n2 > -1) {
            AreaInfo areaInfo = this.getAreaInfo(n2);
            areaInfo.letterSpaceCount++;
            areaInfo.addToAreaIPD(this.letterSpaceIPD);
            if (BREAK_CHARS.indexOf(this.foText.charAt(this.tempStart - 1)) >= 0) {
                listIterator = list.listIterator(list.size());
                listIterator.add(new KnuthPenalty(0, 50, true, this.auxiliaryPosition, false));
                listIterator.add(new KnuthGlue(this.letterSpaceIPD, this.auxiliaryPosition, false));
            } else if (this.letterSpaceIPD.isStiff()) {
                listIterator.set(new KnuthInlineBox(areaInfo.areaIPD.getOpt(), this.alignmentContext, position, false));
            } else {
                listIterator.next();
                listIterator.next();
                listIterator.set(new KnuthGlue(this.letterSpaceIPD.mult(areaInfo.letterSpaceCount), this.auxiliaryPosition, true));
            }
        }
        return list;
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        AreaInfo areaInfo = this.getAreaInfo(((LeafPosition)position).getLeafPos() + this.changeOffset);
        int n = areaInfo.startIndex;
        boolean bl = true;
        Font font = areaInfo.font;
        while (n < areaInfo.breakIndex) {
            int n2;
            int n3;
            boolean bl2;
            MinOptMax minOptMax = MinOptMax.ZERO;
            int n4 = n + hyphContext.getNextHyphPoint();
            if (hyphContext.hasMoreHyphPoints() && n4 <= areaInfo.breakIndex) {
                bl2 = true;
            } else {
                bl2 = false;
                n4 = areaInfo.breakIndex;
            }
            hyphContext.updateOffset(n4 - n);
            for (n3 = n; n3 < n4; ++n3) {
                n2 = this.foText.charAt(n3);
                minOptMax = minOptMax.plus(font.getCharWidth((char)n2));
                if (n3 >= n4) continue;
                MinOptMax minOptMax2 = this.letterSpaceAdjustArray[n3 + 1];
                if (n3 == n4 - 1 && bl2) {
                    minOptMax2 = null;
                }
                if (minOptMax2 == null) continue;
                minOptMax = minOptMax.plus(minOptMax2);
            }
            n3 = n4 == areaInfo.breakIndex && areaInfo.letterSpaceCount < areaInfo.getWordLength() ? 1 : 0;
            int n5 = n2 = n3 != 0 ? n4 - n - 1 : n4 - n;
            assert (n2 >= 0);
            minOptMax = minOptMax.plus(this.letterSpaceIPD.mult(n2));
            if (!bl || n4 != areaInfo.breakIndex || bl2) {
                this.changeList.add(new PendingChange(new AreaInfo(n, n4, 0, n2, minOptMax, bl2, false, false, font, -1, null), ((LeafPosition)position).getLeafPos() + this.changeOffset));
                bl = false;
            }
            n = n4;
        }
        this.hasChanged |= !bl;
    }

    public boolean applyChanges(List list) {
        return this.applyChanges(list, 0);
    }

    public boolean applyChanges(List list, int n) {
        Position position;
        this.setFinished(false);
        if (list.isEmpty()) {
            return false;
        }
        LeafPosition leafPosition = null;
        LeafPosition leafPosition2 = null;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext() && ((leafPosition = (LeafPosition)(position = ((KnuthElement)listIterator.next()).getPosition()).getPosition(n)) == null || leafPosition.getLeafPos() == -1)) {
        }
        listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious() && ((leafPosition2 = (LeafPosition)(position = ((KnuthElement)listIterator.previous()).getPosition()).getPosition(n)) == null || leafPosition2.getLeafPos() == -1)) {
        }
        this.returnedIndices[0] = (leafPosition != null ? leafPosition.getLeafPos() : -1) + this.changeOffset;
        this.returnedIndices[1] = (leafPosition2 != null ? leafPosition2.getLeafPos() : -1) + this.changeOffset;
        int n2 = 0;
        int n3 = 0;
        if (!this.changeList.isEmpty()) {
            int n4 = -1;
            ListIterator listIterator2 = this.changeList.listIterator();
            while (listIterator2.hasNext()) {
                int n5;
                PendingChange pendingChange = (PendingChange)listIterator2.next();
                if (pendingChange.index == n4) {
                    n5 = pendingChange.index + ++n2 - n3;
                } else {
                    n4 = pendingChange.index;
                    n5 = pendingChange.index + ++n2 - ++n3;
                    this.removeAreaInfo(n5);
                }
                this.addAreaInfo(n5, pendingChange.areaInfo);
            }
            this.changeList.clear();
        }
        this.returnedIndices[1] = this.returnedIndices[1] + (n2 - n3);
        this.changeOffset += n2 - n3;
        return this.hasChanged;
    }

    public List getChangedKnuthElements(List list, int n) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        while (this.returnedIndices[0] <= this.returnedIndices[1]) {
            AreaInfo areaInfo = this.getAreaInfo(this.returnedIndices[0]);
            if (areaInfo.wordSpaceCount == 0) {
                this.addElementsForAWordFragment(linkedList, n, areaInfo, this.returnedIndices[0]);
            } else {
                this.addElementsForASpace(linkedList, n, areaInfo, this.returnedIndices[0]);
            }
            this.returnedIndices[0] = this.returnedIndices[0] + 1;
        }
        this.setFinished(this.returnedIndices[0] == this.areaInfos.size() - 1);
        return linkedList;
    }

    public String getWordChars(Position position) {
        int n = ((LeafPosition)position).getLeafPos() + this.changeOffset;
        if (n != -1) {
            AreaInfo areaInfo = this.getAreaInfo(n);
            StringBuffer stringBuffer = new StringBuffer(areaInfo.getWordLength());
            for (int i = areaInfo.startIndex; i < areaInfo.breakIndex; ++i) {
                stringBuffer.append(this.foText.charAt(i));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private void addElementsForASpace(List list, int n, AreaInfo areaInfo, int n2) {
        LeafPosition leafPosition = new LeafPosition(this, n2);
        if (!areaInfo.breakOppAfter) {
            if (n == 70) {
                list.add(this.makeAuxiliaryZeroWidthBox());
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(areaInfo.areaIPD, (Position)leafPosition, false));
            } else {
                list.add(new KnuthInlineBox(areaInfo.areaIPD.getOpt(), null, leafPosition, true));
            }
        } else if (this.foText.charAt(areaInfo.startIndex) != ' ' || this.foText.getWhitespaceTreatment() == 108) {
            list.addAll(this.getElementsForBreakingSpace(n, areaInfo, this.auxiliaryPosition, 0, leafPosition, areaInfo.areaIPD.getOpt(), true));
        } else {
            list.addAll(this.getElementsForBreakingSpace(n, areaInfo, leafPosition, areaInfo.areaIPD.getOpt(), this.auxiliaryPosition, 0, false));
        }
    }

    private List getElementsForBreakingSpace(int n, AreaInfo areaInfo, Position position, int n2, Position position2, int n3, boolean bl) {
        ArrayList<KnuthElement> arrayList = new ArrayList<KnuthElement>();
        switch (n) {
            case 23: {
                arrayList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                arrayList.add(this.makeZeroWidthPenalty(0));
                arrayList.add(new KnuthGlue(n2 - (this.lineStartBAP + this.lineEndBAP), -20016, 0, position, false));
                arrayList.add(this.makeAuxiliaryZeroWidthBox());
                arrayList.add(this.makeZeroWidthPenalty(1000));
                arrayList.add(new KnuthGlue(this.lineStartBAP + n3, 10008, 0, position2, false));
                break;
            }
            case 39: 
            case 135: {
                if (bl || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    KnuthGlue knuthGlue = new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false);
                    arrayList.add(knuthGlue);
                    arrayList.add(this.makeZeroWidthPenalty(0));
                    knuthGlue = new KnuthGlue(n2 - (this.lineStartBAP + this.lineEndBAP), -10008, 0, position, false);
                    arrayList.add(knuthGlue);
                    arrayList.add(this.makeAuxiliaryZeroWidthBox());
                    arrayList.add(this.makeZeroWidthPenalty(1000));
                    knuthGlue = new KnuthGlue(this.lineStartBAP + n3, 0, 0, position2, false);
                    arrayList.add(knuthGlue);
                    break;
                }
                KnuthGlue knuthGlue = new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false);
                arrayList.add(knuthGlue);
                arrayList.add(this.makeZeroWidthPenalty(0));
                knuthGlue = new KnuthGlue(areaInfo.areaIPD.getOpt(), -10008, 0, position, false);
                arrayList.add(knuthGlue);
                break;
            }
            case 70: {
                arrayList.addAll(this.getElementsForJustifiedText(areaInfo, position, n2, position2, n3, bl, areaInfo.areaIPD.getShrink()));
                break;
            }
            default: {
                arrayList.addAll(this.getElementsForJustifiedText(areaInfo, position, n2, position2, n3, bl, 0));
            }
        }
        return arrayList;
    }

    private List getElementsForJustifiedText(AreaInfo areaInfo, Position position, int n, Position position2, int n2, boolean bl, int n3) {
        int n4 = areaInfo.areaIPD.getStretch();
        ArrayList<KnuthElement> arrayList = new ArrayList<KnuthElement>();
        if (bl || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
            arrayList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
            arrayList.add(this.makeZeroWidthPenalty(0));
            arrayList.add(new KnuthGlue(n - (this.lineStartBAP + this.lineEndBAP), n4, n3, position, false));
            arrayList.add(this.makeAuxiliaryZeroWidthBox());
            arrayList.add(this.makeZeroWidthPenalty(1000));
            arrayList.add(new KnuthGlue(this.lineStartBAP + n2, 0, 0, position2, false));
        } else {
            arrayList.add(new KnuthGlue(areaInfo.areaIPD.getOpt(), n4, n3, position, false));
        }
        return arrayList;
    }

    private void addElementsForAWordFragment(List list, int n, AreaInfo areaInfo, int n2) {
        boolean bl;
        LeafPosition leafPosition = new LeafPosition(this, n2);
        boolean bl2 = bl = areaInfo.breakOppAfter && !areaInfo.isHyphenated;
        if (this.letterSpaceIPD.isStiff()) {
            list.add(new KnuthInlineBox(bl ? areaInfo.areaIPD.getOpt() - this.letterSpaceIPD.getOpt() : areaInfo.areaIPD.getOpt(), this.alignmentContext, this.notifyPos(leafPosition), false));
        } else {
            int n3 = bl ? areaInfo.letterSpaceCount - 1 : areaInfo.letterSpaceCount;
            list.add(new KnuthInlineBox(areaInfo.areaIPD.getOpt() - areaInfo.letterSpaceCount * this.letterSpaceIPD.getOpt(), this.alignmentContext, this.notifyPos(leafPosition), false));
            list.add(this.makeZeroWidthPenalty(1000));
            list.add(new KnuthGlue(this.letterSpaceIPD.mult(n3), this.auxiliaryPosition, true));
            list.add(this.makeAuxiliaryZeroWidthBox());
        }
        if (areaInfo.isHyphenated) {
            MinOptMax minOptMax = null;
            if (areaInfo.breakIndex < this.foText.length()) {
                minOptMax = this.letterSpaceAdjustArray[areaInfo.breakIndex];
            }
            this.addElementsForAHyphen(list, n, this.hyphIPD, minOptMax, areaInfo.breakOppAfter && areaInfo.isHyphenated);
        } else if (bl) {
            this.addElementsForAHyphen(list, n, 0, this.letterSpaceIPD, true);
        }
    }

    private void addElementsForAHyphen(List list, int n, int n2, MinOptMax minOptMax, boolean bl) {
        if (minOptMax == null) {
            minOptMax = MinOptMax.ZERO;
        }
        switch (n) {
            case 23: {
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, true));
                list.add(new KnuthPenalty(this.hyphIPD, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                list.add(new KnuthGlue(-(this.lineEndBAP + this.lineStartBAP), -20016, 0, this.auxiliaryPosition, false));
                list.add(this.makeAuxiliaryZeroWidthBox());
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(this.lineStartBAP, 10008, 0, this.auxiliaryPosition, true));
                break;
            }
            case 39: 
            case 135: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                    list.add(new KnuthPenalty(n2, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                    list.add(new KnuthGlue(minOptMax.getOpt() - (this.lineStartBAP + this.lineEndBAP), -10008, 0, this.auxiliaryPosition, false));
                    list.add(this.makeAuxiliaryZeroWidthBox());
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                list.add(this.makeZeroWidthPenalty(1000));
                list.add(new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false));
                list.add(new KnuthPenalty(n2, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                list.add(new KnuthGlue(minOptMax.getOpt(), -10008, 0, this.auxiliaryPosition, false));
                break;
            }
            default: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    list.add(new KnuthPenalty(n2, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                    if (minOptMax.isNonZero()) {
                        list.add(new KnuthGlue(minOptMax.getOpt() - (this.lineStartBAP + this.lineEndBAP), minOptMax.getStretch(), minOptMax.getShrink(), this.auxiliaryPosition, false));
                    } else {
                        list.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), 0, 0, this.auxiliaryPosition, false));
                    }
                    list.add(this.makeAuxiliaryZeroWidthBox());
                    list.add(this.makeZeroWidthPenalty(1000));
                    list.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                list.add(new KnuthPenalty(n2, bl ? 1 : 50, !bl, this.auxiliaryPosition, false));
                if (!minOptMax.isNonZero()) break;
                list.add(new KnuthGlue(minOptMax, this.auxiliaryPosition, false));
            }
        }
    }

    public String toString() {
        return super.toString() + "{" + "chars = '" + CharUtilities.toNCRefs(this.foText.getCharSequence().toString()) + "'" + ", len = " + this.foText.length() + "}";
    }

    private final class TextAreaBuilder {
        private final MinOptMax width;
        private final int adjust;
        private final LayoutContext context;
        private final int firstIndex;
        private final int lastIndex;
        private final boolean isLastArea;
        private final Font font;
        private TextArea textArea;
        private int blockProgressionDimension;
        private AreaInfo areaInfo;
        private StringBuffer wordChars;
        private int[] letterSpaceAdjust;
        private int letterSpaceAdjustIndex;
        private int[] wordLevels;
        private int wordLevelsIndex;
        private int wordIPD;
        private int[][] gposAdjustments;
        private int gposAdjustmentsIndex;

        private TextAreaBuilder(MinOptMax minOptMax, int n, LayoutContext layoutContext, int n2, int n3, boolean bl, Font font) {
            this.width = minOptMax;
            this.adjust = n;
            this.context = layoutContext;
            this.firstIndex = n2;
            this.lastIndex = n3;
            this.isLastArea = bl;
            this.font = font;
        }

        private TextArea build() {
            this.createTextArea();
            this.setInlineProgressionDimension();
            this.calcBlockProgressionDimension();
            this.setBlockProgressionDimension();
            this.setBaselineOffset();
            this.setBlockProgressionOffset();
            this.setText();
            TraitSetter.addFontTraits(this.textArea, this.font);
            this.textArea.addTrait(Trait.COLOR, TextLayoutManager.this.foText.getColor());
            TraitSetter.addTextDecoration(this.textArea, TextLayoutManager.this.foText.getTextDecoration());
            TraitSetter.addStructureTreeElement(this.textArea, TextLayoutManager.this.foText.getStructureTreeElement());
            return this.textArea;
        }

        private void createTextArea() {
            this.textArea = this.context.getIPDAdjust() == 0.0 ? new TextArea() : new TextArea(this.width.getStretch(), this.width.getShrink(), this.adjust);
        }

        private void setInlineProgressionDimension() {
            this.textArea.setIPD(this.width.getOpt() + this.adjust);
        }

        private void calcBlockProgressionDimension() {
            this.blockProgressionDimension = this.font.getAscender() - this.font.getDescender();
        }

        private void setBlockProgressionDimension() {
            this.textArea.setBPD(this.blockProgressionDimension);
        }

        private void setBaselineOffset() {
            this.textArea.setBaselineOffset(this.font.getAscender());
        }

        private void setBlockProgressionOffset() {
            if (this.blockProgressionDimension == TextLayoutManager.this.alignmentContext.getHeight()) {
                this.textArea.setBlockProgressionOffset(0);
            } else {
                this.textArea.setBlockProgressionOffset(TextLayoutManager.this.alignmentContext.getOffset());
            }
        }

        private void setText() {
            int n = -1;
            int n2 = 0;
            for (int i = this.firstIndex; i <= this.lastIndex; ++i) {
                this.areaInfo = TextLayoutManager.this.getAreaInfo(i);
                if (this.areaInfo.isSpace) {
                    this.addSpaces();
                    continue;
                }
                if (n == -1) {
                    n = i;
                    n2 = 0;
                }
                n2 += this.areaInfo.getWordLength();
                if (!this.isWordEnd(i)) continue;
                this.addWord(n, i, n2);
                n = -1;
            }
        }

        private boolean isWordEnd(int n) {
            return n == this.lastIndex || TextLayoutManager.this.getAreaInfo(n + 1).isSpace;
        }

        private void addWord(int n, int n2, int n3) {
            int n4 = 0;
            boolean bl = false;
            if (this.isHyphenated(n2)) {
                ++n3;
            }
            this.initWord(n3);
            for (int i = n; i <= n2; ++i) {
                AreaInfo areaInfo = TextLayoutManager.this.getAreaInfo(i);
                this.addWordChars(areaInfo);
                this.addLetterAdjust(areaInfo);
                if (!this.addGlyphPositionAdjustments(areaInfo)) continue;
                bl = true;
            }
            if (this.isHyphenated(n2)) {
                this.addHyphenationChar();
            }
            if (!bl) {
                this.gposAdjustments = null;
            }
            this.textArea.addWord(this.wordChars.toString(), this.wordIPD, this.letterSpaceAdjust, this.getNonEmptyLevels(), this.gposAdjustments, n4);
        }

        private int[] getNonEmptyLevels() {
            if (this.wordLevels != null) {
                assert (this.wordLevelsIndex <= this.wordLevels.length);
                boolean bl = true;
                int n = this.wordLevelsIndex;
                for (int i = 0; i < n; ++i) {
                    if (this.wordLevels[i] < 0) continue;
                    bl = false;
                    break;
                }
                return bl ? null : this.wordLevels;
            }
            return null;
        }

        private void initWord(int n) {
            this.wordChars = new StringBuffer(n);
            this.letterSpaceAdjust = new int[n];
            this.letterSpaceAdjustIndex = 0;
            this.wordLevels = new int[n];
            this.wordLevelsIndex = 0;
            Arrays.fill(this.wordLevels, -1);
            this.gposAdjustments = new int[n][4];
            this.gposAdjustmentsIndex = 0;
            this.wordIPD = 0;
        }

        private boolean isHyphenated(int n) {
            return this.isLastArea && n == this.lastIndex && this.areaInfo.isHyphenated;
        }

        private void addHyphenationChar() {
            this.wordChars.append(TextLayoutManager.this.foText.getCommonHyphenation().getHyphChar(this.font));
        }

        private void addWordChars(AreaInfo areaInfo) {
            int n = areaInfo.startIndex;
            int n2 = areaInfo.breakIndex;
            if (TextLayoutManager.this.foText.hasMapping(n, n2)) {
                this.wordChars.append(TextLayoutManager.this.foText.getMapping(n, n2));
                this.addWordLevels(TextLayoutManager.this.foText.getMappingBidiLevels(n, n2));
            } else {
                for (int i = n; i < n2; ++i) {
                    this.wordChars.append(TextLayoutManager.this.foText.charAt(i));
                }
                this.addWordLevels(TextLayoutManager.this.foText.getBidiLevels(n, n2));
            }
            this.wordIPD += areaInfo.areaIPD.getOpt();
        }

        private void addWordLevels(int[] nArray) {
            int n;
            int n2 = n = nArray != null ? nArray.length : 0;
            if (n > 0) {
                int n3 = this.wordLevelsIndex + n;
                if (n3 <= this.wordLevels.length) {
                    System.arraycopy(nArray, 0, this.wordLevels, this.wordLevelsIndex, n);
                } else {
                    throw new IllegalStateException("word levels array too short: expect at least " + n3 + " entries, but has only " + this.wordLevels.length + " entries");
                }
            }
            this.wordLevelsIndex += n;
        }

        private void addLetterAdjust(AreaInfo areaInfo) {
            int n = areaInfo.letterSpaceCount;
            int n2 = areaInfo.getWordLength();
            int n3 = this.textArea.getTextLetterSpaceAdjust();
            int n4 = n2;
            for (int i = 0; i < n4; ++i) {
                int n5 = this.letterSpaceAdjustIndex + i;
                if (n5 > 0) {
                    int n6 = areaInfo.startIndex + i;
                    MinOptMax minOptMax = n6 < TextLayoutManager.this.letterSpaceAdjustArray.length ? TextLayoutManager.this.letterSpaceAdjustArray[n6] : null;
                    int n7 = this.letterSpaceAdjust[n5] = minOptMax == null ? 0 : minOptMax.getOpt();
                }
                if (n <= 0) continue;
                int n8 = n5;
                this.letterSpaceAdjust[n8] = this.letterSpaceAdjust[n8] + n3;
                --n;
            }
            this.letterSpaceAdjustIndex += n2;
        }

        private boolean addGlyphPositionAdjustments(AreaInfo areaInfo) {
            boolean bl = false;
            int[][] nArray = areaInfo.gposAdjustments;
            int n = nArray != null ? nArray.length : 0;
            int n2 = areaInfo.getWordLength();
            if (n > 0) {
                int n3 = this.gposAdjustmentsIndex + n;
                if (n3 <= this.gposAdjustments.length) {
                    int n4 = n2;
                    int n5 = 0;
                    for (int i = 0; i < n4; ++i) {
                        if (i >= n) continue;
                        int[] nArray2 = this.gposAdjustments[this.gposAdjustmentsIndex + i];
                        int[] nArray3 = nArray[n5++];
                        for (int j = 0; j < 4; ++j) {
                            int n6 = nArray3[j];
                            if (n6 == 0) continue;
                            int n7 = j;
                            nArray2[n7] = nArray2[n7] + n6;
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalStateException("gpos adjustments array too short: expect at least " + n3 + " entries, but has only " + this.gposAdjustments.length + " entries");
                }
            }
            this.gposAdjustmentsIndex += n2;
            return bl;
        }

        private void addSpaces() {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            for (n2 = this.areaInfo.startIndex; n2 < this.areaInfo.breakIndex; ++n2) {
                n = TextLayoutManager.this.foText.charAt(n2);
                if (!CharUtilities.isZeroWidthSpace(n)) continue;
                ++n4;
            }
            n2 = this.areaInfo.breakIndex - this.areaInfo.startIndex - n4;
            n = this.areaInfo.areaIPD.getOpt() / (n2 > 0 ? n2 : 1);
            for (int i = this.areaInfo.startIndex; i < this.areaInfo.breakIndex; ++i) {
                char c = TextLayoutManager.this.foText.charAt(i);
                int n5 = TextLayoutManager.this.foText.bidiLevelAt(i);
                if (CharUtilities.isZeroWidthSpace(c)) continue;
                this.textArea.addSpace(c, n, CharUtilities.isAdjustableSpace(c), n3, n5);
            }
        }
    }

    private final class PendingChange {
        private final AreaInfo areaInfo;
        private final int index;

        private PendingChange(AreaInfo areaInfo, int n) {
            this.areaInfo = areaInfo;
            this.index = n;
        }
    }

    private class AreaInfo {
        private final int startIndex;
        private final int breakIndex;
        private int wordCharLength;
        private final int wordSpaceCount;
        private int letterSpaceCount;
        private MinOptMax areaIPD;
        private final boolean isHyphenated;
        private final boolean isSpace;
        private boolean breakOppAfter;
        private final Font font;
        private final int level;
        private final int[][] gposAdjustments;

        AreaInfo(int n, int n2, int n3, int n4, MinOptMax minOptMax, boolean bl, boolean bl2, boolean bl3, Font font, int n5, int[][] nArray) {
            assert (n <= n2);
            this.startIndex = n;
            this.breakIndex = n2;
            this.wordCharLength = -1;
            this.wordSpaceCount = n3;
            this.letterSpaceCount = n4;
            this.areaIPD = minOptMax;
            this.isHyphenated = bl;
            this.isSpace = bl2;
            this.breakOppAfter = bl3;
            this.font = font;
            this.level = n5;
            this.gposAdjustments = nArray;
        }

        private int getWordLength() {
            if (this.wordCharLength == -1) {
                if (TextLayoutManager.this.foText.hasMapping(this.startIndex, this.breakIndex)) {
                    this.wordCharLength = TextLayoutManager.this.foText.getMapping(this.startIndex, this.breakIndex).length();
                } else {
                    assert (this.breakIndex >= this.startIndex);
                    this.wordCharLength = this.breakIndex - this.startIndex;
                }
            }
            return this.wordCharLength;
        }

        private void addToAreaIPD(MinOptMax minOptMax) {
            this.areaIPD = this.areaIPD.plus(minOptMax);
        }

        public String toString() {
            return super.toString() + "{" + "interval = [" + this.startIndex + "," + this.breakIndex + "]" + ", isSpace = " + this.isSpace + ", level = " + this.level + ", areaIPD = " + this.areaIPD + ", letterSpaceCount = " + this.letterSpaceCount + ", wordSpaceCount = " + this.wordSpaceCount + ", isHyphenated = " + this.isHyphenated + ", font = " + this.font + "}";
        }
    }
}

