/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.FilledArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLevelEventProducer;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class LeaderLayoutManager
extends LeafNodeLayoutManager {
    private Leader fobj;
    private Font font = null;
    private List contentList = null;
    private ContentLayoutManager clm = null;
    private int contentAreaIPD = 0;

    public LeaderLayoutManager(Leader leader) {
        super(leader);
        this.fobj = leader;
    }

    public void initialize() {
        FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue(this));
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    public InlineArea get(LayoutContext layoutContext) {
        return this.getLeaderInlineArea(layoutContext);
    }

    protected MinOptMax getAllocationIPD(int n) {
        return this.getLeaderAllocIPD(n);
    }

    private MinOptMax getLeaderAllocIPD(int n) {
        int n2 = 0;
        if (this.commonBorderPaddingBackground != null) {
            n2 = this.commonBorderPaddingBackground.getIPPaddingAndBorder(false, this);
        }
        this.setContentAreaIPD(n - n2);
        int n3 = this.fobj.getLeaderLength().getOptimum(this).getLength().getValue(this) - n2;
        int n4 = this.fobj.getLeaderLength().getMinimum(this).getLength().getValue(this) - n2;
        int n5 = this.fobj.getLeaderLength().getMaximum(this).getLength().getValue(this) - n2;
        return MinOptMax.getInstance(n4, n3, n5);
    }

    private InlineArea getLeaderInlineArea(LayoutContext layoutContext) {
        InlineArea inlineArea = null;
        int n = this.fobj.getBidiLevel();
        if (this.fobj.getLeaderPattern() == 123) {
            if (this.fobj.getRuleStyle() != 95) {
                org.apache.fop.area.inline.Leader leader = new org.apache.fop.area.inline.Leader();
                leader.setRuleStyle(this.fobj.getRuleStyle());
                leader.setRuleThickness(this.fobj.getRuleThickness().getValue(this));
                inlineArea = leader;
            } else {
                inlineArea = new Space();
                if (n >= 0) {
                    inlineArea.setBidiLevel(n);
                }
            }
            inlineArea.setBPD(this.fobj.getRuleThickness().getValue(this));
            inlineArea.addTrait(Trait.COLOR, this.fobj.getColor());
            if (n >= 0) {
                inlineArea.setBidiLevel(n);
            }
        } else if (this.fobj.getLeaderPattern() == 134) {
            inlineArea = new Space();
            inlineArea.setBPD(this.fobj.getRuleThickness().getValue(this));
            if (n >= 0) {
                inlineArea.setBidiLevel(n);
            }
        } else if (this.fobj.getLeaderPattern() == 35) {
            int[] nArray;
            TextArea textArea = new TextArea();
            char c = '.';
            int n2 = this.font.getCharWidth(c);
            if (n < 0) {
                nArray = null;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = n;
            }
            int[] nArray3 = nArray;
            textArea.addWord("" + c, n2, null, nArray3, null, 0);
            textArea.setIPD(n2);
            textArea.setBPD(n2);
            textArea.setBaselineOffset(n2);
            TraitSetter.addFontTraits(textArea, this.font);
            textArea.addTrait(Trait.COLOR, this.fobj.getColor());
            Space space = null;
            int n3 = this.fobj.getLeaderPatternWidth().getValue(this);
            if (n3 > n2) {
                space = new Space();
                space.setIPD(n3 - n2);
                if (n >= 0) {
                    space.setBidiLevel(n);
                }
                n2 = n3;
            }
            FilledArea filledArea = new FilledArea();
            filledArea.setUnitWidth(n2);
            filledArea.addChildArea(textArea);
            if (space != null) {
                filledArea.addChildArea(space);
            }
            filledArea.setBPD(textArea.getBPD());
            inlineArea = filledArea;
        } else if (this.fobj.getLeaderPattern() == 158) {
            if (this.fobj.getChildNodes() == null) {
                InlineLevelEventProducer inlineLevelEventProducer = InlineLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
                inlineLevelEventProducer.leaderWithoutContent(this, this.getFObj().getLocator());
                return null;
            }
            this.fobjIter = null;
            FilledArea filledArea = new FilledArea();
            this.clm = new ContentLayoutManager(filledArea, this);
            this.addChildLM(this.clm);
            InlineLayoutManager inlineLayoutManager = new InlineLayoutManager(this.fobj);
            this.clm.addChildLM(inlineLayoutManager);
            inlineLayoutManager.initialize();
            LayoutContext layoutContext2 = new LayoutContext(0);
            layoutContext2.setAlignmentContext(layoutContext.getAlignmentContext());
            this.contentList = this.clm.getNextKnuthElements(layoutContext2, 0);
            int n4 = this.clm.getStackingSize();
            if (n4 != 0) {
                Space space = null;
                if (this.fobj.getLeaderPatternWidth().getValue(this) > n4) {
                    space = new Space();
                    space.setIPD(this.fobj.getLeaderPatternWidth().getValue(this) - n4);
                    if (n >= 0) {
                        space.setBidiLevel(n);
                    }
                    n4 = this.fobj.getLeaderPatternWidth().getValue(this);
                }
                filledArea.setUnitWidth(n4);
                if (space != null) {
                    filledArea.addChildArea(space);
                }
                inlineArea = filledArea;
            } else {
                inlineArea = new Space();
                inlineArea.setBPD(this.fobj.getRuleThickness().getValue(this));
                inlineArea.setBidiLevel(this.fobj.getBidiLevelRecursive());
            }
        }
        TraitSetter.setProducerID(inlineArea, this.fobj.getId());
        return inlineArea;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        if (this.fobj.getLeaderPattern() != 158) {
            super.addAreas(positionIterator, layoutContext);
        } else {
            this.addId();
            this.widthAdjustArea(this.curArea, layoutContext);
            if (this.commonBorderPaddingBackground != null) {
                TraitSetter.setBorderPaddingTraits(this.curArea, this.commonBorderPaddingBackground, false, false, this);
                TraitSetter.addBackground(this.curArea, this.commonBorderPaddingBackground, this);
            }
            KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(this.contentList, 0, this.contentList.size());
            this.clm.addAreas(knuthPossPosIter, layoutContext);
            this.parentLayoutManager.addChildArea(this.curArea);
            while (positionIterator.hasNext()) {
                positionIterator.next();
            }
        }
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        this.curArea = this.get(layoutContext);
        InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        this.alignmentContext = new AlignmentContext(this.curArea.getBPD(), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), layoutContext.getAlignmentContext());
        MinOptMax minOptMax = this.getAllocationIPD(layoutContext.getRefIPD());
        if (this.fobj.getLeaderPattern() == 158 && this.curArea instanceof FilledArea) {
            int n2 = ((FilledArea)this.curArea).getUnitWidth();
            if (minOptMax.getOpt() < n2 && n2 <= minOptMax.getMax()) {
                minOptMax = MinOptMax.getInstance(minOptMax.getMin(), n2, minOptMax.getMax());
            }
        }
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, minOptMax, false, layoutContext.getAlignmentContext());
        this.curArea.setAdjustingInfo(minOptMax.getStretch(), minOptMax.getShrink(), 0);
        this.addKnuthElementsForBorderPaddingStart(inlineKnuthSequence);
        inlineKnuthSequence.add(new KnuthInlineBox(0, this.alignmentContext, new LeafPosition(this, -1), true));
        inlineKnuthSequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
        if (n == 70 || n == 0) {
            inlineKnuthSequence.add(new KnuthGlue(this.areaInfo.ipdArea, (Position)new LeafPosition(this, 0), false));
        } else {
            inlineKnuthSequence.add(new KnuthGlue(this.areaInfo.ipdArea.getOpt(), 0, 0, new LeafPosition(this, 0), false));
        }
        inlineKnuthSequence.add(new KnuthInlineBox(0, this.alignmentContext, new LeafPosition(this, -1), true));
        this.addKnuthElementsForBorderPaddingEnd(inlineKnuthSequence);
        this.setFinished(true);
        return Collections.singletonList(inlineKnuthSequence);
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
        super.hyphenate(position, hyphContext);
    }

    public boolean applyChanges(List list) {
        this.setFinished(false);
        return false;
    }

    public List getChangedKnuthElements(List list, int n) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        this.addKnuthElementsForBorderPaddingStart(linkedList);
        linkedList.add(new KnuthInlineBox(0, this.areaInfo.alignmentContext, new LeafPosition(this, -1), true));
        linkedList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
        if (n == 70 || n == 0) {
            linkedList.add(new KnuthGlue(this.areaInfo.ipdArea, (Position)new LeafPosition(this, 0), false));
        } else {
            linkedList.add(new KnuthGlue(this.areaInfo.ipdArea.getOpt(), 0, 0, new LeafPosition(this, 0), false));
        }
        linkedList.add(new KnuthInlineBox(0, this.areaInfo.alignmentContext, new LeafPosition(this, -1), true));
        this.addKnuthElementsForBorderPaddingEnd(linkedList);
        this.setFinished(true);
        return linkedList;
    }

    public int getBaseLength(int n, FObj fObj) {
        return this.getParent().getBaseLength(n, this.getParent().getFObj());
    }

    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    private void setContentAreaIPD(int n) {
        this.contentAreaIPD = n;
    }

    public void reset() {
        this.childLMs.clear();
        super.reset();
    }
}

