/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.BlockKnuthSequence;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.ListUtil;

public class InlineLayoutManager
extends InlineStackingLayoutManager {
    private static Log log = LogFactory.getLog(InlineLayoutManager.class);
    private CommonMarginInline inlineProps = null;
    private CommonBorderPaddingBackground borderProps = null;
    private boolean areaCreated = false;
    private LayoutManager lastChildLM = null;
    private Font font;
    protected Length alignmentAdjust;
    protected int alignmentBaseline = 12;
    protected Length baselineShift;
    protected int dominantBaseline;
    protected SpaceProperty lineHeight;
    private AlignmentContext alignmentContext = null;

    public InlineLayoutManager(InlineLevel inlineLevel) {
        super(inlineLevel);
    }

    public void initialize() {
        InlineLevel inlineLevel = (InlineLevel)this.fobj;
        int n = 0;
        FontInfo fontInfo = inlineLevel.getFOEventHandler().getFontInfo();
        CommonFont commonFont = inlineLevel.getCommonFont();
        FontTriplet[] fontTripletArray = commonFont.getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], commonFont.fontSize.getValue(this));
        this.lineHeight = inlineLevel.getLineHeight();
        this.borderProps = inlineLevel.getCommonBorderPaddingBackground();
        this.inlineProps = inlineLevel.getCommonMarginInline();
        if (inlineLevel instanceof Inline) {
            this.alignmentAdjust = ((Inline)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((Inline)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((Inline)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((Inline)inlineLevel).getDominantBaseline();
        } else if (inlineLevel instanceof Leader) {
            this.alignmentAdjust = ((Leader)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((Leader)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((Leader)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((Leader)inlineLevel).getDominantBaseline();
        } else if (inlineLevel instanceof BasicLink) {
            this.alignmentAdjust = ((BasicLink)inlineLevel).getAlignmentAdjust();
            this.alignmentBaseline = ((BasicLink)inlineLevel).getAlignmentBaseline();
            this.baselineShift = ((BasicLink)inlineLevel).getBaselineShift();
            this.dominantBaseline = ((BasicLink)inlineLevel).getDominantBaseline();
        }
        if (this.borderProps != null) {
            n = this.borderProps.getPadding(0, false, this);
            n += this.borderProps.getBorderWidth(0, false);
            n += this.borderProps.getPadding(1, false, this);
            n += this.borderProps.getBorderWidth(1, false);
        }
        this.extraBPD = MinOptMax.getInstance(n);
    }

    protected MinOptMax getExtraIPD(boolean bl, boolean bl2) {
        int n = 0;
        if (this.borderProps != null) {
            n = this.borderProps.getPadding(2, bl, this);
            n += this.borderProps.getBorderWidth(2, bl);
            n += this.borderProps.getPadding(3, bl2, this);
            n += this.borderProps.getBorderWidth(3, bl2);
        }
        return MinOptMax.getInstance(n);
    }

    protected boolean hasLeadingFence(boolean bl) {
        return this.borderProps != null && (this.borderProps.getPadding(2, bl, this) > 0 || this.borderProps.getBorderWidth(2, bl) > 0);
    }

    protected boolean hasTrailingFence(boolean bl) {
        return this.borderProps != null && (this.borderProps.getPadding(3, bl, this) > 0 || this.borderProps.getBorderWidth(3, bl) > 0);
    }

    protected SpaceProperty getSpaceStart() {
        return this.inlineProps != null ? this.inlineProps.spaceStart : null;
    }

    protected SpaceProperty getSpaceEnd() {
        return this.inlineProps != null ? this.inlineProps.spaceEnd : null;
    }

    protected InlineArea createArea(boolean bl) {
        InlineArea inlineArea;
        if (bl) {
            inlineArea = this.createInlineParent();
            inlineArea.setBlockProgressionOffset(0);
        } else {
            inlineArea = new InlineBlockParent();
        }
        if (this.fobj instanceof Inline || this.fobj instanceof BasicLink) {
            TraitSetter.setProducerID(inlineArea, this.fobj.getId());
        }
        return inlineArea;
    }

    protected InlineParent createInlineParent() {
        return new InlineParent();
    }

    protected void setTraits(boolean bl, boolean bl2) {
        if (this.borderProps != null) {
            TraitSetter.setBorderPaddingTraits(this.getCurrentArea(), this.borderProps, bl, bl2, this);
            TraitSetter.addBackground(this.getCurrentArea(), this.borderProps, this);
        }
    }

    public boolean mustKeepTogether() {
        return this.mustKeepTogether(this.getParent());
    }

    private boolean mustKeepTogether(LayoutManager layoutManager) {
        if (layoutManager instanceof BlockLevelLayoutManager) {
            return ((BlockLevelLayoutManager)layoutManager).mustKeepTogether();
        }
        if (layoutManager instanceof InlineLayoutManager) {
            return ((InlineLayoutManager)layoutManager).mustKeepTogether();
        }
        return this.mustKeepTogether(layoutManager.getParent());
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        Object object;
        LayoutManager layoutManager;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        KnuthSequence knuthSequence = null;
        this.alignmentContext = this.fobj instanceof Title ? new AlignmentContext(this.font, this.lineHeight.getOptimum(this).getLength().getValue(this), layoutContext.getWritingMode()) : new AlignmentContext(this.font, this.lineHeight.getOptimum(this).getLength().getValue(this), this.alignmentAdjust, this.alignmentBaseline, this.baselineShift, this.dominantBaseline, layoutContext.getAlignmentContext());
        this.childLC = new LayoutContext(layoutContext);
        this.childLC.setAlignmentContext(this.alignmentContext);
        if (layoutContext.startsNewArea() && this.getSpaceStart() != null) {
            layoutContext.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), this));
        }
        StringBuffer stringBuffer = new StringBuffer("InlineLM:");
        boolean bl = false;
        if (this.borderProps != null) {
            this.childLC.setLineStartBorderAndPaddingWidth(layoutContext.getLineStartBorderAndPaddingWidth() + this.borderProps.getPaddingStart(true, this) + this.borderProps.getBorderStartWidth(true));
            this.childLC.setLineEndBorderAndPaddingWidth(layoutContext.getLineEndBorderAndPaddingWidth() + this.borderProps.getPaddingEnd(true, this) + this.borderProps.getBorderEndWidth(true));
        }
        while ((layoutManager = this.getChildLM()) != null) {
            Object object2;
            int n2;
            if (!(layoutManager instanceof InlineLevelLayoutManager) && this.borderProps != null) {
                this.childLC.setRefIPD(this.childLC.getRefIPD() - this.borderProps.getPaddingStart(this.lastChildLM != null, this) - this.borderProps.getBorderStartWidth(this.lastChildLM != null) - this.borderProps.getPaddingEnd(this.hasNextChildLM(), this) - this.borderProps.getBorderEndWidth(this.hasNextChildLM()));
            }
            List list = layoutManager.getNextKnuthElements(this.childLC, n);
            if (linkedList.isEmpty() && this.childLC.isKeepWithPreviousPending()) {
                this.childLC.clearKeepWithPreviousPending();
            }
            if (list == null || list.isEmpty()) continue;
            if (layoutManager instanceof InlineLevelLayoutManager) {
                layoutContext.clearKeepWithNextPending();
                object = list.listIterator();
                while (object.hasNext()) {
                    KnuthSequence knuthSequence2 = (KnuthSequence)object.next();
                    knuthSequence2.wrapPositions(this);
                }
                n2 = 0;
                if (knuthSequence != null && knuthSequence.appendSequenceOrClose((KnuthSequence)list.get(0))) {
                    n2 = 1;
                }
                if (!bl && !list.isEmpty()) {
                    this.addKnuthElementsForBorderPaddingStart((List)list.get(0));
                    bl = true;
                }
                object2 = list.listIterator(n2);
                while (object2.hasNext()) {
                    linkedList.add(object2.next());
                }
            } else {
                object = new BlockKnuthSequence(list);
                ((KnuthSequence)object).wrapPositions(this);
                n2 = 0;
                if (knuthSequence != null) {
                    if (knuthSequence.canAppendSequence((KnuthSequence)object)) {
                        object2 = new BreakElement(new Position(this), 0, layoutContext);
                        boolean bl2 = this.mustKeepTogether() || layoutContext.isKeepWithNextPending() || this.childLC.isKeepWithPreviousPending();
                        n2 = knuthSequence.appendSequenceOrClose((KnuthSequence)object, bl2, (BreakElement)object2) ? 1 : 0;
                    } else {
                        knuthSequence.endSequence();
                    }
                }
                if (n2 == 0) {
                    if (!bl) {
                        this.addKnuthElementsForBorderPaddingStart((List)object);
                        bl = true;
                    }
                    linkedList.add(object);
                }
                layoutContext.updateKeepWithNextPending(this.childLC.getKeepWithNextPending());
                this.childLC.clearKeepsPending();
            }
            knuthSequence = (KnuthSequence)ListUtil.getLast(linkedList);
            this.lastChildLM = layoutManager;
            this.childLC.setFlags(16, false);
        }
        if (knuthSequence != null) {
            this.addKnuthElementsForBorderPaddingEnd(knuthSequence);
        }
        this.setFinished(true);
        log.trace((Object)stringBuffer);
        if (linkedList.isEmpty() && (this.fobj.hasId() || this.fobj.hasMarkers())) {
            object = new InlineKnuthSequence();
            ((ArrayList)object).add(new KnuthInlineBox(0, this.alignmentContext, this.notifyPos(this.getAuxiliaryPosition()), true));
            linkedList.add(object);
        }
        return linkedList.isEmpty() ? null : linkedList;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        boolean bl;
        LayoutManager layoutManager;
        this.addId();
        this.setChildContext(new LayoutContext(layoutContext));
        LinkedList<Position> linkedList = new LinkedList<Position>();
        LayoutManager layoutManager2 = null;
        Position position = null;
        while (positionIterator.hasNext()) {
            Position position2 = positionIterator.next();
            if (position2 == null || position2.getPosition() == null) continue;
            if (this.isFirst(position2)) {
                this.areaCreated = false;
            }
            linkedList.add(position2.getPosition());
            layoutManager2 = position2.getPosition().getLM();
            position = position2;
        }
        if (this.hasLeadingFence(this.areaCreated)) {
            this.getContext().setLeadingSpace(new SpaceSpecifier(false));
            this.getContext().setFlags(256, true);
        } else {
            this.getContext().setFlags(256, false);
        }
        if (this.getSpaceStart() != null) {
            layoutContext.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart(), this));
        }
        this.addMarkersToPage(true, !this.areaCreated, position == null || this.isLast(position));
        InlineArea inlineArea = this.createArea(layoutManager2 == null || layoutManager2 instanceof InlineLevelLayoutManager);
        inlineArea.setBPD(this.alignmentContext.getHeight());
        if (inlineArea instanceof InlineParent) {
            inlineArea.setBlockProgressionOffset(this.alignmentContext.getOffset());
        } else if (inlineArea instanceof InlineBlockParent && this.borderProps != null) {
            inlineArea.setBlockProgressionOffset(this.borderProps.getPaddingBefore(false, this) + this.borderProps.getBorderBeforeWidth(false));
        }
        this.setCurrentArea(inlineArea);
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        LayoutManager layoutManager3 = null;
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            this.getContext().setFlags(128, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutManager.addAreas(positionIterator2, this.getContext());
            this.getContext().setLeadingSpace(this.getContext().getTrailingSpace());
            this.getContext().setFlags(256, true);
            layoutManager3 = layoutManager;
        }
        boolean bl2 = bl = this.getContext().isLastArea() && layoutManager3 == this.lastChildLM;
        if (this.hasTrailingFence(bl)) {
            this.addSpace(this.getCurrentArea(), this.getContext().getTrailingSpace().resolve(false), this.getContext().getSpaceAdjust());
            layoutContext.setTrailingSpace(new SpaceSpecifier(false));
        } else {
            layoutContext.setTrailingSpace(this.getContext().getTrailingSpace());
        }
        if (layoutContext.getTrailingSpace() != null && this.getSpaceEnd() != null) {
            layoutContext.getTrailingSpace().addSpace(new SpaceVal(this.getSpaceEnd(), this));
        }
        this.setTraits(this.areaCreated, position == null || !this.isLast(position));
        this.parentLayoutManager.addChildArea(this.getCurrentArea());
        this.addMarkersToPage(false, !this.areaCreated, position == null || this.isLast(position));
        layoutContext.setFlags(128, bl);
        this.areaCreated = true;
        this.checkEndOfLayout(position);
    }

    public void addChildArea(Area area) {
        Area area2 = this.getCurrentArea();
        if (this.getContext().resolveLeadingSpace()) {
            this.addSpace(area2, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
        }
        area2.addChildArea(area);
    }

    public List getChangedKnuthElements(List list, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        this.addKnuthElementsForBorderPaddingStart(linkedList);
        linkedList.addAll(super.getChangedKnuthElements(list, n, n2));
        this.addKnuthElementsForBorderPaddingEnd(linkedList);
        return linkedList;
    }

    protected void addKnuthElementsForBorderPaddingStart(List list) {
        int n;
        if (list instanceof BlockKnuthSequence) {
            return;
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = ((InlineLevel)this.fobj).getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground != null && (n = commonBorderPaddingBackground.getBorderStartWidth(false) + commonBorderPaddingBackground.getPaddingStart(false, this)) > 0) {
            list.add(0, new KnuthBox(n, this.getAuxiliaryPosition(), true));
        }
    }

    protected void addKnuthElementsForBorderPaddingEnd(List list) {
        int n;
        if (list instanceof BlockKnuthSequence) {
            return;
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = ((InlineLevel)this.fobj).getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground != null && (n = commonBorderPaddingBackground.getBorderEndWidth(false) + commonBorderPaddingBackground.getPaddingEnd(false, this)) > 0) {
            list.add(new KnuthBox(n, this.getAuxiliaryPosition(), true));
        }
    }

    protected Position getAuxiliaryPosition() {
        return new NonLeafPosition((LayoutManager)this, null);
    }
}

