/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class FootnoteLayoutManager
extends InlineStackingLayoutManager {
    private static Log log = LogFactory.getLog(FootnoteLayoutManager.class);
    private Footnote footnote;
    private InlineStackingLayoutManager citationLM;
    private FootnoteBodyLayoutManager bodyLM;
    private KnuthElement forcedAnchor;

    public FootnoteLayoutManager(Footnote footnote) {
        super(footnote);
        this.footnote = footnote;
    }

    public void initialize() {
        this.citationLM = new InlineLayoutManager(this.footnote.getFootnoteCitation());
        this.bodyLM = new FootnoteBodyLayoutManager(this.footnote.getFootnoteBody());
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        Object object;
        this.citationLM.setParent(this);
        this.citationLM.initialize();
        this.bodyLM.setParent(this);
        this.bodyLM.initialize();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (!this.citationLM.isFinished()) {
            object = this.citationLM.getNextKnuthElements(layoutContext, n);
            if (object == null) continue;
            linkedList.addAll((Collection<Object>)object);
        }
        if (linkedList.size() == 0) {
            object = new InlineKnuthSequence();
            this.forcedAnchor = new KnuthInlineBox(0, null, null, true);
            ((ArrayList)object).add(this.forcedAnchor);
            linkedList.add(object);
        }
        this.setFinished(true);
        this.addAnchor(linkedList);
        object = linkedList.listIterator();
        ListIterator listIterator = null;
        KnuthSequence knuthSequence = null;
        KnuthElement knuthElement = null;
        while (object.hasNext()) {
            knuthSequence = (KnuthSequence)object.next();
            listIterator = knuthSequence.listIterator();
            while (listIterator.hasNext()) {
                knuthElement = (KnuthElement)listIterator.next();
                knuthElement.setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, knuthElement.getPosition())));
            }
        }
        return linkedList;
    }

    public List getChangedKnuthElements(List list, int n, int n2) {
        List list2 = super.getChangedKnuthElements(list, n, n2);
        this.addAnchor(list2);
        return list2;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        LayoutManager layoutManager;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        while (positionIterator.hasNext()) {
            Position position = positionIterator.next();
            if (position == null || position.getPosition() == null) continue;
            linkedList.add(position.getPosition());
        }
        this.citationLM.setParent(this.getParent());
        LayoutContext layoutContext2 = new LayoutContext(layoutContext);
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            layoutManager.addAreas(positionIterator2, layoutContext2);
            layoutContext2.setLeadingSpace(layoutContext2.getTrailingSpace());
            layoutContext2.setFlags(256, true);
        }
    }

    private void addAnchor(List list) {
        KnuthInlineBox knuthInlineBox = null;
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious() && knuthInlineBox == null) {
            Object object;
            Object e = listIterator.previous();
            if (e instanceof KnuthElement) {
                object = (KnuthElement)e;
                if (!(object instanceof KnuthInlineBox)) continue;
                knuthInlineBox = (KnuthInlineBox)object;
                continue;
            }
            object = (KnuthSequence)e;
            ListIterator listIterator2 = ((ArrayList)object).listIterator(((ArrayList)object).size());
            while (listIterator2.hasPrevious() && knuthInlineBox == null) {
                KnuthElement knuthElement = (KnuthElement)listIterator2.previous();
                if ((!(knuthElement instanceof KnuthInlineBox) || knuthElement.isAuxiliary()) && knuthElement != this.forcedAnchor) continue;
                knuthInlineBox = (KnuthInlineBox)knuthElement;
            }
        }
        if (knuthInlineBox != null) {
            knuthInlineBox.setFootnoteBodyLM(this.bodyLM);
        }
    }
}

