/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class SpaceSpecifier
implements Cloneable {
    private boolean startsReferenceArea;
    private boolean hasForcing = false;
    private List spaceVals = new ArrayList();

    public SpaceSpecifier(boolean bl) {
        this.startsReferenceArea = bl;
    }

    public Object clone() {
        try {
            SpaceSpecifier spaceSpecifier = (SpaceSpecifier)super.clone();
            spaceSpecifier.startsReferenceArea = this.startsReferenceArea;
            spaceSpecifier.hasForcing = this.hasForcing;
            spaceSpecifier.spaceVals = new ArrayList();
            spaceSpecifier.spaceVals.addAll(this.spaceVals);
            return spaceSpecifier;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void clear() {
        this.hasForcing = false;
        this.spaceVals.clear();
    }

    public boolean hasSpaces() {
        return !this.spaceVals.isEmpty();
    }

    public void addSpace(SpaceVal spaceVal) {
        if (!this.startsReferenceArea || !spaceVal.isConditional() || this.hasSpaces()) {
            if (spaceVal.isForcing()) {
                if (!this.hasForcing) {
                    this.spaceVals.clear();
                    this.hasForcing = true;
                }
                this.spaceVals.add(spaceVal);
            } else if (!this.hasForcing && spaceVal.getSpace().isNonZero()) {
                this.spaceVals.add(spaceVal);
            }
        }
    }

    public MinOptMax resolve(boolean bl) {
        Object object;
        int n;
        if (bl) {
            for (n = this.spaceVals.size(); n > 0 && ((SpaceVal)(object = (SpaceVal)this.spaceVals.get(n - 1))).isConditional(); --n) {
            }
        }
        object = MinOptMax.ZERO;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            SpaceVal spaceVal = (SpaceVal)this.spaceVals.get(i);
            MinOptMax minOptMax = spaceVal.getSpace();
            if (this.hasForcing) {
                object = ((MinOptMax)object).plus(minOptMax);
                continue;
            }
            int n3 = spaceVal.getPrecedence();
            if (n3 > n2) {
                n2 = n3;
                object = minOptMax;
                continue;
            }
            if (n3 != n2) continue;
            if (minOptMax.getOpt() > ((MinOptMax)object).getOpt()) {
                object = minOptMax;
                continue;
            }
            if (minOptMax.getOpt() != ((MinOptMax)object).getOpt()) continue;
            if (((MinOptMax)object).getMin() < minOptMax.getMin()) {
                object = MinOptMax.getInstance(minOptMax.getMin(), ((MinOptMax)object).getOpt(), ((MinOptMax)object).getMax());
            }
            if (((MinOptMax)object).getMax() <= minOptMax.getMax()) continue;
            object = MinOptMax.getInstance(((MinOptMax)object).getMin(), ((MinOptMax)object).getOpt(), minOptMax.getMax());
        }
        return object;
    }

    public String toString() {
        return "Space Specifier (resolved at begin/end of ref. area:):\n" + this.resolve(false) + "\n" + this.resolve(true);
    }
}

