/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;

public class SpaceElement
extends UnresolvedListElementWithLength {
    private int precedence;

    public SpaceElement(Position position, SpaceProperty spaceProperty, RelSide relSide, boolean bl, boolean bl2, PercentBaseContext percentBaseContext) {
        super(position, spaceProperty.getSpace().getLengthRange().toMinOptMax(percentBaseContext), relSide, spaceProperty.isDiscard(), bl, bl2);
        int n = spaceProperty.getSpace().getPrecedence().getEnum();
        this.precedence = n == 53 ? Integer.MAX_VALUE : spaceProperty.getSpace().getPrecedence().getNumber().intValue();
    }

    public boolean isForcing() {
        return this.precedence == Integer.MAX_VALUE;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void notifyLayoutManager(MinOptMax minOptMax) {
        LayoutManager layoutManager = this.getOriginatingLayoutManager();
        if (layoutManager instanceof ConditionalElementListener) {
            ((ConditionalElementListener)((Object)layoutManager)).notifySpace(this.getSide(), minOptMax);
        } else {
            log.warn((Object)("Cannot notify LM. It does not implement ConditionalElementListener:" + layoutManager.getClass().getName()));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Space[");
        stringBuffer.append(super.toString());
        stringBuffer.append(", precedence=");
        if (this.isForcing()) {
            stringBuffer.append("forcing");
        } else {
            stringBuffer.append(this.getPrecedence());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

