/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionIterator
implements Iterator<Position> {
    private Iterator parentIter;
    private Object nextObj;
    private LayoutManager childLM;
    private boolean hasNext;

    public PositionIterator(Iterator iterator) {
        this.parentIter = iterator;
        this.lookAhead();
    }

    public LayoutManager getNextChildLM() {
        if (this.childLM == null && this.nextObj != null) {
            this.childLM = this.getLM(this.nextObj);
            this.hasNext = true;
        }
        return this.childLM;
    }

    protected LayoutManager getLM(Object object) {
        return this.getPos(object).getLM();
    }

    protected Position getPos(Object object) {
        if (object instanceof Position) {
            return (Position)object;
        }
        throw new IllegalArgumentException("Cannot obtain Position from the given object.");
    }

    private void lookAhead() {
        if (this.parentIter.hasNext()) {
            this.hasNext = true;
            this.nextObj = this.parentIter.next();
        } else {
            this.endIter();
        }
    }

    protected boolean checkNext() {
        LayoutManager layoutManager = this.getLM(this.nextObj);
        if (this.childLM == null) {
            this.childLM = layoutManager;
        } else if (this.childLM != layoutManager && layoutManager != null) {
            this.hasNext = false;
            this.childLM = null;
            return false;
        }
        return true;
    }

    protected void endIter() {
        this.hasNext = false;
        this.nextObj = null;
        this.childLM = null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext && this.checkNext();
    }

    @Override
    public Position next() throws NoSuchElementException {
        if (this.hasNext) {
            Position position = this.getPos(this.nextObj);
            this.lookAhead();
            return position;
        }
        throw new NoSuchElementException("PosIter");
    }

    public Object peekNext() {
        return this.nextObj;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PositionIterator doesn't support remove");
    }
}

