/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layoutmgr.Page;

public class PageProvider
implements Constants {
    private Log log = LogFactory.getLog(PageProvider.class);
    public static final int RELTO_PAGE_SEQUENCE = 0;
    public static final int RELTO_CURRENT_ELEMENT_LIST = 1;
    private int startPageOfPageSequence;
    private int startPageOfCurrentElementList;
    private int startColumnOfCurrentElementList;
    private boolean spanAllForCurrentElementList;
    private List<Page> cachedPages = new ArrayList<Page>();
    private int lastPageIndex = -1;
    private int indexOfCachedLastPage = -1;
    private int lastRequestedIndex = -1;
    private int lastReportedBPD = -1;
    private AreaTreeHandler areaTreeHandler;
    private PageSequence pageSeq;

    public PageProvider(AreaTreeHandler areaTreeHandler, PageSequence pageSequence) {
        this.areaTreeHandler = areaTreeHandler;
        this.pageSeq = pageSequence;
        this.startPageOfPageSequence = pageSequence.getStartingPageNumber();
    }

    public void setStartOfNextElementList(int n, int n2, boolean bl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start of the next element list is: page=" + n + " col=" + n2 + (bl ? ", column-spanning" : "")));
        }
        this.startPageOfCurrentElementList = n - this.startPageOfPageSequence + 1;
        this.startColumnOfCurrentElementList = n2;
        this.spanAllForCurrentElementList = bl;
        this.lastRequestedIndex = -1;
        this.lastReportedBPD = -1;
    }

    public void setLastPageIndex(int n) {
        this.lastPageIndex = n;
    }

    public int getAvailableBPD(int n) {
        if (this.lastRequestedIndex == n) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getAvailableBPD(" + n + ") -> (cached) " + this.lastReportedBPD));
            }
            return this.lastReportedBPD;
        }
        int n2 = 0;
        int n3 = this.startColumnOfCurrentElementList;
        Page page = this.getPage(false, n2, 1);
        for (int i = n; i > 0; --i) {
            if (++n3 < page.getPageViewport().getCurrentSpan().getColumnCount()) continue;
            n3 = 0;
            page = this.getPage(false, ++n2, 1);
        }
        this.lastRequestedIndex = n;
        this.lastReportedBPD = page.getPageViewport().getBodyRegion().getRemainingBPD();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getAvailableBPD(" + n + ") -> " + this.lastReportedBPD));
        }
        return this.lastReportedBPD;
    }

    private int[] getColIndexAndColCount(int n) {
        Page page;
        int n2 = 0;
        int n3 = this.startColumnOfCurrentElementList + n;
        int n4 = -1;
        while ((n3 -= n2) >= (n2 = (page = this.getPage(false, ++n4, 1)).getPageViewport().getCurrentSpan().getColumnCount())) {
        }
        return new int[]{n3, n2};
    }

    public int compareIPDs(int n) {
        Page page;
        int n2 = 0;
        int n3 = this.startColumnOfCurrentElementList + n;
        int n4 = -1;
        while ((n3 -= n2) >= (n2 = (page = this.getPage(false, ++n4, 1)).getPageViewport().getCurrentSpan().getColumnCount())) {
        }
        if (n3 + 1 < n2) {
            return 0;
        }
        Page page2 = this.getPage(false, n4 + 1, 1);
        return page.getPageViewport().getBodyRegion().getIPD() - page2.getPageViewport().getBodyRegion().getIPD();
    }

    boolean startPage(int n) {
        return this.getColIndexAndColCount(n)[0] == 0;
    }

    boolean endPage(int n) {
        int[] nArray = this.getColIndexAndColCount(n);
        return nArray[0] == nArray[1] - 1;
    }

    int getColumnCount(int n) {
        return this.getColIndexAndColCount(n)[1];
    }

    public int getStartingPartIndexForLastPage(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.startColumnOfCurrentElementList;
        Page page = this.getPage(false, n3, 1);
        for (int i = 0; i < n; ++i) {
            if (n4 >= page.getPageViewport().getCurrentSpan().getColumnCount()) {
                n4 = 0;
                page = this.getPage(false, ++n3, 1);
                n2 = i;
            }
            ++n4;
        }
        return n2;
    }

    public Page getPage(boolean bl, int n, int n2) {
        if (n2 == 0) {
            return this.getPage(bl, n);
        }
        if (n2 == 1) {
            int n3 = this.startPageOfCurrentElementList + n;
            return this.getPage(bl, n3 += this.startPageOfPageSequence - 1);
        }
        throw new IllegalArgumentException("Illegal value for relativeTo: " + n2);
    }

    protected Page getPage(boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = this.lastPageIndex >= 0 && n == this.lastPageIndex;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getPage(" + n + " " + (bl ? "blank" : "non-blank") + (bl2 ? " <LAST>" : "") + ")"));
        }
        int n2 = n - this.startPageOfPageSequence;
        if (this.log.isTraceEnabled()) {
            if (bl) {
                this.log.trace((Object)("blank page requested: " + n));
            }
            if (bl2) {
                this.log.trace((Object)("last page requested: " + n));
            }
        }
        while (n2 >= this.cachedPages.size()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching " + n));
            }
            this.cacheNextPage(n, bl, bl2, this.spanAllForCurrentElementList);
        }
        Page page = this.cachedPages.get(n2);
        boolean bl4 = false;
        if (page.getPageViewport().isBlank() != bl) {
            this.log.debug((Object)"blank condition doesn't match. Replacing PageViewport.");
            bl4 = true;
        }
        if (bl2 && this.indexOfCachedLastPage != n2 || !bl2 && this.indexOfCachedLastPage >= 0) {
            this.log.debug((Object)"last page condition doesn't match. Replacing PageViewport.");
            bl4 = true;
            int n3 = this.indexOfCachedLastPage = bl2 ? n2 : -1;
        }
        if (bl4) {
            this.discardCacheStartingWith(n2);
            page = this.cacheNextPage(n, bl, bl2, this.spanAllForCurrentElementList);
        }
        return page;
    }

    private void discardCacheStartingWith(int n) {
        while (n < this.cachedPages.size()) {
            this.cachedPages.remove(this.cachedPages.size() - 1);
            if (this.pageSeq.goToPreviousSimplePageMaster()) continue;
            this.log.warn((Object)"goToPreviousSimplePageMaster() on the first page called!");
        }
    }

    private Page cacheNextPage(int n, boolean bl, boolean bl2, boolean bl3) {
        String string = this.pageSeq.makeFormattedPageNumber(n);
        boolean bl4 = this.startPageOfPageSequence == n;
        SimplePageMaster simplePageMaster = this.pageSeq.getNextSimplePageMaster(n, bl4, bl2, bl);
        Page page = new Page(simplePageMaster, n, string, bl, bl3);
        page.getPageViewport().setKey(this.areaTreeHandler.generatePageViewportKey());
        page.getPageViewport().setForeignAttributes(simplePageMaster.getForeignAttributes());
        page.getPageViewport().setWritingModeTraits(this.pageSeq);
        this.cachedPages.add(page);
        return page;
    }
}

