/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Block;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BalancingColumnBreakingAlgorithm;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageBreaker
extends AbstractBreaker {
    private PageSequenceLayoutManager pslm;
    private boolean firstPart = true;
    private boolean pageBreakHandled;
    private boolean needColumnBalancing;
    private PageProvider pageProvider;
    private Block separatorArea;
    private boolean spanAllActive;
    private FlowLayoutManager childFLM = null;
    private StaticContentLayoutManager footnoteSeparatorLM = null;

    public PageBreaker(PageSequenceLayoutManager pageSequenceLayoutManager) {
        this.pslm = pageSequenceLayoutManager;
        this.pageProvider = pageSequenceLayoutManager.getPageProvider();
        this.childFLM = pageSequenceLayoutManager.getLayoutManagerMaker().makeFlowLayoutManager(pageSequenceLayoutManager, pageSequenceLayoutManager.getPageSequence().getMainFlow());
    }

    protected void updateLayoutContext(LayoutContext layoutContext) {
        int n = this.pslm.getCurrentPV().getCurrentSpan().getColumnWidth();
        layoutContext.setRefIPD(n);
    }

    protected LayoutManager getTopLevelLM() {
        return this.pslm;
    }

    protected PageProvider getPageProvider() {
        return this.pslm.getPageProvider();
    }

    void doLayout(int n) {
        this.doLayout(n, false);
    }

    protected PageBreakingAlgorithm.PageBreakingLayoutListener createLayoutListener() {
        return new PageBreakingAlgorithm.PageBreakingLayoutListener(){

            public void notifyOverflow(int n, int n2, FObj fObj) {
                Page page = PageBreaker.this.pageProvider.getPage(false, n, 1);
                RegionBody regionBody = (RegionBody)page.getSimplePageMaster().getRegion(58);
                BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(regionBody.getUserAgent().getEventBroadcaster());
                boolean bl = regionBody.getOverflow() != 42;
                boolean bl2 = regionBody.getOverflow() == 57 || regionBody.getOverflow() == 42;
                blockLevelEventProducer.regionOverflow(this, regionBody.getName(), page.getPageViewport().getPageNumberString(), n2, bl2, bl, regionBody.getLocator());
            }
        };
    }

    protected int handleSpanChange(LayoutContext layoutContext, int n) {
        this.needColumnBalancing = false;
        if (layoutContext.getNextSpan() != 0) {
            n = layoutContext.getNextSpan();
            boolean bl = this.needColumnBalancing = layoutContext.getNextSpan() == 5 && layoutContext.getDisableColumnBalancing() == 48;
        }
        if (this.needColumnBalancing) {
            AbstractBreaker.log.debug((Object)"Column balancing necessary for the next element list!!!");
        }
        return n;
    }

    protected int getNextBlockList(LayoutContext layoutContext, int n) {
        return this.getNextBlockList(layoutContext, n, (Position)null, (LayoutManager)null, (List)null);
    }

    protected int getNextBlockList(LayoutContext layoutContext, int n, Position position, LayoutManager layoutManager, List list) {
        if (!this.firstPart) {
            this.handleBreakTrait(n);
        }
        this.firstPart = false;
        this.pageBreakHandled = true;
        this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        return super.getNextBlockList(layoutContext, n, position, layoutManager, list);
    }

    private boolean containsFootnotes(List list, LayoutContext layoutContext) {
        boolean bl = false;
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ListElement listElement = (ListElement)listIterator.next();
                if (!(listElement instanceof KnuthBlockBox) || !((KnuthBlockBox)listElement).hasAnchors()) continue;
                bl = true;
                LayoutContext layoutContext2 = new LayoutContext(layoutContext);
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutContext2.setRefIPD(this.pslm.getCurrentPV().getRegionReference(58).getIPD());
                List list2 = ((KnuthBlockBox)listElement).getFootnoteBodyLMs();
                ListIterator listIterator2 = list2.listIterator();
                while (listIterator2.hasNext()) {
                    FootnoteBodyLayoutManager footnoteBodyLayoutManager = (FootnoteBodyLayoutManager)listIterator2.next();
                    footnoteBodyLayoutManager.setParent(this.childFLM);
                    footnoteBodyLayoutManager.initialize();
                    ((KnuthBlockBox)listElement).addElementList(footnoteBodyLayoutManager.getNextKnuthElements(layoutContext2, this.alignment));
                }
            }
        }
        return bl;
    }

    private void handleFootnoteSeparator() {
        StaticContent staticContent = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator");
        if (staticContent != null) {
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(58).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, staticContent, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
            this.footnoteSeparatorLength = MinOptMax.getInstance(this.separatorArea.getBPD());
        }
    }

    protected List getNextKnuthElements(LayoutContext layoutContext, int n) {
        List list = null;
        while (!this.childFLM.isFinished() && list == null) {
            list = this.childFLM.getNextKnuthElements(layoutContext, n);
        }
        if (this.containsFootnotes(list, layoutContext)) {
            this.handleFootnoteSeparator();
        }
        return list;
    }

    protected List getNextKnuthElements(LayoutContext layoutContext, int n, Position position, LayoutManager layoutManager) {
        List list = null;
        do {
            list = this.childFLM.getNextKnuthElements(layoutContext, n, position, layoutManager);
        } while (!this.childFLM.isFinished() && list == null);
        if (this.containsFootnotes(list, layoutContext)) {
            this.handleFootnoteSeparator();
        }
        return list;
    }

    protected int getCurrentDisplayAlign() {
        return this.pslm.getCurrentPage().getSimplePageMaster().getRegion(58).getDisplayAlign();
    }

    protected boolean hasMoreContent() {
        return !this.childFLM.isFinished();
    }

    protected void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        if (this.footnoteSeparatorLM != null) {
            StaticContent staticContent = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator");
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(58).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, staticContent, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
        }
        this.childFLM.addAreas(positionIterator, layoutContext);
    }

    protected void doPhase3(PageBreakingAlgorithm pageBreakingAlgorithm, int n, AbstractBreaker.BlockSequence blockSequence, AbstractBreaker.BlockSequence blockSequence2) {
        if (this.needColumnBalancing) {
            this.redoLayout(pageBreakingAlgorithm, n, blockSequence, blockSequence2);
            return;
        }
        boolean bl = this.pslm.getPageSequence().hasPagePositionLast();
        if (!this.hasMoreContent() && bl) {
            this.redoLayout(pageBreakingAlgorithm, n, blockSequence, blockSequence2);
            return;
        }
        this.addAreas(pageBreakingAlgorithm, n, blockSequence, blockSequence2);
    }

    private void redoLayout(PageBreakingAlgorithm pageBreakingAlgorithm, int n, AbstractBreaker.BlockSequence blockSequence, AbstractBreaker.BlockSequence blockSequence2) {
        boolean bl;
        PageBreakingAlgorithm pageBreakingAlgorithm2;
        int n2 = 0;
        int n3 = this.pageProvider.getStartingPartIndexForLastPage(n);
        if (n3 > 0) {
            this.addAreas(pageBreakingAlgorithm, n3, blockSequence, blockSequence2);
            AbstractBreaker.PageBreakPosition pageBreakPosition = pageBreakingAlgorithm.getPageBreaks().get(n3 - 1);
            n2 = pageBreakPosition.getLeafPos() + 1;
            if (n2 > 0) {
                this.handleBreakTrait(104);
            }
        }
        AbstractBreaker.log.debug((Object)("Restarting at " + n3 + ", new start position: " + n2));
        this.pageBreakHandled = true;
        int n4 = this.pslm.getCurrentPageNum();
        this.pageProvider.setStartOfNextElementList(n4, this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        blockSequence2.ignoreAtStart = n2;
        if (this.needColumnBalancing) {
            AbstractBreaker.log.debug((Object)"Column balancing now!!!");
            AbstractBreaker.log.debug((Object)"===================================================");
            pageBreakingAlgorithm2 = new BalancingColumnBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), this.alignment, 135, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), this.pslm.getCurrentPV().getBodyRegion().getColumnCount());
            AbstractBreaker.log.debug((Object)"===================================================");
        } else {
            BodyRegion bodyRegion = this.pageProvider.getPage(false, n4).getPageViewport().getBodyRegion();
            this.setLastPageIndex(n4);
            BodyRegion bodyRegion2 = this.pageProvider.getPage(false, n4).getPageViewport().getBodyRegion();
            bodyRegion2.getMainReference().setSpans(bodyRegion.getMainReference().getSpans());
            AbstractBreaker.log.debug((Object)"Last page handling now!!!");
            AbstractBreaker.log.debug((Object)"===================================================");
            pageBreakingAlgorithm2 = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), pageBreakingAlgorithm.getAlignment(), pageBreakingAlgorithm.getAlignmentLast(), this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), false, false);
            AbstractBreaker.log.debug((Object)"===================================================");
        }
        int n5 = pageBreakingAlgorithm2.findBreakingPoints(blockSequence2, n2, 1.0, true, 0);
        AbstractBreaker.log.debug((Object)("restart: optimalPageCount= " + n5 + " pageBreaks.size()= " + ((PageBreakingAlgorithm)pageBreakingAlgorithm2).getPageBreaks().size()));
        boolean bl2 = bl = n5 <= this.pslm.getCurrentPV().getBodyRegion().getMainReference().getCurrentSpan().getColumnCount();
        if (this.needColumnBalancing) {
            if (!bl) {
                AbstractBreaker.log.warn((Object)"Breaking algorithm produced more columns than are available.");
            }
        } else if (bl) {
            this.pslm.setCurrentPage(this.pageProvider.getPage(false, n4));
        } else {
            this.addAreas(pageBreakingAlgorithm, n3, n - n3, blockSequence, blockSequence2);
            this.setLastPageIndex(n4 + 1);
            this.pslm.setCurrentPage(this.pslm.makeNewPage(true));
            return;
        }
        this.addAreas(pageBreakingAlgorithm2, n5, blockSequence, blockSequence2);
    }

    private void setLastPageIndex(int n) {
        int n2 = this.pslm.getForcedLastPageNum(n);
        this.pageProvider.setLastPageIndex(n2);
    }

    protected void startPart(AbstractBreaker.BlockSequence blockSequence, int n) {
        AbstractBreaker.log.debug((Object)("startPart() breakClass=" + PageBreaker.getBreakClassName(n)));
        if (this.pslm.getCurrentPage() == null) {
            throw new IllegalStateException("curPage must not be null");
        }
        if (!this.pageBreakHandled) {
            if (!this.firstPart) {
                this.handleBreakTrait(n);
            }
            this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex(), this.spanAllActive);
        }
        this.pageBreakHandled = false;
        this.firstPart = false;
    }

    protected void handleEmptyContent() {
        this.pslm.getCurrentPV().getPage().fakeNonEmpty();
    }

    protected void finishPart(PageBreakingAlgorithm pageBreakingAlgorithm, AbstractBreaker.PageBreakPosition pageBreakPosition) {
        if (pageBreakPosition.footnoteFirstListIndex < pageBreakPosition.footnoteLastListIndex || pageBreakPosition.footnoteFirstElementIndex <= pageBreakPosition.footnoteLastElementIndex) {
            for (int i = pageBreakPosition.footnoteFirstListIndex; i <= pageBreakPosition.footnoteLastListIndex; ++i) {
                List<KnuthElement> list = pageBreakingAlgorithm.getFootnoteList(i);
                int n = i == pageBreakPosition.footnoteFirstListIndex ? pageBreakPosition.footnoteFirstElementIndex : 0;
                int n2 = i == pageBreakPosition.footnoteLastListIndex ? pageBreakPosition.footnoteLastElementIndex : list.size() - 1;
                SpaceResolver.performConditionalsNotification(list, n, n2, -1);
                LayoutContext layoutContext = new LayoutContext(0);
                AreaAdditionUtil.addAreas(null, new KnuthPossPosIter(list, n, n2 + 1), layoutContext);
            }
            Footnote footnote = this.pslm.getCurrentPV().getBodyRegion().getFootnote();
            int n = this.pslm.getCurrentPV().getBodyRegion().getBPD() - footnote.getBPD();
            if (this.separatorArea != null) {
                n -= this.separatorArea.getBPD();
            }
            footnote.setTop(n);
            footnote.setSeparator(this.separatorArea);
        }
        this.pslm.getCurrentPV().getCurrentSpan().notifyFlowsFinished();
    }

    protected LayoutManager getCurrentChildLM() {
        return this.childFLM;
    }

    protected void observeElementList(List list) {
        ElementListObserver.observe(list, "breaker", this.pslm.getFObj().getId());
    }

    private void handleBreakTrait(int n) {
        Page page = this.pslm.getCurrentPage();
        switch (n) {
            case 5: {
                page.getPageViewport().createSpan(true);
                this.spanAllActive = true;
                return;
            }
            case 95: {
                page.getPageViewport().createSpan(false);
                this.spanAllActive = false;
                return;
            }
            case -1: 
            case 9: 
            case 28: 
            case 104: {
                PageViewport pageViewport = page.getPageViewport();
                boolean bl = false;
                RegionBody regionBody = (RegionBody)page.getSimplePageMaster().getRegion(58);
                boolean bl2 = bl = regionBody.getColumnCount() > 1 && pageViewport.getCurrentSpan().getColumnCount() == 1;
                if (bl) {
                    log.trace((Object)"Forcing new page with span");
                    page = this.pslm.makeNewPage(false);
                    page.getPageViewport().createSpan(true);
                } else if (pageViewport.getCurrentSpan().hasMoreFlows()) {
                    log.trace((Object)"Moving to next flow");
                    pageViewport.getCurrentSpan().moveToNextFlow();
                } else {
                    log.trace((Object)"Making new page");
                    this.pslm.makeNewPage(false);
                }
                return;
            }
        }
        log.debug((Object)("handling break-before after page " + this.pslm.getCurrentPageNum() + " breakVal=" + PageBreaker.getBreakClassName(n)));
        if (this.needBlankPageBeforeNew(n)) {
            log.trace((Object)"Inserting blank page");
            this.pslm.makeNewPage(true);
        }
        if (this.needNewPage(n)) {
            log.trace((Object)"Making new page");
            this.pslm.makeNewPage(false);
        }
    }

    private boolean needBlankPageBeforeNew(int n) {
        if (n == 104 || this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            return false;
        }
        if (this.pslm.getCurrentPageNum() % 2 == 0) {
            return n == 44;
        }
        return n == 100;
    }

    private boolean needNewPage(int n) {
        if (this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            if (n == 104) {
                return false;
            }
            if (this.pslm.getCurrentPageNum() % 2 == 0) {
                return n == 100;
            }
            return n == 44;
        }
        return true;
    }
}

