/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public final class ElementListUtils {
    private ElementListUtils() {
    }

    public static boolean removeLegalBreaks(List list, MinOptMax minOptMax) {
        return ElementListUtils.removeLegalBreaks(list, minOptMax.getOpt());
    }

    public static boolean removeLegalBreaks(List list, int n) {
        return ElementListUtils.removeLegalBreaks(list, n, false);
    }

    public static boolean removeLegalBreaksFromEnd(List list, int n) {
        return ElementListUtils.removeLegalBreaks(list, n, true);
    }

    private static boolean removeLegalBreaks(List list, int n, boolean bl) {
        int n2 = 0;
        ListIterator<KnuthPenalty> listIterator = list.listIterator(bl ? list.size() : 0);
        while (bl ? listIterator.hasPrevious() : listIterator.hasNext()) {
            ListElement listElement;
            ListElement listElement2 = bl ? (ListElement)listIterator.previous() : (ListElement)listIterator.next();
            if (listElement2.isPenalty()) {
                listElement = (KnuthPenalty)listElement2;
                if (((KnuthPenalty)listElement).getPenalty() < 1000) {
                    listIterator.set(new KnuthPenalty(((KnuthElement)listElement).getWidth(), 1000, ((KnuthPenalty)listElement).isPenaltyFlagged(), listElement.getPosition(), ((KnuthElement)listElement).isAuxiliary()));
                }
            } else if (listElement2.isGlue()) {
                listElement = (KnuthGlue)listElement2;
                n2 += ((KnuthElement)listElement).getWidth();
                if (!bl) {
                    listIterator.previous();
                }
                listElement2 = (ListElement)listIterator.previous();
                listIterator.next();
                if (listElement2.isBox()) {
                    listIterator.add(new KnuthPenalty(0, 1000, false, null, false));
                }
                if (!bl) {
                    listIterator.next();
                }
            } else if (listElement2.isUnresolvedElement()) {
                if (listElement2 instanceof BreakElement) {
                    listElement = (BreakElement)listElement2;
                    if (((BreakElement)listElement).getPenaltyValue() < 1000) {
                        ((BreakElement)listElement).setPenaltyValue(1000);
                    }
                } else if (listElement2 instanceof UnresolvedListElementWithLength) {
                    listElement = (UnresolvedListElementWithLength)listElement2;
                    n2 += ((UnresolvedListElementWithLength)listElement).getLength().getOpt();
                }
            } else {
                listElement = (KnuthElement)listElement2;
                n2 += ((KnuthElement)listElement).getWidth();
            }
            if (n2 < n) continue;
            return false;
        }
        return true;
    }

    public static int calcContentLength(List list, int n, int n2) {
        ListIterator listIterator = list.listIterator(n);
        int n3 = n2 - n + 1;
        int n4 = 0;
        while (listIterator.hasNext()) {
            ListElement listElement = (ListElement)listIterator.next();
            if (listElement.isBox()) {
                n4 += ((KnuthElement)listElement).getWidth();
            } else if (listElement.isGlue()) {
                n4 += ((KnuthElement)listElement).getWidth();
            }
            if (--n3 != 0) continue;
            break;
        }
        return n4;
    }

    public static int calcContentLength(List list) {
        return ElementListUtils.calcContentLength(list, 0, list.size() - 1);
    }

    public static boolean endsWithForcedBreak(List list) {
        return ((ListElement)ListUtil.getLast(list)).isForcedBreak();
    }

    public static boolean startsWithForcedBreak(List list) {
        return !list.isEmpty() && ((ListElement)list.get(0)).isForcedBreak();
    }

    public static boolean endsWithNonInfinitePenalty(List list) {
        ListElement listElement = (ListElement)ListUtil.getLast(list);
        if (listElement.isPenalty() && ((KnuthPenalty)listElement).getPenalty() < 1000) {
            return true;
        }
        return listElement instanceof BreakElement && ((BreakElement)listElement).getPenaltyValue() < 1000;
    }

    public static int determinePreviousBreak(List list, int n) {
        KnuthElement knuthElement;
        int n2;
        for (n2 = n - 1; !(n2 < 0 || (knuthElement = (KnuthElement)list.get(n2)).isPenalty() && knuthElement.getPenalty() < 1000); --n2) {
        }
        return n2;
    }
}

