/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.UnresolvedListElement;

public class BreakElement
extends UnresolvedListElement {
    private int penaltyWidth;
    private int penaltyValue;
    private int breakClass = -1;
    private List pendingBeforeMarks;
    private List pendingAfterMarks;

    public BreakElement(Position position, int n, LayoutContext layoutContext) {
        this(position, n, -1, layoutContext);
    }

    public BreakElement(Position position, int n, int n2, LayoutContext layoutContext) {
        this(position, 0, n, n2, layoutContext);
    }

    public BreakElement(Position position, int n, int n2, int n3, LayoutContext layoutContext) {
        super(position);
        this.penaltyWidth = n;
        this.penaltyValue = n2;
        this.breakClass = n3;
        this.pendingBeforeMarks = layoutContext.getPendingBeforeMarks();
        this.pendingAfterMarks = layoutContext.getPendingAfterMarks();
    }

    private static String getBreakClassName(int n) {
        return AbstractBreaker.getBreakClassName(n);
    }

    public boolean isConditional() {
        return false;
    }

    public int getPenaltyWidth() {
        return this.penaltyWidth;
    }

    public int getPenaltyValue() {
        return this.penaltyValue;
    }

    public void setPenaltyValue(int n) {
        this.penaltyValue = n;
    }

    public boolean isForcedBreak() {
        return this.penaltyValue == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public void setBreakClass(int n) {
        this.breakClass = n;
    }

    public List getPendingBeforeMarks() {
        return this.pendingBeforeMarks;
    }

    public List getPendingAfterMarks() {
        return this.pendingAfterMarks;
    }

    public void clearPendingMarks() {
        this.pendingBeforeMarks = null;
        this.pendingAfterMarks = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("BreakPossibility[p:");
        stringBuffer.append(KnuthPenalty.valueOf(this.penaltyValue));
        if (this.isForcedBreak()) {
            stringBuffer.append(" (forced break, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        } else if (this.penaltyValue >= 0 && this.breakClass != -1) {
            stringBuffer.append(" (keep constraint, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        }
        stringBuffer.append("; w:");
        stringBuffer.append(this.penaltyWidth);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

