/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BorderElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PaddingElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockStackingLayoutManager
extends AbstractLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog(BlockStackingLayoutManager.class);
    protected BlockParent parentArea;
    protected int bpUnit;
    protected int adjustedSpaceBefore;
    protected int adjustedSpaceAfter;
    protected List<KnuthElement> storedList;
    protected boolean breakBeforeServed;
    protected boolean firstVisibleMarkServed;
    protected int referenceIPD;
    protected int startIndent;
    protected int endIndent;
    protected MinOptMax foSpaceBefore;
    protected MinOptMax foSpaceAfter;
    private Position auxiliaryPosition;
    private int contentAreaIPD;

    public BlockStackingLayoutManager(FObj fObj) {
        super(fObj);
        this.setGeneratesBlockArea(true);
    }

    protected BlockParent getCurrentArea() {
        return this.parentArea;
    }

    protected void setCurrentArea(BlockParent blockParent) {
        this.parentArea = blockParent;
    }

    public void addBlockSpacing(double d, MinOptMax minOptMax) {
        int n = TraitSetter.getEffectiveSpace(d, minOptMax);
        if (n != 0) {
            Block block = new Block();
            block.setBPD(n);
            this.parentLayoutManager.addChildArea(block);
        }
    }

    protected void addChildToArea(Area area, BlockParent blockParent) {
        if (!(area instanceof Block)) {
            // empty if block
        }
        blockParent.addBlock((Block)area);
        this.flush();
    }

    @Override
    public void addChildArea(Area area) {
        this.addChildToArea(area, this.getCurrentArea());
    }

    protected void flush() {
        if (this.getCurrentArea() != null) {
            this.parentLayoutManager.addChildArea(this.getCurrentArea());
        }
    }

    protected Position getAuxiliaryPosition() {
        if (this.auxiliaryPosition == null) {
            this.auxiliaryPosition = new NonLeafPosition((LayoutManager)this, null);
        }
        return this.auxiliaryPosition;
    }

    protected int neededUnits(int n) {
        return (int)Math.ceil((float)n / (float)this.bpUnit);
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust() {
        int n = this.referenceIPD - (this.startIndent + this.endIndent);
        if (n < 0) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            blockLevelEventProducer.overconstrainedAdjustEndIndent(this, this.getFObj().getName(), n, this.getFObj().getLocator());
            this.endIndent += n;
            n = 0;
        }
        this.setContentAreaIPD(n);
        return n;
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust(int n) {
        int n2 = this.referenceIPD - (n + (this.startIndent + this.endIndent));
        if (n2 < 0) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            blockLevelEventProducer.overconstrainedAdjustEndIndent(this, this.getFObj().getName(), n2, this.getFObj().getLocator());
            this.endIndent += n2;
        }
        this.setContentAreaIPD(n);
        return n;
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        return this.getNextKnuthElements(layoutContext, n, null, null, null);
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n, Stack stack, Position position, LayoutManager layoutManager) {
        LayoutManager layoutManager2;
        this.referenceIPD = layoutContext.getRefIPD();
        this.updateContentAreaIPDwithOverconstrainedAdjust();
        boolean bl = stack != null;
        boolean bl2 = !bl || stack.isEmpty();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList2)) {
            return linkedList2;
        }
        this.addFirstVisibleMarks(linkedList2, layoutContext, n);
        BreakElement breakElement = null;
        if (bl) {
            if (bl2) {
                assert (layoutManager != null && layoutManager.getParent() == this);
                layoutManager2 = layoutManager;
            } else {
                layoutManager2 = (LayoutManager)stack.pop();
            }
            this.setCurrentChildLM(layoutManager2);
        } else {
            layoutManager2 = this.getChildLM();
        }
        while (layoutManager2 != null) {
            List<ListElement> list;
            LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
            if (!bl || bl2) {
                if (bl) {
                    layoutManager2.reset();
                }
                list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n, null, null, null);
            } else {
                list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n, stack, position, layoutManager);
                bl2 = true;
            }
            if (linkedList.isEmpty()) {
                layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
            }
            if (list != null && !list.isEmpty()) {
                if (!linkedList.isEmpty() && !ElementListUtils.startsWithForcedBreak(list)) {
                    this.addInBetweenBreak(linkedList, layoutContext, layoutContext2);
                }
                if (list.size() == 1 && ElementListUtils.startsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        breakElement = (BreakElement)list.get(0);
                        layoutContext.clearPendingMarks();
                        break;
                    }
                    if (linkedList.isEmpty()) {
                        linkedList2.add(this.makeAuxiliaryZeroWidthBox());
                    }
                    linkedList.addAll(list);
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                linkedList.addAll(list);
                if (ElementListUtils.endsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        breakElement = (BreakElement)ListUtil.removeLast(linkedList);
                        layoutContext.clearPendingMarks();
                        break;
                    }
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
            }
            layoutManager2 = this.getChildLM();
        }
        if (linkedList.isEmpty()) {
            if (breakElement == null) {
                linkedList2.add(this.makeAuxiliaryZeroWidthBox());
            }
        } else {
            this.wrapPositionElements(linkedList, linkedList2);
        }
        this.addLastVisibleMarks(linkedList2, layoutContext, n);
        if (breakElement == null) {
            this.addKnuthElementsForBreakAfter(linkedList2, layoutContext);
        } else {
            breakElement.clearPendingMarks();
            linkedList2.add(breakElement);
        }
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        this.setFinished(true);
        return linkedList2;
    }

    protected LayoutContext makeChildLayoutContext(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.copyPendingMarksFrom(layoutContext);
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
        layoutContext2.setRefIPD(this.referenceIPD);
        return layoutContext2;
    }

    protected void addFirstVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n) {
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(list, n);
            layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        }
        this.addKnuthElementsForBorderPaddingBefore(list, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(layoutContext);
    }

    protected void addLastVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n) {
        this.addKnuthElementsForBorderPaddingAfter(list, true);
        this.addKnuthElementsForSpaceAfter(list, n);
        layoutContext.clearPendingMarks();
    }

    protected boolean breakBeforeServed(LayoutContext layoutContext, List<ListElement> list) {
        if (!this.breakBeforeServed) {
            this.breakBeforeServed = true;
            if (!layoutContext.suppressBreakBefore() && this.addKnuthElementsForBreakBefore(list, layoutContext)) {
                return false;
            }
        }
        return this.breakBeforeServed;
    }

    private KnuthBox makeZeroWidthBox() {
        return new KnuthBox(0, new NonLeafPosition((LayoutManager)this, null), false);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthBox(0, this.notifyPos(new Position(this)), true);
    }

    private KnuthPenalty makeZeroWidthPenalty(int n) {
        return new KnuthPenalty(0, n, false, new NonLeafPosition((LayoutManager)this, null), false);
    }

    private KnuthGlue makeSpaceAdjustmentGlue(int n, Adjustment adjustment, boolean bl) {
        return new KnuthGlue(n, 0, 0, adjustment, new NonLeafPosition((LayoutManager)this, null), bl);
    }

    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n, Stack<LayoutManager> stack, Position position, LayoutManager layoutManager2) {
        if (layoutManager == this.childLMs.get(0)) {
            layoutContext2.setFlags(16);
        }
        if (stack == null) {
            return layoutManager.getNextKnuthElements(layoutContext2, n);
        }
        return layoutManager.getNextKnuthElements(layoutContext2, n, stack, position, layoutManager2);
    }

    protected void addInBetweenBreak(List<ListElement> list, LayoutContext layoutContext, LayoutContext layoutContext2) {
        if (this.mustKeepTogether() || layoutContext.isKeepWithNextPending() || layoutContext2.isKeepWithPreviousPending()) {
            Keep keep = this.getKeepTogether();
            keep = keep.compare(layoutContext.getKeepWithNextPending());
            layoutContext.clearKeepWithNextPending();
            keep = keep.compare(layoutContext2.getKeepWithPreviousPending());
            layoutContext2.clearKeepWithPreviousPending();
            list.add(new BreakElement(new Position(this), keep.getPenalty(), keep.getContext(), layoutContext));
            return;
        }
        ListElement listElement = ListUtil.getLast(list);
        if (listElement.isGlue()) {
            log.warn((Object)"glue-type break possibility not handled properly, yet");
        } else if (!ElementListUtils.endsWithNonInfinitePenalty(list)) {
            list.add(new BreakElement(new Position(this), 0, 9, layoutContext));
        }
    }

    @Override
    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        assert (knuthElement != null && knuthElement.getPosition() != null);
        Position position = knuthElement.getPosition().getPosition();
        if (position == null && knuthElement.isGlue()) {
            if (((KnuthGlue)knuthElement).getAdjustmentClass() == Adjustment.SPACE_BEFORE_ADJUSTMENT) {
                this.adjustedSpaceBefore += n;
            } else {
                this.adjustedSpaceAfter += n;
            }
            return n;
        }
        if (position instanceof MappingPosition) {
            MappingPosition mappingPosition = (MappingPosition)position;
            if (knuthElement.isGlue()) {
                ListIterator<KnuthElement> listIterator = this.storedList.listIterator(mappingPosition.getFirstIndex());
                int n2 = 0;
                while (listIterator.nextIndex() <= mappingPosition.getLastIndex()) {
                    KnuthElement knuthElement2 = listIterator.next();
                    if (!knuthElement2.isGlue()) continue;
                    n2 += ((BlockLevelLayoutManager)knuthElement2.getLayoutManager()).negotiateBPDAdjustment(n - n2, knuthElement2);
                }
                n2 = n2 > 0 ? this.bpUnit * this.neededUnits(n2) : -this.bpUnit * this.neededUnits(-n2);
                return n2;
            }
            KnuthPenalty knuthPenalty = (KnuthPenalty)this.storedList.get(mappingPosition.getLastIndex());
            if (knuthPenalty.getWidth() > 0) {
                return ((BlockLevelLayoutManager)knuthPenalty.getLayoutManager()).negotiateBPDAdjustment(knuthPenalty.getWidth(), knuthPenalty);
            }
            return n;
        }
        if (position != null && position.getLM() != this) {
            NonLeafPosition nonLeafPosition = (NonLeafPosition)knuthElement.getPosition();
            knuthElement.setPosition(position);
            int n3 = ((BlockLevelLayoutManager)knuthElement.getLayoutManager()).negotiateBPDAdjustment(n, knuthElement);
            knuthElement.setPosition(nonLeafPosition);
            return n3;
        }
        log.error((Object)"BlockLayoutManager.negotiateBPDAdjustment(): unexpected Position");
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue knuthGlue) {
        assert (knuthGlue != null && knuthGlue.getPosition() != null);
        Position position = knuthGlue.getPosition().getPosition();
        if (position == null || position.getLM() == this) {
            if (knuthGlue.getAdjustmentClass() == Adjustment.SPACE_BEFORE_ADJUSTMENT) {
                this.adjustedSpaceBefore = 0;
                this.foSpaceBefore = MinOptMax.ZERO;
            } else {
                this.adjustedSpaceAfter = 0;
                this.foSpaceAfter = MinOptMax.ZERO;
            }
        } else {
            NonLeafPosition nonLeafPosition = (NonLeafPosition)knuthGlue.getPosition();
            knuthGlue.setPosition(position);
            ((BlockLevelLayoutManager)knuthGlue.getLayoutManager()).discardSpace(knuthGlue);
            knuthGlue.setPosition(nonLeafPosition);
        }
    }

    @Override
    public List getChangedKnuthElements(List list, int n) {
        LayoutManager layoutManager;
        Object object;
        ListIterator listIterator = list.listIterator();
        KnuthElement knuthElement = null;
        ListElement listElement = null;
        LinkedList<KnuthPenalty> linkedList = new LinkedList<KnuthPenalty>();
        LinkedList<KnuthElement> linkedList2 = new LinkedList<KnuthElement>();
        int n2 = 0;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement2 = (KnuthElement)listIterator.next();
            assert (knuthElement2.getPosition() != null);
            object = knuthElement2.getPosition().getPosition();
            if (object != null) {
                knuthElement2.setPosition((Position)object);
                continue;
            }
            knuthElement2.setPosition(new Position(this));
        }
        object = list.listIterator();
        while (object.hasNext()) {
            knuthElement = (KnuthElement)object.next();
            if (listElement != null && listElement.getLayoutManager() != knuthElement.getLayoutManager()) {
                layoutManager = (BlockLevelLayoutManager)listElement.getLayoutManager();
                BlockLevelLayoutManager blockLevelLayoutManager = (BlockLevelLayoutManager)knuthElement.getLayoutManager();
                boolean bl = false;
                if (layoutManager != this) {
                    linkedList.addAll(layoutManager.getChangedKnuthElements(list.subList(n2, object.previousIndex()), n));
                    bl = true;
                }
                n2 = object.previousIndex();
                if (bl && (this.mustKeepTogether() || layoutManager.mustKeepWithNext() || blockLevelLayoutManager.mustKeepWithPrevious())) {
                    linkedList.add(this.makeZeroWidthPenalty(1000));
                } else if (bl && !((KnuthElement)ListUtil.getLast(linkedList)).isGlue()) {
                    linkedList.add(this.makeZeroWidthPenalty(1000));
                }
            }
            listElement = knuthElement;
        }
        if (knuthElement != null) {
            layoutManager = knuthElement.getLayoutManager();
            if (layoutManager != this) {
                linkedList.addAll(layoutManager.getChangedKnuthElements(list.subList(n2, list.size()), n));
            } else if (!linkedList.isEmpty()) {
                ListUtil.removeLast(linkedList);
            }
        }
        boolean bl = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            bl = this.getSpaceBeforeProperty().isDiscard();
        }
        if (this.adjustedSpaceBefore != 0) {
            if (!bl) {
                linkedList2.add(this.makeZeroWidthBox());
                linkedList2.add(this.makeZeroWidthPenalty(1000));
            }
            linkedList2.add(this.makeSpaceAdjustmentGlue(this.adjustedSpaceBefore, Adjustment.SPACE_BEFORE_ADJUSTMENT, false));
        }
        for (KnuthElement knuthElement3 : linkedList) {
            knuthElement3.setPosition(new NonLeafPosition((LayoutManager)this, knuthElement3.getPosition()));
            linkedList2.add(knuthElement3);
        }
        boolean bl2 = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            bl2 = this.getSpaceAfterProperty().isDiscard();
        }
        if (this.adjustedSpaceAfter != 0) {
            if (!bl2) {
                linkedList2.add(this.makeZeroWidthPenalty(1000));
            }
            linkedList2.add(this.makeSpaceAdjustmentGlue(this.adjustedSpaceAfter, Adjustment.SPACE_AFTER_ADJUSTMENT, bl2));
            if (!bl2) {
                linkedList2.add(this.makeZeroWidthBox());
            }
        }
        return linkedList2;
    }

    protected Keep getParentKeepTogether() {
        Keep keep = Keep.KEEP_AUTO;
        if (this.getParent() instanceof BlockLevelLayoutManager) {
            keep = ((BlockLevelLayoutManager)this.getParent()).getKeepTogether();
        } else if (this.getParent() instanceof InlineLayoutManager && ((InlineLayoutManager)this.getParent()).mustKeepTogether()) {
            keep = Keep.KEEP_ALWAYS;
        }
        return keep;
    }

    @Override
    public boolean mustKeepTogether() {
        return !this.getKeepTogether().isAuto();
    }

    @Override
    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().isAuto();
    }

    @Override
    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().isAuto();
    }

    @Override
    public Keep getKeepTogether() {
        Keep keep = Keep.getKeep(this.getKeepTogetherProperty());
        keep = keep.compare(this.getParentKeepTogether());
        return keep;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.getKeep(this.getKeepWithPreviousProperty());
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.getKeep(this.getKeepWithNextProperty());
    }

    @Override
    public KeepProperty getKeepTogetherProperty() {
        throw new IllegalStateException();
    }

    @Override
    public KeepProperty getKeepWithPreviousProperty() {
        throw new IllegalStateException();
    }

    @Override
    public KeepProperty getKeepWithNextProperty() {
        throw new IllegalStateException();
    }

    protected void addPendingMarks(LayoutContext layoutContext) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getBorderBeforeWidth(false) > 0) {
                layoutContext.addPendingBeforeMark(new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(0).getWidth(), RelSide.BEFORE, false, false, this));
            }
            if (commonBorderPaddingBackground.getPaddingBefore(false, this) > 0) {
                layoutContext.addPendingBeforeMark(new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(0), RelSide.BEFORE, false, false, this));
            }
            if (commonBorderPaddingBackground.getBorderAfterWidth(false) > 0) {
                layoutContext.addPendingAfterMark(new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(1).getWidth(), RelSide.AFTER, false, false, this));
            }
            if (commonBorderPaddingBackground.getPaddingAfter(false, this) > 0) {
                layoutContext.addPendingAfterMark(new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(1), RelSide.AFTER, false, false, this));
            }
        }
    }

    private CommonBorderPaddingBackground getBorderPaddingBackground() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonBorderPaddingBackground();
        }
        return null;
    }

    protected SpaceProperty getSpaceBeforeProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        return null;
    }

    protected SpaceProperty getSpaceAfterProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        return null;
    }

    protected void addKnuthElementsForBorderPaddingBefore(List list, boolean bl) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getBorderBeforeWidth(false) > 0) {
                list.add(new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(0).getWidth(), RelSide.BEFORE, bl, false, this));
            }
            if (commonBorderPaddingBackground.getPaddingBefore(false, this) > 0) {
                list.add(new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(0), RelSide.BEFORE, bl, false, this));
            }
        }
    }

    protected void addKnuthElementsForBorderPaddingAfter(List list, boolean bl) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getPaddingAfter(false, this) > 0) {
                list.add(new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(1), RelSide.AFTER, false, bl, this));
            }
            if (commonBorderPaddingBackground.getBorderAfterWidth(false) > 0) {
                list.add(new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(1).getWidth(), RelSide.AFTER, false, bl, this));
            }
        }
    }

    protected boolean addKnuthElementsForBreakBefore(List list, LayoutContext layoutContext) {
        int n = BreakOpportunityHelper.getBreakBefore(this);
        if (n == 104 || n == 28 || n == 44 || n == 100) {
            list.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n, layoutContext));
            return true;
        }
        return false;
    }

    protected boolean addKnuthElementsForBreakAfter(List list, LayoutContext layoutContext) {
        int n = -1;
        if (this.fobj instanceof BreakPropertySet) {
            n = ((BreakPropertySet)((Object)this.fobj)).getBreakAfter();
        }
        if (n == 104 || n == 28 || n == 44 || n == 100) {
            list.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n, layoutContext));
            return true;
        }
        return false;
    }

    protected void addKnuthElementsForSpaceBefore(List list, int n) {
        SpaceProperty spaceProperty = this.getSpaceBeforeProperty();
        if (spaceProperty != null && (spaceProperty.getMinimum(this).getLength().getValue(this) != 0 || spaceProperty.getMaximum(this).getLength().getValue(this) != 0)) {
            list.add(new SpaceElement(this.getAuxiliaryPosition(), spaceProperty, RelSide.BEFORE, true, false, this));
        }
    }

    protected void addKnuthElementsForSpaceAfter(List list, int n) {
        SpaceProperty spaceProperty = this.getSpaceAfterProperty();
        if (spaceProperty != null && (spaceProperty.getMinimum(this).getLength().getValue(this) != 0 || spaceProperty.getMaximum(this).getLength().getValue(this) != 0)) {
            list.add(new SpaceElement(this.getAuxiliaryPosition(), spaceProperty, RelSide.AFTER, false, true, this));
        }
    }

    protected void wrapPositionElements(List list, List list2) {
        this.wrapPositionElements(list, list2, false);
    }

    protected void wrapPositionElements(List list, List list2, boolean bl) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e instanceof ListElement) {
                this.wrapPositionElement((ListElement)e, list2, bl);
                continue;
            }
            if (!(e instanceof List)) continue;
            this.wrapPositionElements((List)e, list2, bl);
        }
    }

    protected void wrapPositionElement(ListElement listElement, List list, boolean bl) {
        if (bl || listElement.getLayoutManager() != this) {
            listElement.setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, listElement.getPosition())));
        }
        list.add(listElement);
    }

    protected int getIPIndents() {
        return this.startIndent + this.endIndent;
    }

    @Override
    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    protected void setContentAreaIPD(int n) {
        this.contentAreaIPD = n;
    }

    @Override
    public int getContentAreaBPD() {
        return -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.breakBeforeServed = false;
        this.firstVisibleMarkServed = false;
    }

    public boolean handleOverflow(int n) {
        if (this.getParent() instanceof BlockStackingLayoutManager) {
            return ((BlockStackingLayoutManager)this.getParent()).handleOverflow(n);
        }
        return false;
    }

    protected static class MappingPosition
    extends Position {
        private int firstIndex;
        private int lastIndex;

        public MappingPosition(LayoutManager layoutManager, int n, int n2) {
            super(layoutManager);
            this.firstIndex = n;
            this.lastIndex = n2;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }
    }
}

