/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.IDTracker;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.TopLevelLayoutManager;

public abstract class AbstractPageSequenceLayoutManager
extends AbstractLayoutManager
implements TopLevelLayoutManager {
    private static Log log = LogFactory.getLog(AbstractPageSequenceLayoutManager.class);
    protected AreaTreeHandler areaTreeHandler;
    protected IDTracker idTracker;
    protected AbstractPageSequence pageSeq;
    protected Page curPage;
    protected int currentPageNum = 0;
    protected int startPageNum = 0;

    public AbstractPageSequenceLayoutManager(AreaTreeHandler areaTreeHandler, AbstractPageSequence abstractPageSequence) {
        super(abstractPageSequence);
        this.areaTreeHandler = areaTreeHandler;
        this.idTracker = areaTreeHandler.getIDTracker();
        this.pageSeq = abstractPageSequence;
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.areaTreeHandler.getLayoutManagerMaker();
    }

    public Page getCurrentPage() {
        return this.curPage;
    }

    protected void setCurrentPage(Page page) {
        this.curPage = page;
    }

    protected int getCurrentPageNum() {
        return this.currentPageNum;
    }

    public void initialize() {
        this.startPageNum = this.pageSeq.getStartingPageNumber();
        this.currentPageNum = this.startPageNum - 1;
    }

    public PageViewport getFirstPVWithID(String string) {
        List<PageViewport> list = this.idTracker.getPageViewportsContainingID(string);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public PageViewport getLastPVWithID(String string) {
        List<PageViewport> list = this.idTracker.getPageViewportsContainingID(string);
        if (list != null && list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void addIDToPage(String string) {
        if (string != null && string.length() > 0) {
            this.idTracker.associateIDWithPageViewport(string, this.curPage.getPageViewport());
        }
    }

    public boolean associateLayoutManagerID(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("associateLayoutManagerID(" + string + ")"));
        }
        if (!this.idTracker.alreadyResolvedID(string)) {
            this.idTracker.signalPendingID(string);
            return false;
        }
        return true;
    }

    public void notifyEndOfLayout(String string) {
        this.idTracker.signalIDProcessed(string);
    }

    public void addUnresolvedArea(String string, Resolvable resolvable) {
        this.curPage.getPageViewport().addUnresolvedIDRef(string, resolvable);
        this.idTracker.addUnresolvedIDRef(string, this.curPage.getPageViewport());
    }

    public RetrieveMarker resolveRetrieveMarker(RetrieveMarker retrieveMarker) {
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        String string = retrieveMarker.getRetrieveClassName();
        int n = retrieveMarker.getRetrievePosition();
        int n2 = retrieveMarker.getRetrieveBoundary();
        Marker marker = this.getCurrentPV().getMarker(string, n);
        if (marker == null && n2 != 104) {
            PageViewport pageViewport;
            boolean bl = n2 == 34;
            int n3 = areaTreeModel.getPageSequenceCount();
            int n4 = areaTreeModel.getPageCount(n3) - 1;
            while (n4 < 0 && bl && n3 > 1) {
                n4 = areaTreeModel.getPageCount(--n3) - 1;
            }
            while (n4 >= 0 && (marker = (pageViewport = areaTreeModel.getPage(n3, n4)).getMarker(string, 74)) == null) {
                if (--n4 >= 0 || !bl || n3 <= 1) continue;
                n4 = areaTreeModel.getPageCount(--n3) - 1;
            }
        }
        if (marker == null) {
            log.debug((Object)("found no marker with name: " + string));
            return null;
        }
        retrieveMarker.bindMarker(marker);
        return retrieveMarker;
    }

    protected abstract Page createPage(int var1, boolean var2);

    protected Page makeNewPage(boolean bl) {
        if (this.curPage != null) {
            this.finishPage();
        }
        ++this.currentPageNum;
        this.curPage = this.createPage(this.currentPageNum, bl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.curPage.getPageViewport().getPageNumberString() + (bl ? "*" : "") + "]"));
        }
        this.addIDToPage(this.pageSeq.getRoot().getId());
        this.addIDToPage(this.pageSeq.getId());
        return this.curPage;
    }

    protected void finishPage() {
        if (log.isTraceEnabled()) {
            this.curPage.getPageViewport().dumpMarkers();
        }
        this.idTracker.tryIDResolution(this.curPage.getPageViewport());
        this.areaTreeHandler.getAreaTreeModel().addPage(this.curPage.getPageViewport());
        if (log.isDebugEnabled()) {
            log.debug((Object)("page finished: " + this.curPage.getPageViewport().getPageNumberString() + ", current num: " + this.currentPageNum));
        }
        this.curPage = null;
    }

    public void doForcePageCount(Numeric numeric) {
        int n = this.pageSeq.getForcePageCount();
        if (numeric != null && n == 9) {
            if (numeric.getEnum() != 0) {
                int n2 = numeric.getEnum();
                n = n2 == 11 ? 40 : (n2 == 10 ? 41 : 88);
            } else {
                int n3 = numeric.getValue();
                n3 = n3 > 0 ? n3 : 1;
                n = n3 % 2 == 0 ? 41 : 40;
            }
        }
        if (n == 43) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 != 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (n == 99) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 == 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (n == 40) {
            if (this.currentPageNum % 2 != 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (n == 41) {
            if (this.currentPageNum % 2 == 0) {
                this.curPage = this.makeNewPage(true);
            }
        } else if (n == 88) {
            // empty if block
        }
        if (this.curPage != null) {
            this.finishPage();
        }
    }

    public void reset() {
        throw new IllegalStateException();
    }
}

