/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.io.IOException;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.XMLNamespaceEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;

public class ImageLoaderSVG
extends AbstractImageLoader {
    private ImageFlavor targetFlavor;

    public ImageLoaderSVG(ImageFlavor imageFlavor) {
        if (!XMLNamespaceEnabledImageFlavor.SVG_DOM.isCompatible(imageFlavor)) {
            throw new IllegalArgumentException("Incompatible target ImageFlavor: " + imageFlavor);
        }
        this.targetFlavor = imageFlavor;
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        if (!"image/svg+xml".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from an SVG image");
        }
        Image image = imageInfo.getOriginalImage();
        if (!(image instanceof ImageXMLDOM)) {
            throw new IllegalArgumentException("ImageInfo was expected to contain the SVG document as DOM");
        }
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        if (!"http://www.w3.org/2000/svg".equals(imageXMLDOM.getRootNamespace())) {
            throw new IllegalArgumentException("The Image is not in the SVG namespace: " + imageXMLDOM.getRootNamespace());
        }
        return imageXMLDOM;
    }
}

