/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMParser;
import org.apache.fop.fonts.type1.AdobeStandardEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CharMetricsHandler {
    private static final Log LOG = LogFactory.getLog(CharMetricsHandler.class);
    private static final String WHITE_SPACE = "\\s*";
    private static final String OPERATOR = "([A-Z0-9]{1,3})";
    private static final String OPERANDS = "(.*)";
    private static final Pattern METRICS_REGEX = Pattern.compile("\\s*([A-Z0-9]{1,3})\\s*(.*)\\s*");
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\s*;\\s*");

    private CharMetricsHandler() {
    }

    abstract AFMCharMetrics parse(String var1, Stack<Object> var2, String var3) throws IOException;

    static CharMetricsHandler getHandler(Map<String, AFMParser.ValueHandler> map, String string) {
        if (string != null && string.contains("AdobeStandardEncoding")) {
            return new AdobeStandardCharMetricsHandler(map);
        }
        return new DefaultCharMetricsHandler(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdobeStandardCharMetricsHandler
    extends CharMetricsHandler {
        private final DefaultCharMetricsHandler defaultHandler;

        private AdobeStandardCharMetricsHandler(Map<String, AFMParser.ValueHandler> map) {
            this.defaultHandler = new DefaultCharMetricsHandler(map);
        }

        @Override
        AFMCharMetrics parse(String string, Stack<Object> stack, String string2) throws IOException {
            AFMCharMetrics aFMCharMetrics = this.defaultHandler.parse(string, stack, string2);
            NamedCharacter namedCharacter = aFMCharMetrics.getCharacter();
            if (namedCharacter != null) {
                int n = AdobeStandardEncoding.getAdobeCodePoint(namedCharacter.getName());
                if (aFMCharMetrics.getCharCode() != n) {
                    LOG.info((Object)(string2 + ": named character '" + namedCharacter.getName() + "'" + " has an incorrect code point: " + aFMCharMetrics.getCharCode() + ". Changed to " + n));
                    aFMCharMetrics.setCharCode(n);
                }
            }
            return aFMCharMetrics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultCharMetricsHandler
    extends CharMetricsHandler {
        private final Map<String, AFMParser.ValueHandler> valueParsers;

        private DefaultCharMetricsHandler(Map<String, AFMParser.ValueHandler> map) {
            this.valueParsers = map;
        }

        @Override
        AFMCharMetrics parse(String string, Stack<Object> stack, String string2) throws IOException {
            String[] stringArray;
            AFMCharMetrics aFMCharMetrics = new AFMCharMetrics();
            stack.push(aFMCharMetrics);
            for (String string3 : stringArray = SPLIT_REGEX.split(string)) {
                Matcher matcher = METRICS_REGEX.matcher(string3);
                if (!matcher.matches()) continue;
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                AFMParser.ValueHandler valueHandler = this.valueParsers.get(string4);
                if (valueHandler == null) continue;
                valueHandler.parse(string5, 0, stack);
            }
            stack.pop();
            return aFMCharMetrics;
        }
    }
}

