/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.substitute.FontQualifier;
import org.apache.fop.fonts.substitute.FontSubstitution;
import org.apache.fop.fonts.substitute.FontSubstitutions;

public class FontSubstitutionsConfigurator {
    private Configuration cfg = null;

    public FontSubstitutionsConfigurator(Configuration configuration) {
        this.cfg = configuration;
    }

    private static FontQualifier getQualfierFromConfiguration(Configuration configuration) throws FOPException {
        String string;
        String string2 = configuration.getAttribute("font-family", null);
        if (string2 == null) {
            throw new FOPException("substitution qualifier must have a font-family");
        }
        FontQualifier fontQualifier = new FontQualifier();
        fontQualifier.setFontFamily(string2);
        String string3 = configuration.getAttribute("font-weight", null);
        if (string3 != null) {
            fontQualifier.setFontWeight(string3);
        }
        if ((string = configuration.getAttribute("font-style", null)) != null) {
            fontQualifier.setFontStyle(string);
        }
        return fontQualifier;
    }

    public void configure(FontSubstitutions fontSubstitutions) throws FOPException {
        Configuration[] configurationArray = this.cfg.getChildren("substitution");
        for (int i = 0; i < configurationArray.length; ++i) {
            Configuration configuration = configurationArray[i].getChild("from", false);
            if (configuration == null) {
                throw new FOPException("'substitution' element without child 'from' element");
            }
            Configuration configuration2 = configurationArray[i].getChild("to", false);
            if (configuration == null) {
                throw new FOPException("'substitution' element without child 'to' element");
            }
            FontQualifier fontQualifier = FontSubstitutionsConfigurator.getQualfierFromConfiguration(configuration);
            FontQualifier fontQualifier2 = FontSubstitutionsConfigurator.getQualfierFromConfiguration(configuration2);
            FontSubstitution fontSubstitution = new FontSubstitution(fontQualifier, fontQualifier2);
            fontSubstitutions.add(fontSubstitution);
        }
    }
}

