/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.CommandLineLogger;
import org.w3c.dom.Document;

public abstract class AbstractFontReader {
    protected static Log log;

    protected AbstractFontReader() {
        if (log == null) {
            log = LogFactory.getLog(AbstractFontReader.class);
        }
    }

    protected static String[] parseArguments(Map map, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                if ("-t".equals(stringArray[i]) || "-d".equals(stringArray[i]) || "-q".equals(stringArray[i])) {
                    map.put(stringArray[i], "");
                    continue;
                }
                if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    map.put(stringArray[i], stringArray[i + 1]);
                    ++i;
                    continue;
                }
                map.put(stringArray[i], "");
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    protected static void setLogLevel(String string) {
        LogFactory.getFactory().setAttribute("level", (Object)string);
        if (log instanceof CommandLineLogger) {
            ((CommandLineLogger)log).setLogLevel(string);
        }
    }

    protected static void determineLogLevel(Map map) {
        if (map.get("-t") != null) {
            AbstractFontReader.setLogLevel("trace");
        } else if (map.get("-d") != null) {
            AbstractFontReader.setLogLevel("debug");
        } else if (map.get("-q") != null) {
            AbstractFontReader.setLogLevel("error");
        } else {
            AbstractFontReader.setLogLevel("info");
        }
    }

    public void writeFontXML(Document document, String string) throws TransformerException {
        this.writeFontXML(document, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFontXML(Document document, File file) throws TransformerException {
        log.info((Object)("Writing xml font file " + file + "..."));
        try {
            OutputStream outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new TransformerException("Error writing the output file", iOException);
        }
    }
}

