/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontSubstitutions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManager {
    public static final boolean DEFAULT_USE_CACHE = true;
    private String fontBase = null;
    private FontCache fontCache = null;
    private FontSubstitutions fontSubstitutions = null;
    private boolean enableBase14Kerning = false;
    private FontTriplet.Matcher referencedFontsMatcher;
    private boolean useCache = true;
    private File cacheFile;

    public void setFontBaseURL(String string) throws MalformedURLException {
        this.fontBase = string;
    }

    public String getFontBaseURL() {
        return this.fontBase;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean bl) {
        this.enableBase14Kerning = bl;
    }

    public void setFontSubstitutions(FontSubstitutions fontSubstitutions) {
        this.fontSubstitutions = fontSubstitutions;
    }

    protected FontSubstitutions getFontSubstitutions() {
        if (this.fontSubstitutions == null) {
            this.fontSubstitutions = new FontSubstitutions();
        }
        return this.fontSubstitutions;
    }

    public void setCacheFile(File file) {
        this.cacheFile = file;
    }

    public File getCacheFile() {
        if (this.cacheFile != null) {
            return this.cacheFile;
        }
        return FontCache.getDefaultCacheFile(false);
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
        if (!bl) {
            this.fontCache = null;
        }
    }

    public boolean useCache() {
        return this.useCache;
    }

    public FontCache getFontCache() {
        if (this.fontCache == null && this.useCache) {
            this.fontCache = this.cacheFile != null ? FontCache.loadFrom(this.cacheFile) : FontCache.load();
            if (this.fontCache == null) {
                this.fontCache = new FontCache();
            }
        }
        return this.fontCache;
    }

    public void saveCache() throws FOPException {
        if (this.useCache && this.fontCache != null && this.fontCache.hasChanged()) {
            if (this.cacheFile != null) {
                this.fontCache.saveTo(this.cacheFile);
            } else {
                this.fontCache.save();
            }
        }
    }

    public boolean deleteCache() {
        boolean bl = false;
        if (this.useCache) {
            bl = this.cacheFile != null ? this.cacheFile.delete() : FontCache.getDefaultCacheFile(true).delete();
        }
        return bl;
    }

    public void setup(FontInfo fontInfo, FontCollection[] fontCollectionArray) {
        int n = 1;
        int n2 = fontCollectionArray.length;
        for (int i = 0; i < n2; ++i) {
            n = fontCollectionArray[i].setup(n, fontInfo);
        }
        this.getFontSubstitutions().adjustFontInfo(fontInfo);
    }

    public static FontResolver createMinimalFontResolver(boolean bl) {
        return new MinimalFontResolver(bl);
    }

    public void setReferencedFontsMatcher(FontTriplet.Matcher matcher) {
        this.referencedFontsMatcher = matcher;
    }

    public FontTriplet.Matcher getReferencedFontsMatcher() {
        return this.referencedFontsMatcher;
    }

    public void updateReferencedFonts(List<EmbedFontInfo> list) {
        FontTriplet.Matcher matcher = this.getReferencedFontsMatcher();
        this.updateReferencedFonts(list, matcher);
    }

    public void updateReferencedFonts(List<EmbedFontInfo> list, FontTriplet.Matcher matcher) {
        if (matcher == null) {
            return;
        }
        block0: for (EmbedFontInfo embedFontInfo : list) {
            for (FontTriplet fontTriplet : embedFontInfo.getFontTriplets()) {
                if (!matcher.matches(fontTriplet)) continue;
                embedFontInfo.setEmbedded(false);
                continue block0;
            }
        }
    }

    public static class MinimalFontResolver
    implements FontResolver {
        private boolean useComplexScriptFeatures;

        MinimalFontResolver(boolean bl) {
            this.useComplexScriptFeatures = bl;
        }

        public Source resolve(String string) {
            return new StreamSource(string);
        }

        public boolean isComplexScriptFeaturesEnabled() {
            return this.useComplexScriptFeatures;
        }
    }
}

