/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.List;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFontCollection
implements FontCollection {
    private FontResolver fontResolver;
    private final List<EmbedFontInfo> embedFontInfoList;

    public CustomFontCollection(FontResolver fontResolver, List<EmbedFontInfo> list, boolean bl) {
        this.fontResolver = fontResolver;
        if (this.fontResolver == null) {
            this.fontResolver = FontManager.createMinimalFontResolver(bl);
        }
        this.embedFontInfoList = list;
    }

    @Override
    public int setup(int n, FontInfo fontInfo) {
        if (this.embedFontInfoList == null) {
            return n;
        }
        String string = null;
        for (int i = 0; i < this.embedFontInfoList.size(); ++i) {
            EmbedFontInfo embedFontInfo = this.embedFontInfoList.get(i);
            string = "F" + n;
            ++n;
            LazyFont lazyFont = new LazyFont(embedFontInfo, this.fontResolver);
            fontInfo.addMetrics(string, lazyFont);
            List<FontTriplet> list = embedFontInfo.getFontTriplets();
            for (int j = 0; j < list.size(); ++j) {
                FontTriplet fontTriplet = list.get(j);
                fontInfo.addFontProperties(string, fontTriplet);
            }
        }
        return n;
    }
}

