/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MutableFont;
import org.apache.fop.fonts.Typeface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomFont
extends Typeface
implements FontDescriptor,
MutableFont {
    private String fontName = null;
    private String fullName = null;
    private Set<String> familyNames = null;
    private String fontSubName = null;
    private String embedFileName = null;
    private String embedResourceName = null;
    private FontResolver resolver = null;
    private EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    private int capHeight = 0;
    private int xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int[] fontBBox = new int[]{0, 0, 0, 0};
    private int flags = 4;
    private int weight = 0;
    private int stemV = 0;
    private int italicAngle = 0;
    private int missingWidth = 0;
    private FontType fontType = FontType.TYPE1;
    private int firstChar = 0;
    private int lastChar = 255;
    private Map<Integer, Map<Integer, Integer>> kerning;
    private boolean useKerning = true;
    private boolean useAdvanced = true;
    protected CMapSegment[] cmap;

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Set<String> getFamilyNames() {
        return Collections.unmodifiableSet(this.familyNames);
    }

    public String getStrippedFontName() {
        return FontUtil.stripWhiteSpace(this.getFontName());
    }

    public String getFontSubName() {
        return this.fontSubName;
    }

    public String getEmbedFileName() {
        return this.embedFileName;
    }

    public EmbeddingMode getEmbeddingMode() {
        return this.embeddingMode;
    }

    public Source getEmbedFileSource() throws IOException {
        Source source = null;
        if (this.resolver != null && this.embedFileName != null && (source = this.resolver.resolve(this.embedFileName)) == null) {
            throw new IOException("Unable to resolve Source '" + this.embedFileName + "' for embedded font");
        }
        return source;
    }

    public String getEmbedResourceName() {
        return this.embedResourceName;
    }

    @Override
    public int getAscender() {
        return this.ascender;
    }

    @Override
    public int getDescender() {
        return this.descender;
    }

    @Override
    public int getCapHeight() {
        return this.capHeight;
    }

    @Override
    public int getAscender(int n) {
        return n * this.ascender;
    }

    @Override
    public int getDescender(int n) {
        return n * this.descender;
    }

    @Override
    public int getCapHeight(int n) {
        return n * this.capHeight;
    }

    @Override
    public int getXHeight(int n) {
        return n * this.xHeight;
    }

    @Override
    public int[] getFontBBox() {
        return this.fontBBox;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isSymbolicFont() {
        return (this.getFlags() & 4) != 0 || "ZapfDingbatsEncoding".equals(this.getEncodingName());
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int getStemV() {
        return this.stemV;
    }

    @Override
    public int getItalicAngle() {
        return this.italicAngle;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    @Override
    public FontType getFontType() {
        return this.fontType;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public boolean isKerningEnabled() {
        return this.useKerning;
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.isKerningEnabled() && this.kerning != null && !this.kerning.isEmpty();
    }

    @Override
    public final Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        if (this.hasKerningInfo()) {
            return this.kerning;
        }
        return Collections.emptyMap();
    }

    public boolean isAdvancedEnabled() {
        return this.useAdvanced;
    }

    @Override
    public void setFontName(String string) {
        this.fontName = string;
    }

    @Override
    public void setFullName(String string) {
        this.fullName = string;
    }

    @Override
    public void setFamilyNames(Set<String> set) {
        this.familyNames = new HashSet<String>(set);
    }

    public void setFontSubFamilyName(String string) {
        this.fontSubName = string;
    }

    @Override
    public void setEmbedFileName(String string) {
        this.embedFileName = string;
    }

    @Override
    public void setEmbedResourceName(String string) {
        this.embedResourceName = string;
    }

    @Override
    public void setEmbeddingMode(EmbeddingMode embeddingMode) {
        this.embeddingMode = embeddingMode;
    }

    @Override
    public void setCapHeight(int n) {
        this.capHeight = n;
    }

    public void setXHeight(int n) {
        this.xHeight = n;
    }

    @Override
    public void setAscender(int n) {
        this.ascender = n;
    }

    @Override
    public void setDescender(int n) {
        this.descender = n;
    }

    @Override
    public void setFontBBox(int[] nArray) {
        this.fontBBox = nArray;
    }

    @Override
    public void setFlags(int n) {
        this.flags = n;
    }

    public void setWeight(int n) {
        n = n / 100 * 100;
        n = Math.max(100, n);
        this.weight = n = Math.min(900, n);
    }

    @Override
    public void setStemV(int n) {
        this.stemV = n;
    }

    @Override
    public void setItalicAngle(int n) {
        this.italicAngle = n;
    }

    @Override
    public void setMissingWidth(int n) {
        this.missingWidth = n;
    }

    @Override
    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    @Override
    public void setFirstChar(int n) {
        this.firstChar = n;
    }

    @Override
    public void setLastChar(int n) {
        this.lastChar = n;
    }

    @Override
    public void setKerningEnabled(boolean bl) {
        this.useKerning = bl;
    }

    @Override
    public void setAdvancedEnabled(boolean bl) {
        this.useAdvanced = bl;
    }

    public void setResolver(FontResolver fontResolver) {
        this.resolver = fontResolver;
    }

    @Override
    public void putKerningEntry(Integer n, Map<Integer, Integer> map) {
        if (this.kerning == null) {
            this.kerning = new HashMap<Integer, Map<Integer, Integer>>();
        }
        this.kerning.put(n, map);
    }

    public void replaceKerningMap(Map<Integer, Map<Integer, Integer>> map) {
        this.kerning = map == null ? Collections.emptyMap() : map;
    }

    public void setCMap(CMapSegment[] cMapSegmentArray) {
        this.cmap = new CMapSegment[cMapSegmentArray.length];
        System.arraycopy(cMapSegmentArray, 0, this.cmap, 0, cMapSegmentArray.length);
    }

    public CMapSegment[] getCMap() {
        CMapSegment[] cMapSegmentArray = new CMapSegment[this.cmap.length];
        System.arraycopy(this.cmap, 0, cMapSegmentArray, 0, this.cmap.length);
        return cMapSegmentArray;
    }
}

