/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class StringProperty
extends Property {
    private static final PropertyCache<StringProperty> CACHE = new PropertyCache();
    public static final StringProperty EMPTY_STRING_PROPERTY = new StringProperty("");
    private final String str;

    private StringProperty(String string) {
        this.str = string;
    }

    public static StringProperty getInstance(String string) {
        if ("".equals(string) || string == null) {
            return EMPTY_STRING_PROPERTY;
        }
        return CACHE.fetch(new StringProperty(string));
    }

    public Object getObject() {
        return this.str;
    }

    public String getString() {
        return this.str;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)object;
            return stringProperty.str == this.str || stringProperty.str.equals(this.str);
        }
        return false;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property make(PropertyList propertyList, String string, FObj fObj) {
            int n = string.length() - 1;
            if (n > 0) {
                String string2;
                char c = string.charAt(0);
                if (c == '\"' || c == '\'') {
                    if (string.charAt(n) == c) {
                        return new StringProperty(string.substring(1, n));
                    }
                    Property.log.warn((Object)("String-valued property starts with quote but doesn't end with quote: " + string));
                }
                if ((string2 = this.checkValueKeywords(string)) != null) {
                    string = string2;
                }
            }
            return StringProperty.getInstance(string);
        }
    }
}

