/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyCache<T> {
    private static final Log LOG = LogFactory.getLog(PropertyCache.class);
    private final boolean useCache;
    private final ConcurrentMap<Integer, WeakReference<T>> map;
    private final AtomicInteger putCounter;
    private final Lock cleanupLock;
    private final AtomicInteger hashCodeCollisionCounter;

    public PropertyCache() {
        boolean bl;
        try {
            bl = Boolean.valueOf(System.getProperty("org.apache.fop.fo.properties.use-cache", "true"));
        }
        catch (SecurityException securityException) {
            bl = true;
            LOG.info((Object)"Unable to access org.apache.fop.fo.properties.use-cache due to security restriction; defaulting to 'true'.");
        }
        if (bl) {
            this.map = new ConcurrentHashMap<Integer, WeakReference<T>>();
            this.putCounter = new AtomicInteger();
            this.cleanupLock = new ReentrantLock();
            this.hashCodeCollisionCounter = new AtomicInteger();
        } else {
            this.map = null;
            this.putCounter = null;
            this.cleanupLock = null;
            this.hashCodeCollisionCounter = null;
        }
        this.useCache = bl;
    }

    public T fetch(T t) {
        Object t2;
        if (!this.useCache) {
            return t;
        }
        if (t == null) {
            return null;
        }
        Integer n = t.hashCode();
        WeakReference<T> weakReference = (WeakReference<T>)this.map.get(n);
        if (weakReference == null) {
            weakReference = this.map.putIfAbsent(n, new WeakReference<T>(t));
            this.attemptCleanup();
            if (weakReference == null) {
                return t;
            }
        }
        if ((t2 = weakReference.get()) != null) {
            if (this.eq(t2, t)) {
                return t2;
            }
            if (this.hashCodeCollisionCounter.incrementAndGet() % 10 == 0) {
                LOG.info((Object)(this.hashCodeCollisionCounter.get() + " hashCode() collisions for " + t.getClass().getName()));
            }
        }
        this.map.put(n, new WeakReference<T>(t));
        this.attemptCleanup();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptCleanup() {
        if (this.putCounter.incrementAndGet() % 10000 != 0) {
            return;
        }
        if (this.cleanupLock.tryLock()) {
            try {
                this.cleanReclaimedMapEntries();
            }
            finally {
                this.cleanupLock.unlock();
            }
        }
    }

    private void cleanReclaimedMapEntries() {
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            WeakReference weakReference = (WeakReference)entry.getValue();
            Object t = weakReference.get();
            if (t != null) continue;
            iterator.remove();
        }
    }

    private boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }
}

