/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public final class EnumProperty
extends Property {
    private static final PropertyCache<EnumProperty> CACHE = new PropertyCache();
    private final int value;
    private final String text;

    private EnumProperty(int n, String string) {
        this.value = n;
        this.text = string;
    }

    public static EnumProperty getInstance(int n, String string) {
        return CACHE.fetch(new EnumProperty(n, string));
    }

    public int getEnum() {
        return this.value;
    }

    public Object getObject() {
        return this.text;
    }

    public boolean equals(Object object) {
        if (object instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)object;
            return this.value == enumProperty.value && CompareUtil.equal(this.text, enumProperty.text);
        }
        return false;
    }

    public int hashCode() {
        return this.value + this.text.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property checkEnumValues(String string) {
            return super.checkEnumValues(string);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof EnumProperty) {
                return property;
            }
            return super.convertProperty(property, propertyList, fObj);
        }
    }
}

