/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class CorrespondingPropertyMaker {
    protected PropertyMaker baseMaker;
    protected int lrtb;
    protected int rltb;
    protected int tbrl;
    protected int tblr;
    protected boolean useParent;
    private boolean relative;

    public CorrespondingPropertyMaker(PropertyMaker propertyMaker) {
        this.baseMaker = propertyMaker;
        propertyMaker.setCorresponding(this);
    }

    public void setCorresponding(int n, int n2, int n3, int n4) {
        this.lrtb = n;
        this.rltb = n2;
        this.tbrl = n3;
        this.tblr = n4;
    }

    public void setUseParent(boolean bl) {
        this.useParent = bl;
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public boolean isCorrespondingForced(PropertyList propertyList) {
        int n;
        if (!this.relative) {
            return false;
        }
        PropertyList propertyList2 = this.getWMPropertyList(propertyList);
        return propertyList2 != null && propertyList2.getExplicit(n = propertyList2.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr)) != null;
    }

    public Property compute(PropertyList propertyList) throws PropertyException {
        PropertyList propertyList2 = this.getWMPropertyList(propertyList);
        if (propertyList2 == null) {
            return null;
        }
        int n = propertyList2.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr);
        Property property = propertyList.getExplicitOrShorthand(n);
        if (property != null) {
            FObj fObj = propertyList.getParentFObj();
            property = this.baseMaker.convertProperty(property, propertyList, fObj);
        }
        return property;
    }

    protected PropertyList getWMPropertyList(PropertyList propertyList) {
        if (this.useParent) {
            return propertyList.getParentPropertyList();
        }
        return propertyList;
    }
}

