/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.List;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.util.CompareUtil;

public final class CommonFont {
    private static final PropertyCache<CommonFont> CACHE = new PropertyCache();
    private int hash = -1;
    private final FontFamilyProperty fontFamily;
    private final EnumProperty fontSelectionStrategy;
    private final EnumProperty fontStretch;
    private final EnumProperty fontStyle;
    private final EnumProperty fontVariant;
    private final EnumProperty fontWeight;
    public final Length fontSize;
    public final Numeric fontSizeAdjust;

    private CommonFont(FontFamilyProperty fontFamilyProperty, EnumProperty enumProperty, EnumProperty enumProperty2, EnumProperty enumProperty3, EnumProperty enumProperty4, EnumProperty enumProperty5, Length length, Numeric numeric) {
        this.fontFamily = fontFamilyProperty;
        this.fontSelectionStrategy = enumProperty;
        this.fontStretch = enumProperty2;
        this.fontStyle = enumProperty3;
        this.fontVariant = enumProperty4;
        this.fontWeight = enumProperty5;
        this.fontSize = length;
        this.fontSizeAdjust = numeric;
    }

    public static CommonFont getInstance(PropertyList propertyList) throws PropertyException {
        FontFamilyProperty fontFamilyProperty = (FontFamilyProperty)propertyList.get(101);
        EnumProperty enumProperty = (EnumProperty)propertyList.get(102);
        EnumProperty enumProperty2 = (EnumProperty)propertyList.get(105);
        EnumProperty enumProperty3 = (EnumProperty)propertyList.get(106);
        EnumProperty enumProperty4 = (EnumProperty)propertyList.get(107);
        EnumProperty enumProperty5 = (EnumProperty)propertyList.get(108);
        Numeric numeric = propertyList.get(104).getNumeric();
        Length length = propertyList.get(103).getLength();
        CommonFont commonFont = new CommonFont(fontFamilyProperty, enumProperty, enumProperty2, enumProperty3, enumProperty4, enumProperty5, length, numeric);
        return CACHE.fetch(commonFont);
    }

    private String[] getFontFamily() {
        List<Property> list = this.fontFamily.getList();
        String[] stringArray = new String[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getString();
        }
        return stringArray;
    }

    public String getFirstFontFamily() {
        return ((Property)this.fontFamily.list.get(0)).getString();
    }

    public int getFontSelectionStrategy() {
        return this.fontSelectionStrategy.getEnum();
    }

    public int getFontStretch() {
        return this.fontStretch.getEnum();
    }

    public int getFontStyle() {
        return this.fontStyle.getEnum();
    }

    public int getFontVariant() {
        return this.fontVariant.getEnum();
    }

    public int getFontWeight() {
        return this.fontWeight.getEnum();
    }

    public Length getFontSize() {
        return this.fontSize;
    }

    public Numeric getFontSizeAdjust() {
        return this.fontSizeAdjust;
    }

    public FontTriplet[] getFontState(FontInfo fontInfo) {
        String string;
        int n;
        switch (this.fontWeight.getEnum()) {
            case 169: {
                n = 100;
                break;
            }
            case 170: {
                n = 200;
                break;
            }
            case 171: {
                n = 300;
                break;
            }
            case 172: {
                n = 400;
                break;
            }
            case 173: {
                n = 500;
                break;
            }
            case 174: {
                n = 600;
                break;
            }
            case 175: {
                n = 700;
                break;
            }
            case 176: {
                n = 800;
                break;
            }
            case 177: {
                n = 900;
                break;
            }
            default: {
                n = 400;
            }
        }
        switch (this.fontStyle.getEnum()) {
            case 164: {
                string = "italic";
                break;
            }
            case 165: {
                string = "oblique";
                break;
            }
            case 166: {
                string = "backslant";
                break;
            }
            default: {
                string = "normal";
            }
        }
        FontTriplet[] fontTripletArray = fontInfo.fontLookup(this.getFontFamily(), string, n);
        return fontTripletArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CommonFont)) {
            return false;
        }
        CommonFont commonFont = (CommonFont)object;
        return CompareUtil.equal(this.fontFamily, commonFont.fontFamily) && CompareUtil.equal(this.fontSelectionStrategy, commonFont.fontSelectionStrategy) && CompareUtil.equal(this.fontSize, commonFont.fontSize) && CompareUtil.equal(this.fontSizeAdjust, commonFont.fontSizeAdjust) && CompareUtil.equal(this.fontStretch, commonFont.fontStretch) && CompareUtil.equal(this.fontStyle, commonFont.fontStyle) && CompareUtil.equal(this.fontVariant, commonFont.fontVariant) && CompareUtil.equal(this.fontWeight, commonFont.fontWeight);
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n = 17;
            n = 37 * n + CompareUtil.getHashCode(this.fontSize);
            n = 37 * n + CompareUtil.getHashCode(this.fontSizeAdjust);
            n = 37 * n + CompareUtil.getHashCode(this.fontFamily);
            n = 37 * n + CompareUtil.getHashCode(this.fontSelectionStrategy);
            n = 37 * n + CompareUtil.getHashCode(this.fontStretch);
            n = 37 * n + CompareUtil.getHashCode(this.fontStyle);
            n = 37 * n + CompareUtil.getHashCode(this.fontVariant);
            this.hash = n = 37 * n + CompareUtil.getHashCode(this.fontWeight);
        }
        return this.hash;
    }
}

