/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination.bookmarks;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTitle;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.Locator;

public class Bookmark
extends FObj
implements CommonAccessibilityHolder {
    private BookmarkTitle bookmarkTitle;
    private ArrayList childBookmarks = new ArrayList();
    private CommonAccessibility commonAccessibility;
    private String internalDestination;
    private String externalDestination;
    private boolean bShow = true;

    public Bookmark(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.externalDestination = propertyList.get(94).getString();
        this.internalDestination = propertyList.get(128).getString();
        boolean bl = this.bShow = propertyList.get(234).getEnum() == 130;
        if (this.internalDestination.length() > 0) {
            this.externalDestination = null;
        } else if (this.externalDestination.length() == 0) {
            this.getFOValidationEventProducer().missingLinkDestination(this, this.getName(), this.locator);
        } else {
            this.getFOValidationEventProducer().unimplementedFeature(this, this.getName(), "external-destination", this.getLocator());
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("bookmark-title")) {
                if (this.bookmarkTitle != null) {
                    this.tooManyNodesError(locator, "fo:bookmark-title");
                }
            } else if (string2.equals("bookmark")) {
                if (this.bookmarkTitle == null) {
                    this.nodesOutOfOrderError(locator, "fo:bookmark-title", "fo:bookmark");
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    protected void endOfNode() throws FOPException {
        if (this.bookmarkTitle == null) {
            this.missingChildElementError("(bookmark-title, bookmark*)");
        }
    }

    protected void addChildNode(FONode fONode) {
        if (fONode instanceof BookmarkTitle) {
            this.bookmarkTitle = (BookmarkTitle)fONode;
        } else if (fONode instanceof Bookmark) {
            this.childBookmarks.add(fONode);
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public String getBookmarkTitle() {
        return this.bookmarkTitle == null ? "" : this.bookmarkTitle.getTitle();
    }

    public String getInternalDestination() {
        return this.internalDestination;
    }

    public String getExternalDestination() {
        return this.externalDestination;
    }

    public boolean showChildItems() {
        return this.bShow;
    }

    public ArrayList getChildBookmarks() {
        return this.childBookmarks;
    }

    public String getLocalName() {
        return "bookmark";
    }

    public int getNameId() {
        return 6;
    }
}

