/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.ConditionalPageMasterReference;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.fo.properties.Property;
import org.xml.sax.Locator;

public class RepeatablePageMasterAlternatives
extends FObj
implements SubSequenceSpecifier {
    private Property maximumRepeats;
    private static final int INFINITE = -1;
    private int numberConsumed = 0;
    private List<ConditionalPageMasterReference> conditionalPageMasterRefs;
    private boolean hasPagePositionLast = false;
    private boolean hasPagePositionOnly = false;

    public RepeatablePageMasterAlternatives(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.maximumRepeats = propertyList.get(156);
    }

    protected void startOfNode() throws FOPException {
        this.conditionalPageMasterRefs = new ArrayList<ConditionalPageMasterReference>();
        assert (this.parent.getName().equals("fo:page-sequence-master"));
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.parent;
        pageSequenceMaster.addSubsequenceSpecifier(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(conditional-page-master-reference+)");
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string) && !string2.equals("conditional-page-master-reference")) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public int getMaximumRepeats() {
        if (this.maximumRepeats.getEnum() == 89) {
            return -1;
        }
        int n = this.maximumRepeats.getNumeric().getValue();
        if (n < 0) {
            log.debug((Object)("negative maximum-repeats: " + this.maximumRepeats));
            n = 0;
        }
        return n;
    }

    public SimplePageMaster getNextPageMaster(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.isInfinite() && this.numberConsumed >= this.getMaximumRepeats()) {
            return null;
        }
        ++this.numberConsumed;
        for (ConditionalPageMasterReference conditionalPageMasterReference : this.conditionalPageMasterRefs) {
            if (!conditionalPageMasterReference.isValid(bl, bl2, bl3, bl4)) continue;
            return conditionalPageMasterReference.getMaster();
        }
        return null;
    }

    public void addConditionalPageMasterReference(ConditionalPageMasterReference conditionalPageMasterReference) {
        this.conditionalPageMasterRefs.add(conditionalPageMasterReference);
        if (conditionalPageMasterReference.getPagePosition() == 72) {
            this.hasPagePositionLast = true;
        }
        if (conditionalPageMasterReference.getPagePosition() == 186) {
            this.hasPagePositionOnly = true;
        }
    }

    public void reset() {
        this.numberConsumed = 0;
    }

    public boolean goToPrevious() {
        if (this.numberConsumed == 0) {
            return false;
        }
        --this.numberConsumed;
        return true;
    }

    public boolean hasPagePositionLast() {
        return this.hasPagePositionLast;
    }

    public boolean hasPagePositionOnly() {
        return this.hasPagePositionOnly;
    }

    public String getLocalName() {
        return "repeatable-page-master-alternatives";
    }

    public int getNameId() {
        return 62;
    }

    public void resolveReferences(LayoutMasterSet layoutMasterSet) throws ValidationException {
        for (ConditionalPageMasterReference conditionalPageMasterReference : this.conditionalPageMasterRefs) {
            conditionalPageMasterReference.resolveReferences(layoutMasterSet);
        }
    }

    public boolean canProcess(String string) {
        boolean bl = true;
        ArrayList<ConditionalPageMasterReference> arrayList = new ArrayList<ConditionalPageMasterReference>();
        for (ConditionalPageMasterReference conditionalPageMasterReference : this.conditionalPageMasterRefs) {
            if (!conditionalPageMasterReference.isValid(true, false, false, false) && !conditionalPageMasterReference.isValid(false, false, false, false)) continue;
            arrayList.add(conditionalPageMasterReference);
        }
        if (!arrayList.isEmpty()) {
            bl = false;
            for (ConditionalPageMasterReference conditionalPageMasterReference : arrayList) {
                bl |= conditionalPageMasterReference.getMaster().getRegion(58).getRegionName().equals(string);
            }
        }
        return bl;
    }

    public boolean isInfinite() {
        return this.getMaximumRepeats() == -1;
    }

    public boolean isReusable() {
        return false;
    }
}

