/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.BorderResolver;
import org.apache.fop.fo.flow.table.CollapsingBorderResolver;
import org.apache.fop.fo.flow.table.EmptyGridUnit;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.SeparateBorderResolver;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;

class FixedColRowGroupBuilder
extends RowGroupBuilder {
    private int numberOfColumns;
    private TableRow currentTableRow = null;
    private int currentRowIndex;
    private List rows;
    private boolean firstInPart = true;
    private List lastRow;
    private BorderResolver borderResolver;

    FixedColRowGroupBuilder(Table table) {
        super(table);
        this.numberOfColumns = table.getNumberOfColumns();
        this.borderResolver = table.isSeparateBorderModel() ? new SeparateBorderResolver() : new CollapsingBorderResolver(table);
        this.initialize();
    }

    private void initialize() {
        this.rows = new ArrayList();
        this.currentRowIndex = 0;
    }

    void addTableCell(TableCell tableCell) {
        int n;
        Object object;
        int n2;
        for (n2 = this.rows.size(); n2 < this.currentRowIndex + tableCell.getNumberRowsSpanned(); ++n2) {
            object = new ArrayList(this.numberOfColumns);
            for (int i = 0; i < this.numberOfColumns; ++i) {
                object.add(null);
            }
            this.rows.add(object);
        }
        n2 = tableCell.getColumnNumber() - 1;
        object = new PrimaryGridUnit(tableCell, n2);
        List list = (List)this.rows.get(this.currentRowIndex);
        list.set(n2, object);
        GridUnit[] gridUnitArray = new GridUnit[tableCell.getNumberColumnsSpanned()];
        gridUnitArray[0] = object;
        for (n = 1; n < tableCell.getNumberColumnsSpanned(); ++n) {
            GridUnit gridUnit = new GridUnit((PrimaryGridUnit)object, n, 0);
            list.set(n2 + n, gridUnit);
            gridUnitArray[n] = gridUnit;
        }
        ((PrimaryGridUnit)object).addRow(gridUnitArray);
        for (n = 1; n < tableCell.getNumberRowsSpanned(); ++n) {
            list = (List)this.rows.get(this.currentRowIndex + n);
            gridUnitArray = new GridUnit[tableCell.getNumberColumnsSpanned()];
            for (int i = 0; i < tableCell.getNumberColumnsSpanned(); ++i) {
                GridUnit gridUnit = new GridUnit((PrimaryGridUnit)object, i, n);
                list.set(n2 + i, gridUnit);
                gridUnitArray[i] = gridUnit;
            }
            ((PrimaryGridUnit)object).addRow(gridUnitArray);
        }
    }

    private static void setFlagForCols(int n, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ((GridUnit)listIterator.next()).setFlag(n);
        }
    }

    void startTableRow(TableRow tableRow) {
        this.currentTableRow = tableRow;
    }

    void endTableRow() {
        Object object;
        assert (this.currentTableRow != null);
        if (this.currentRowIndex > 0 && this.currentTableRow.getBreakBefore() != 9) {
            object = TableEventProducer.Provider.get(this.currentTableRow.getUserAgent().getEventBroadcaster());
            object.breakIgnoredDueToRowSpanning(this, this.currentTableRow.getName(), true, this.currentTableRow.getLocator());
        }
        if (this.currentRowIndex < this.rows.size() - 1 && this.currentTableRow.getBreakAfter() != 9) {
            object = TableEventProducer.Provider.get(this.currentTableRow.getUserAgent().getEventBroadcaster());
            object.breakIgnoredDueToRowSpanning(this, this.currentTableRow.getName(), false, this.currentTableRow.getLocator());
        }
        for (GridUnit gridUnit : (List)this.rows.get(this.currentRowIndex)) {
            if (gridUnit == null) continue;
            gridUnit.setRow(this.currentTableRow);
        }
        this.handleRowEnd(this.currentTableRow);
    }

    void endRow(TablePart tablePart) {
        this.handleRowEnd(tablePart);
    }

    private void handleRowEnd(TableCellContainer tableCellContainer) {
        List list;
        this.lastRow = list = (List)this.rows.get(this.currentRowIndex);
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (list.get(i) != null) continue;
            list.set(i, new EmptyGridUnit(this.table, this.currentTableRow, i));
        }
        this.borderResolver.endRow(list, tableCellContainer);
        if (this.firstInPart) {
            FixedColRowGroupBuilder.setFlagForCols(0, list);
            this.firstInPart = false;
        }
        if (this.currentRowIndex == this.rows.size() - 1) {
            tableCellContainer.getTablePart().addRowGroup(this.rows);
            this.initialize();
        } else {
            ++this.currentRowIndex;
        }
        this.currentTableRow = null;
    }

    void startTablePart(TablePart tablePart) {
        this.firstInPart = true;
        this.borderResolver.startPart(tablePart);
    }

    void endTablePart() throws ValidationException {
        if (this.rows.size() > 0) {
            throw new ValidationException("A table-cell is spanning more rows than available in its parent element.");
        }
        FixedColRowGroupBuilder.setFlagForCols(1, this.lastRow);
        this.borderResolver.endPart();
    }

    void endTable() {
        this.borderResolver.endTable();
    }
}

