/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.Locator;

public class Footnote
extends FObj
implements CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private Inline footnoteCitation = null;
    private FootnoteBody footnoteBody;

    public Footnote(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startFootnote(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        if (this.footnoteCitation == null || this.footnoteBody == null) {
            this.missingChildElementError("(inline,footnote-body)");
        }
        this.getFOEventHandler().endFootnote(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("inline")) {
                if (this.footnoteCitation != null) {
                    this.tooManyNodesError(locator, "fo:inline");
                }
            } else if (string2.equals("footnote-body")) {
                if (this.footnoteCitation == null) {
                    this.nodesOutOfOrderError(locator, "fo:inline", "fo:footnote-body");
                } else if (this.footnoteBody != null) {
                    this.tooManyNodesError(locator, "fo:footnote-body");
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public void addChildNode(FONode fONode) {
        if (fONode.getNameId() == 35) {
            this.footnoteCitation = (Inline)fONode;
        } else if (fONode.getNameId() == 25) {
            this.footnoteBody = (FootnoteBody)fONode;
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public Inline getFootnoteCitation() {
        return this.footnoteCitation;
    }

    public FootnoteBody getFootnoteBody() {
        return this.footnoteBody;
    }

    public String getLocalName() {
        return "footnote";
    }

    public int getNameId() {
        return 24;
    }
}

